/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import fi.dy.masa.enderutilities.inventory.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.InventoryItemCrafting;
import fi.dy.masa.enderutilities.inventory.InventoryStackArray;
import fi.dy.masa.enderutilities.inventory.SlotFuel;
import fi.dy.masa.enderutilities.inventory.SlotGeneric;
import fi.dy.masa.enderutilities.inventory.SlotModule;
import fi.dy.masa.enderutilities.inventory.SlotSmeltable;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.util.SlotRange;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerCreationStation
extends ContainerLargeStacks {
    protected final TileEntityCreationStation tecs;
    public int selectionsLast;
    public int modeMask;
    public int fuelProgress;
    public int smeltProgress;
    public final IInventory[] craftResults;
    public final InventoryItemCrafting[] craftMatrices;
    public final InventoryStackArray furnaceInventory;
    private SlotRange craftingGridSlotsLeft;
    private SlotRange craftingGridSlotsRight;

    public ContainerCreationStation(EntityPlayer player, TileEntityCreationStation te) {
        super(player, te);
        this.tecs = te;
        te.func_70295_k_();
        this.craftMatrices = new InventoryItemCrafting[]{te.getCraftingInventory(0, this, player), te.getCraftingInventory(1, this, player)};
        this.craftResults = new IInventory[]{te.getCraftResultInventory(0), te.getCraftResultInventory(1)};
        this.furnaceInventory = this.tecs.getFurnaceInventory();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(40, 174);
    }

    @Override
    protected void addCustomInventorySlots() {
        int j;
        int i;
        int customInvStart = this.field_75151_b.size();
        int posX = 40;
        int posY = 102;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 9; ++j2) {
                this.func_75146_a(new SlotGeneric(this.tecs.getItemInventory(), i2 * 9 + j2, posX + j2 * 18, posY + i2 * 18));
            }
        }
        this.customInventorySlots = new SlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 4);
        posX = 216;
        posY = 102;
        int min = 6;
        int max = 10;
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotModule(this.tecs, i, posX, posY + i * 18, ItemModule.ModuleType.TYPE_MEMORY_CARD).setMinAndMaxModuleTier(min, max));
        }
        this.craftingGridSlotsLeft = new SlotRange(this.field_75151_b.size(), 9);
        posX = 40;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotGeneric((IInventory)this.craftMatrices[0], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafting(this.player, (IInventory)this.craftMatrices[0], this.craftResults[0], 0, 112, 33));
        this.craftingGridSlotsRight = new SlotRange(this.field_75151_b.size(), 9);
        posX = 148;
        posY = 33;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotGeneric((IInventory)this.craftMatrices[1], j + i * 3, posX + j * 18, posY + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafting(this.player, (IInventory)this.craftMatrices[1], this.craftResults[1], 0, 112, 69));
        this.addMergeSlotRangePlayerToExt(this.field_75151_b.size(), 6);
        this.func_75146_a(new SlotSmeltable(this.furnaceInventory, 0, 8, 8));
        this.func_75146_a(new SlotFuel(this.furnaceInventory, 1, 8, 51));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.furnaceInventory, 2, 40, 8));
        this.func_75146_a(new SlotSmeltable(this.furnaceInventory, 3, 216, 8));
        this.func_75146_a(new SlotFuel(this.furnaceInventory, 4, 216, 51));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.furnaceInventory, 5, 184, 8));
        this.func_75130_a((IInventory)this.craftMatrices[0]);
    }

    public void func_75130_a(IInventory inv) {
        super.func_75130_a(inv);
        this.craftResults[0].func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrices[0], this.player.field_70170_p));
        this.craftResults[1].func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrices[1], this.player.field_70170_p));
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.tecs.func_70305_f();
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResults[0] && slot.field_75224_c != this.craftResults[0] && super.func_94530_a(stack, slot);
    }

    @Override
    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        if (slot.field_75224_c == this.tecs.getItemInventory() || slot.field_75224_c == this.tecs.getFurnaceInventory()) {
            return slot.func_75219_a();
        }
        return super.getMaxStackSizeFromSlotAndStack(slot, stack);
    }

    @Override
    public boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        if (slotNum == 40 || slotNum == 50) {
            int invId;
            int n = invId = slotNum == 50 ? 1 : 0;
            if (!this.tecs.canCraftItems(invId)) {
                return false;
            }
            boolean ret = super.transferStackFromSlot(player, slotNum);
            this.tecs.restockCraftingGrid(invId);
            return ret;
        }
        if ((this.isSlotInRange(this.craftingGridSlotsLeft, slotNum) || this.isSlotInRange(this.craftingGridSlotsRight, slotNum)) && this.transferStackToSlotRange(player, slotNum, this.customInventorySlots.first, this.customInventorySlots.lastExc, false)) {
            return true;
        }
        return super.transferStackFromSlot(player, slotNum);
    }

    @Override
    public ItemStack func_75144_a(int slotNum, int button, int type, EntityPlayer player) {
        if (slotNum == 40 || slotNum == 50) {
            int invId;
            int n = invId = slotNum == 50 ? 1 : 0;
            if (!this.tecs.canCraftItems(invId)) {
                return null;
            }
            ItemStack stack = super.func_75144_a(slotNum, button, type, player);
            this.tecs.restockCraftingGrid(invId);
            return stack;
        }
        return super.func_75144_a(slotNum, button, type, player);
    }

    @Override
    public void middleClickSlot(int slotNum, EntityPlayer player) {
        Slot slot1;
        Slot slot = slot1 = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        if (slot1 != null && slot1.func_75217_a(this.tecs.getItemInventory(), slotNum)) {
            if (this.selectedSlot != -1) {
                if (this.selectedSlot != slotNum) {
                    Slot slot2 = this.func_75139_a(this.selectedSlot);
                    ItemStack stackTmp1 = slot1.func_75211_c();
                    ItemStack stackTmp2 = slot2.func_75211_c();
                    slot1.func_75215_d(stackTmp2);
                    slot2.func_75215_d(stackTmp1);
                    slot1.func_82870_a(player, stackTmp1);
                    slot2.func_82870_a(player, stackTmp2);
                }
                this.selectedSlot = -1;
            } else {
                this.selectedSlot = slotNum;
            }
        }
    }

    @Override
    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModule();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        icrafting.func_71112_a((Container)this, 0, modeMask);
        icrafting.func_71112_a((Container)this, 1, selection);
        icrafting.func_71112_a((Container)this, 2, fuelProgress);
        icrafting.func_71112_a((Container)this, 3, smeltProgress);
        this.func_75142_b();
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.tecs.func_145831_w().field_72995_K) {
            return;
        }
        int modeMask = this.tecs.getModeMask();
        int selection = this.tecs.getQuickMode() << 2 | this.tecs.getSelectedModule();
        int smeltProgress = this.tecs.getSmeltProgressScaled(1, 100) << 8 | this.tecs.getSmeltProgressScaled(0, 100);
        int fuelProgress = this.tecs.getBurnTimeRemainingScaled(1, 100) << 8 | this.tecs.getBurnTimeRemainingScaled(0, 100);
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.modeMask != modeMask) {
                icrafting.func_71112_a((Container)this, 0, modeMask);
            }
            if (this.selectionsLast != selection) {
                icrafting.func_71112_a((Container)this, 1, selection);
            }
            if (this.fuelProgress != fuelProgress) {
                icrafting.func_71112_a((Container)this, 2, fuelProgress);
            }
            if (this.smeltProgress == smeltProgress) continue;
            icrafting.func_71112_a((Container)this, 3, smeltProgress);
        }
        this.modeMask = modeMask;
        this.selectionsLast = selection;
        this.fuelProgress = fuelProgress;
        this.smeltProgress = smeltProgress;
    }

    public void func_75137_b(int var, int val) {
        super.func_75137_b(var, val);
        switch (var) {
            case 0: {
                this.modeMask = val;
                break;
            }
            case 1: {
                this.tecs.setSelectedModule(val & 3);
                this.tecs.setQuickMode(val >> 2 & 7);
                this.tecs.inventoryChanged(1);
                break;
            }
            case 2: {
                this.fuelProgress = val;
                break;
            }
            case 3: {
                this.smeltProgress = val;
                break;
            }
        }
    }
}

