/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererEnergyBridge
extends TileEntitySpecialRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/beacon_beam.png");

    public void renderBeamVertical(double x, double y, double z, double yMin, double yMax, double radius, double rot, double flowSpeed, boolean powered) {
        int i;
        Tessellator tessellator = Tessellator.field_78398_a;
        double tx1 = 0.0;
        double tx2 = 0.0;
        double tz1 = 0.0;
        double tz2 = 0.0;
        double angle = 0.0;
        double vScale = yMax - yMin;
        double v1 = -rot * flowSpeed;
        double v2 = vScale * 2.0 + v1;
        int r_i = powered ? 160 : 255;
        int g_i = powered ? 255 : 160;
        int b_i = powered ? 230 : 160;
        int r_o = powered ? 210 : 255;
        int g_o = powered ? 255 : 160;
        int b_o = powered ? 230 : 160;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.func_147499_a(TEXTURE);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        tessellator.func_78382_b();
        tessellator.func_78370_a(r_i, g_i, b_i, 200);
        for (i = 0; i < 8; ++i) {
            tx1 = Math.sin(rot + angle) * radius;
            tz1 = Math.cos(rot + angle) * radius;
            tx2 = Math.sin(rot + (angle += 0.7853981633974483)) * radius;
            tz2 = Math.cos(rot + angle) * radius;
            tessellator.func_78374_a(tx1, yMin, tz1, 0.125, v1);
            tessellator.func_78374_a(tx1, yMax, tz1, 0.125, v2);
            tessellator.func_78374_a(tx2, yMax, tz2, 0.875, v2);
            tessellator.func_78374_a(tx2, yMin, tz2, 0.875, v1);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        v1 = -rot * flowSpeed * 3.0;
        v2 = vScale * 2.0 + v1;
        radius *= 2.0;
        rot = 0.39269908169872414;
        tessellator.func_78382_b();
        tessellator.func_78370_a(r_o, g_o, b_o, 80);
        for (i = 0; i < 8; ++i) {
            tx1 = Math.sin(rot + angle) * radius;
            tz1 = Math.cos(rot + angle) * radius;
            tx2 = Math.sin(rot + (angle += 0.7853981633974483)) * radius;
            tz2 = Math.cos(rot + angle) * radius;
            tessellator.func_78374_a(tx1, yMin, tz1, 0.125, v1);
            tessellator.func_78374_a(tx1, yMax, tz1, 0.125, v2);
            tessellator.func_78374_a(tx2, yMax, tz2, 0.875, v2);
            tessellator.func_78374_a(tx2, yMin, tz2, 0.875, v1);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    public void renderTileEntityAt(TileEntityEnergyBridge teeb, double x, double y, double z, float pTicks) {
        if (!teeb.isActive) {
            return;
        }
        int meta = teeb.func_145832_p();
        double rot = (double)teeb.func_145831_w().func_82737_E() % 100.0 * Math.PI / 50.0 + 0.06283185307179587 * (double)pTicks;
        x += 0.5;
        z += 0.5;
        if (meta == 0) {
            this.renderBeamVertical(x, y, z, teeb.beamYMin - teeb.field_145848_d, 0.0, 0.2, rot, 3.0, teeb.isPowered);
            this.renderBeamVertical(x, y, z, 1.0, teeb.beamYMax - teeb.field_145848_d, 0.2, rot, 3.0, teeb.isPowered);
        } else if (meta == 1) {
            this.renderBeamVertical(x, y, z, teeb.beamYMin - teeb.field_145848_d, 0.0, 0.2, rot, 3.0, teeb.isPowered);
            this.renderBeamVertical(x, y, z, 1.0, teeb.beamYMax - teeb.field_145848_d, 0.2, rot, -3.0, teeb.isPowered);
        } else if (meta == 2) {
            ForgeDirection dirFront = ForgeDirection.getOrientation((int)teeb.getRotation());
            ForgeDirection dirSide = dirFront.getRotation(ForgeDirection.UP);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5 * (double)dirFront.offsetX), (double)(y + 0.5), (double)(z + 0.5 * (double)dirFront.offsetZ));
            GL11.glRotated((double)90.0, (double)(-dirSide.offsetX), (double)0.0, (double)(-dirSide.offsetZ));
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
            this.renderBeamVertical(x, y, z, 0.0, 2.0, 0.2, rot, 3.0, teeb.isPowered);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.3 * (double)dirSide.offsetX - 0.2 * (double)dirFront.offsetX), (double)(y + 0.5), (double)(z + 0.3 * (double)dirSide.offsetZ - 0.2 * (double)dirFront.offsetZ));
            GL11.glRotated((double)90.0, (double)dirFront.offsetX, (double)0.0, (double)dirFront.offsetZ);
            GL11.glRotated((double)45.0, (double)(-dirSide.offsetX), (double)0.0, (double)(-dirSide.offsetZ));
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
            this.renderBeamVertical(x, y, z, 0.0, 4.2, 0.14, rot, 3.0, teeb.isPowered);
            GL11.glPopMatrix();
        }
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        this.renderTileEntityAt((TileEntityEnergyBridge)te, x, y, z, f);
    }
}

