/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BuildersWandRenderer {
    public Minecraft mc = Minecraft.func_71410_x();
    public float partialTicksLast;
    List<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ItemStack stack = this.mc.field_71439_g.func_71045_bC();
        if (stack == null || stack.func_77973_b() != EnderUtilitiesItems.buildersWand) {
            return;
        }
        this.renderSelectedArea((World)this.mc.field_71441_e, (EntityPlayer)this.mc.field_71439_g, stack, event.partialTicks);
    }

    public static AxisAlignedBB makeBlockBoundingBox(int x, int y, int z, double partialTicks, EntityPlayer player) {
        double offset1 = 0.0;
        double offset2 = 1.0;
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return AxisAlignedBB.func_72330_a((double)((double)x - offset1 - dx), (double)((double)y - offset1 - dy), (double)((double)z - offset1 - dz), (double)((double)x + offset2 - dx), (double)((double)y + offset2 - dy), (double)((double)z + offset2 - dz));
    }

    public void renderSelectedArea(World world, EntityPlayer player, ItemStack stack, float partialTicks) {
        ItemBuildersWand item = (ItemBuildersWand)stack.func_77973_b();
        BlockPosEU posTargeted = item.getPosition(stack, true);
        MovingObjectPosition mop = this.mc.field_71476_x;
        if (posTargeted == null && mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (player.func_70093_af() && ForgeDirection.getOrientation((int)mop.field_72310_e) == ForgeDirection.UP) {
                return;
            }
            posTargeted = new BlockPosEU(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, player.field_71093_bK, mop.field_72310_e);
        }
        if (posTargeted == null || player.field_71093_bK != posTargeted.dimension) {
            return;
        }
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        BlockPosEU posStart = posTargeted.offset(ForgeDirection.getOrientation((int)posTargeted.face), 1);
        BlockPosEU posEnd = item.getPosition(stack, false);
        BlockPosEU blockPosEU = posEnd = posEnd != null && (mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE) ? posEnd.offset(ForgeDirection.getOrientation((int)posEnd.face), 1) : null;
        if (partialTicks < this.partialTicksLast) {
            this.positions.clear();
            if (mode == ItemBuildersWand.Mode.CUBE || mode == ItemBuildersWand.Mode.WALLS) {
                item.getBlockPositionsWalls(stack, posTargeted, world, this.positions, posStart, posEnd);
            } else {
                item.getBlockPositions(stack, posTargeted, world, this.positions);
            }
        }
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glPushMatrix();
        boolean renderGhostBlocks = NBTUtils.getBoolean(stack, "BuildersWand", "Ghost");
        if (renderGhostBlocks) {
            this.renderGhostBlocks(player, partialTicks);
        }
        GL11.glDisable((int)3553);
        if (!renderGhostBlocks) {
            this.renderBlockOutlines(player, posStart, posEnd, partialTicks);
        }
        this.renderStartAndEndPositions(mode, player, posStart, posEnd, partialTicks);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    public void renderBlockOutlines(EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        GL11.glLineWidth((float)2.0f);
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPosEU pos = this.positions.get(i);
            if (pos.equals(posStart) || posEnd != null && posEnd.equals(pos)) continue;
            AxisAlignedBB aabb = BuildersWandRenderer.makeBlockBoundingBox(pos.posX, pos.posY, pos.posZ, partialTicks, player);
            RenderGlobal.func_147590_a((AxisAlignedBB)aabb, (int)0xFFFFFF);
        }
    }

    public void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        AxisAlignedBB aabb;
        if (posStart != null) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posStart.posX, posStart.posY, posStart.posZ, partialTicks, player);
            RenderGlobal.func_147590_a((AxisAlignedBB)aabb, (int)0xFF1111);
        }
        if (posEnd != null && (mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE)) {
            GL11.glLineWidth((float)3.0f);
            aabb = BuildersWandRenderer.makeBlockBoundingBox(posEnd.posX, posEnd.posY, posEnd.posZ, partialTicks, player);
            RenderGlobal.func_147590_a((AxisAlignedBB)aabb, (int)0x1111FF);
        }
    }

    public void renderGhostBlocks(EntityPlayer player, float partialTicks) {
        BlockPosStateDist pos;
        int i;
        RenderBlocks rb = new RenderBlocks();
        GL11.glBlendFunc((int)770, (int)771);
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glPushMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
        GL11.glEnable((int)32823);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (partialTicks < this.partialTicksLast) {
            for (i = 0; i < this.positions.size(); ++i) {
                pos = this.positions.get(i);
                pos.setSquaredDistance(pos.getSquaredDistanceFrom(dx, dy, dz));
            }
            Collections.sort(this.positions);
            Collections.reverse(this.positions);
        }
        for (i = 0; i < this.positions.size(); ++i) {
            pos = this.positions.get(i);
            BlockInfo blockInfo = pos.blockInfo;
            if (blockInfo == null || blockInfo.block == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)pos.posX - dx + 0.5), (double)((double)pos.posY - dy + 0.5), (double)((double)pos.posZ - dz + 0.5));
            rb.func_147800_a(blockInfo.block, blockInfo.meta, 1.0f);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glDisable((int)32823);
        GL11.glEnable((int)3008);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }
}

