/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.init.recipes;

import com.google.common.base.Preconditions;
import com.nauktis.solarflux.SolarFluxMod;
import com.nauktis.solarflux.init.ModBlocks;
import com.nauktis.solarflux.init.ModItems;
import com.nauktis.solarflux.init.recipes.VanillaRecipeRegistrar;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ThermalExpansionRecipeRegistrar
extends VanillaRecipeRegistrar {
    @Override
    protected void registerCell1Recipe() {
        if (!this.addSmelterRecipe(8000, new ItemStack(ModItems.mMirror), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(ModItems.mSolarCell1))) {
            super.registerCell1Recipe();
        }
    }

    @Override
    protected void registerCell2Recipe() {
        if (!this.addSmelterRecipe(8000, new ItemStack(ModItems.mSolarCell1), new ItemStack(Items.field_151119_aD, 16), new ItemStack(ModItems.mSolarCell2))) {
            super.registerCell2Recipe();
        }
    }

    @Override
    protected void registerCell3Recipe() {
        Fluid glowstone = FluidRegistry.getFluid((String)"glowstone");
        if (glowstone == null || !this.addTransposerRecipe(8000, new ItemStack(ModItems.mSolarCell2), new ItemStack(ModItems.mSolarCell3), new FluidStack(glowstone, 2000))) {
            super.registerCell3Recipe();
        }
    }

    @Override
    protected void registerCell4Recipe() {
        if (!this.addSmelterRecipe(8000, new ItemStack(ModItems.mSolarCell3), new ItemStack(Items.field_151072_bj, 2), new ItemStack(ModItems.mSolarCell4))) {
            super.registerCell4Recipe();
        }
    }

    @Override
    protected void registerSolarPanel1() {
        try {
            ItemStack powerCoilGold = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilGold", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(1), new Object[]{"sss", "scs", "sss", Character.valueOf('s'), ModBlocks.getSolarPanels().get(0), Character.valueOf('c'), powerCoilGold}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel1();
        }
    }

    @Override
    protected void registerSolarPanel2() {
        try {
            ItemStack frameMachineBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineBasic", (int)1));
            ItemStack cellBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameCellBasic", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(2), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell1, Character.valueOf('s'), ModBlocks.getSolarPanels().get(1), Character.valueOf('c'), frameMachineBasic, Character.valueOf('b'), cellBasic}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel2();
        }
    }

    @Override
    protected void registerSolarPanel3() {
        try {
            ItemStack frameMachineHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineHardened", (int)1));
            ItemStack cellHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameCellHardened", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(3), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell2, Character.valueOf('s'), ModBlocks.getSolarPanels().get(2), Character.valueOf('c'), frameMachineHardened, Character.valueOf('b'), cellHardened}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel3();
        }
    }

    @Override
    protected void registerSolarPanel4() {
        try {
            ItemStack frameMachineReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineReinforced", (int)1));
            ItemStack cellReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameCellReinforcedFull", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(4), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell3, Character.valueOf('s'), ModBlocks.getSolarPanels().get(3), Character.valueOf('c'), frameMachineReinforced, Character.valueOf('b'), cellReinforced}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel4();
        }
    }

    @Override
    protected void registerSolarPanel5() {
        try {
            ItemStack frameMachineResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineResonant", (int)1));
            ItemStack cellResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameCellResonantFull", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(5), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.getSolarPanels().get(4), Character.valueOf('c'), frameMachineResonant, Character.valueOf('b'), cellResonant}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel5();
        }
    }

    @Override
    protected void registerSolarPanel(int pTier) {
        try {
            ItemStack powerCoilElectrum = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilElectrum", (int)1));
            ItemStack cellResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameCellResonantFull", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(pTier), new Object[]{"ece", "sbs", "ece", Character.valueOf('e'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.getSolarPanels().get(pTier - 1), Character.valueOf('c'), powerCoilElectrum, Character.valueOf('b'), cellResonant}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerSolarPanel(pTier);
        }
    }

    @Override
    protected void registerUpgradeTransferRate() {
        try {
            ItemStack powerCoilGold = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilGold", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeTransferRate, new Object[]{"www", "cuc", "www", Character.valueOf('w'), "plankWood", Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('c'), powerCoilGold}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerUpgradeTransferRate();
        }
    }

    @Override
    protected void registerUpgradeCapacity() {
        try {
            ItemStack cellBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"cellBasic", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeCapacity, new Object[]{" r ", "rur", "rcr", Character.valueOf('r'), "dustRedstone", Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('c'), cellBasic}));
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipe. Cause: %s", "ThermalExpansion", e);
            e.printStackTrace();
            super.registerUpgradeCapacity();
        }
    }

    private boolean addSmelterRecipe(int pEnergy, ItemStack pPrimaryInput, ItemStack pSecondaryInput, ItemStack pOutput) {
        try {
            Class<?> klass = Class.forName("cofh.api.modhelpers.ThermalExpansionHelper");
            Method method = klass.getMethod("addSmelterRecipe", Integer.TYPE, ItemStack.class, ItemStack.class, ItemStack.class);
            method.invoke(null, pEnergy, pPrimaryInput, pSecondaryInput, pOutput);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SolarFluxMod.log.info("Failed to register %s smelter recipe.", "ThermalExpansion");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean addTransposerRecipe(int pEnergy, ItemStack pInput, ItemStack pOutput, FluidStack pFluid) {
        try {
            Class<?> klass = Class.forName("cofh.api.modhelpers.ThermalExpansionHelper");
            Method method = klass.getMethod("addTransposerFill", Integer.TYPE, ItemStack.class, ItemStack.class, FluidStack.class, Boolean.TYPE);
            method.invoke(null, pEnergy, pInput, pOutput, pFluid, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

