/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.init;

import com.google.common.collect.Lists;
import com.nauktis.core.block.BaseModBlock;
import com.nauktis.core.block.icon.ConnectedIconHandler;
import com.nauktis.core.block.icon.IBlockIconHandler;
import com.nauktis.core.block.icon.SingleIconHandler;
import com.nauktis.core.block.icon.TopIconHandler;
import com.nauktis.solarflux.SolarFluxMod;
import com.nauktis.solarflux.blocks.SolarPanelBlock;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.items.SolarPanelItemBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;

public class ModBlocks {
    private static final List<BaseModBlock> mSolarPanels = Lists.newArrayList();

    private ModBlocks() {
    }

    public static void initialize() {
        SolarFluxMod.log.info("Registering blocks", new Object[0]);
        mSolarPanels.clear();
        for (int tierIndex = 0; tierIndex < ModConfiguration.getTierConfigurations().size(); ++tierIndex) {
            int registeredTierName = tierIndex + 1;
            int textureTierIndex = Math.min(tierIndex, ModConfiguration.DEFAULT_TIER_CONFIGURATIONS.size() - 1);
            IBlockIconHandler topHandler = new SingleIconHandler("SolarFlux", "solar" + textureTierIndex + "_0");
            if (ModConfiguration.useConnectedTextures()) {
                topHandler = new ConnectedIconHandler("SolarFlux", "solar" + textureTierIndex + "_");
            }
            SingleIconHandler sideHandler = new SingleIconHandler("SolarFlux", "solar" + textureTierIndex + "_side");
            TopIconHandler iconHandler = new TopIconHandler(topHandler, sideHandler);
            SolarPanelBlock block = new SolarPanelBlock("solar" + tierIndex, iconHandler, tierIndex);
            GameRegistry.registerBlock((Block)block, SolarPanelItemBlock.class, (String)("solar" + registeredTierName));
            mSolarPanels.add(block);
        }
    }

    public static List<BaseModBlock> getSolarPanels() {
        return mSolarPanels;
    }
}

