/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import com.nauktis.core.block.BaseModBlockWithTileEntity;
import com.nauktis.core.block.icon.IBlockIconHandler;
import com.nauktis.core.utility.Utils;
import com.nauktis.solarflux.SolarFluxMod;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.creativetab.ModCreativeTab;
import com.nauktis.solarflux.utility.Lang;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class SolarPanelBlock
extends BaseModBlockWithTileEntity {
    private final int mTierIndex;
    private IIcon mBlockSideIcon;

    public SolarPanelBlock(String pName, IBlockIconHandler pBlockIconHandler, int pTierIndex) {
        super("SolarFlux", pName, pBlockIconHandler);
        this.mTierIndex = pTierIndex;
        this.func_149647_a(ModCreativeTab.MOD_TAB);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        if (!ModConfiguration.isSolarPanelFullBlock()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, ModConfiguration.getSolarPanelHeight(), 1.0f);
            this.func_149713_g(255);
            this.field_149783_u = true;
        }
    }

    public boolean func_149686_d() {
        return ModConfiguration.isSolarPanelFullBlock() && super.func_149686_d();
    }

    public boolean func_149662_c() {
        return ModConfiguration.isSolarPanelFullBlock() && super.func_149662_c();
    }

    public TileEntity func_149915_a(World pWorld, int pMetadata) {
        return new SolarPanelTileEntity(this.mTierIndex);
    }

    public void func_149689_a(World pWorld, int pX, int pY, int pZ, EntityLivingBase pEntity, ItemStack pItemStack) {
        super.func_149689_a(pWorld, pX, pY, pZ, pEntity, pItemStack);
        if (pItemStack.func_77978_p() != null) {
            SolarPanelTileEntity localTileCell = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
            localTileCell.getInventory().readFromNBT(pItemStack.func_77978_p());
            localTileCell.func_70296_d();
            localTileCell.setEnergyStored(pItemStack.func_77978_p().func_74762_e("SFEnergy"));
        }
    }

    public boolean func_149727_a(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, int pSide, float pdx, float pdy, float pdz) {
        if (Utils.isServer(pWorld)) {
            if (pPlayer.func_70093_af()) {
                if (Utils.hasUsableWrench(pPlayer, pX, pY, pZ)) {
                    this.dismantleBlock(pWorld, pX, pY, pZ);
                    return true;
                }
                if (ModConfiguration.infoOnSneakClick()) {
                    this.displayChatInformation(pWorld, pX, pY, pZ, pPlayer);
                }
            } else if (pWorld.func_147438_o(pX, pY, pZ) instanceof SolarPanelTileEntity) {
                pPlayer.openGui((Object)SolarFluxMod.mInstance, 0, pWorld, pX, pY, pZ);
            }
        }
        return true;
    }

    private void displayChatInformation(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer) {
        SolarPanelTileEntity tile = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
        String message = String.format("%s: [%d%%] %,d / %,d %s: %,d", Lang.localise("energy.stored"), tile.getPercentageEnergyStored(), tile.getEnergyStored(), tile.getMaxEnergyStored(), Lang.localise("energy.generation"), tile.getCurrentEnergyGeneration());
        pPlayer.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    private void dismantleBlock(World pWorld, int pX, int pY, int pZ) {
        int upgradeInstalled;
        SolarPanelTileEntity localTileCell;
        int internalEnergy;
        ItemStack itemStack = new ItemStack((Block)this);
        if (ModConfiguration.doesKeepEnergyWhenDismantled() && (internalEnergy = (localTileCell = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ)).getEnergyStored()) > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("SFEnergy", internalEnergy);
        }
        if (ModConfiguration.doesKeepInventoryWhenDismantled() && (upgradeInstalled = (localTileCell = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ)).getTotalUpgradeInstalled()) > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            localTileCell.getInventory().writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("SFTLUpgradeCount", upgradeInstalled);
            itemStack.func_77978_p().func_74768_a("SFTLCapacity", localTileCell.getEnergyStorage().getMaxEnergyStored());
            itemStack.func_77978_p().func_74768_a("SFTLTransferRate", localTileCell.getEnergyStorage().getMaxTransferExtract());
            pWorld.func_147475_p(pX, pY, pZ);
        }
        pWorld.func_147468_f(pX, pY, pZ);
        Utils.spawnItemStack(pWorld, pX, pY, pZ, itemStack);
    }

    public int getTierIndex() {
        return this.mTierIndex;
    }
}

