/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.core.block.icon;

import com.google.common.base.Preconditions;
import com.nauktis.core.block.icon.IBlockIconHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TopIconHandler
implements IBlockIconHandler {
    private final IBlockIconHandler mTop;
    private final IBlockIconHandler mSides;

    public TopIconHandler(IBlockIconHandler pTop, IBlockIconHandler pSides) {
        this.mTop = (IBlockIconHandler)Preconditions.checkNotNull((Object)pTop);
        this.mSides = (IBlockIconHandler)Preconditions.checkNotNull((Object)pSides);
    }

    @Override
    public IIcon getIcon(int pSide, int pMetadata) {
        if (ForgeDirection.UP.equals((Object)ForgeDirection.getOrientation((int)pSide))) {
            return this.mTop.getIcon(pSide, pMetadata);
        }
        return this.mSides.getIcon(pSide, pMetadata);
    }

    @Override
    public IIcon getIcon(IBlockAccess pBlockAccess, int pX, int pY, int pZ, int pSide) {
        if (ForgeDirection.UP.equals((Object)ForgeDirection.getOrientation((int)pSide))) {
            return this.mTop.getIcon(pBlockAccess, pX, pY, pZ, pSide);
        }
        return this.mSides.getIcon(pBlockAccess, pX, pY, pZ, pSide);
    }

    @Override
    public void registerBlockIcons(IIconRegister pIconRegister) {
        this.mTop.registerBlockIcons(pIconRegister);
        this.mSides.registerBlockIcons(pIconRegister);
    }
}

