/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.tileentity;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import java.util.List;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.integration.AbstractSharedStorage;
import org.dave.CompactMachines.integration.appeng.AESharedStorage;
import org.dave.CompactMachines.integration.appeng.CMGridBlock;
import org.dave.CompactMachines.integration.botania.BotaniaSharedStorage;
import org.dave.CompactMachines.integration.bundledredstone.BRSharedStorage;
import org.dave.CompactMachines.integration.fluid.FluidSharedStorage;
import org.dave.CompactMachines.integration.gas.GasSharedStorage;
import org.dave.CompactMachines.integration.item.ItemSharedStorage;
import org.dave.CompactMachines.integration.opencomputers.OpenComputersSharedStorage;
import org.dave.CompactMachines.integration.pneumaticcraft.PneumaticCraftSharedStorage;
import org.dave.CompactMachines.integration.redstoneflux.FluxSharedStorage;
import org.dave.CompactMachines.integration.thaumcraft.ThaumcraftSharedStorage;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityCM;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IManoMeasurable;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import vazkii.botania.api.mana.IManaPool;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="mrtjp.projectred.api.IBundledTile", modid="ProjRed|Transmission"), @Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="mekanism.api.gas.IGasHandler", modid="Mekanism"), @Optional.Interface(iface="mekanism.api.gas.ITubeConnection", modid="Mekanism"), @Optional.Interface(iface="vazkii.botania.api.mana.IManaPool", modid="Botania"), @Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="Thaumcraft"), @Optional.Interface(iface="pneumaticCraft.api.tileentity.ISidedPneumaticMachine", modid="PneumaticCraft"), @Optional.Interface(iface="pneumaticCraft.api.tileentity.IManoMeasurable", modid="PneumaticCraft")})
public class TileEntityInterface
extends TileEntityCM
implements IInventory,
IFluidHandler,
IGasHandler,
ITubeConnection,
IEnergyHandler,
IGridHost,
IBundledTile,
Environment,
IManaPool,
IEssentiaTransport,
ISidedPneumaticMachine,
IManoMeasurable {
    public CMGridBlock gridBlock;
    public int coords;
    public int side;
    public int _fluidid = -1;
    public int _fluidamount = 0;
    public int _gasid = -1;
    public int _gasamount = 0;
    public int _energy = 0;
    public int _mana = 0;
    public int _hoppingmode;
    public int _aspectid = -1;
    public int _aspectamount = 0;

    public ItemSharedStorage getStorageItem() {
        return (ItemSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "item");
    }

    public FluidSharedStorage getStorageFluid() {
        return (FluidSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "liquid");
    }

    public GasSharedStorage getStorageGas() {
        return (GasSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "gas");
    }

    public FluxSharedStorage getStorageFlux() {
        return (FluxSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "flux");
    }

    public AESharedStorage getStorageAE() {
        return (AESharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "appeng");
    }

    public BRSharedStorage getStorageBR() {
        return (BRSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "bundledRedstone");
    }

    public OpenComputersSharedStorage getStorageOC() {
        return (OpenComputersSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "OpenComputers");
    }

    public BotaniaSharedStorage getStorageBotania() {
        return (BotaniaSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, 0, "botania");
    }

    public ThaumcraftSharedStorage getStorageThaumcraft() {
        return (ThaumcraftSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "thaumcraft");
    }

    public PneumaticCraftSharedStorage getStoragePneumaticCraft() {
        return (PneumaticCraftSharedStorage)SharedStorageHandler.instance(this.field_145850_b.field_72995_K).getStorage(this.coords, this.side, "PneumaticCraft");
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.deinitialize();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.deinitialize();
    }

    public void deinitialize() {
        Node node;
        if (Reference.OC_AVAILABLE && !this.field_145850_b.field_72995_K && this.getStorageOC() != null && (node = this.getStorageOC().getNode()) != null) {
            node.remove();
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.getStoragePneumaticCraft() != null) {
            this.getStoragePneumaticCraft().invalidateInterfaceAirHandler();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void setSide(int side) {
        this.side = side;
        this.func_70296_d();
    }

    public void setCoords(int coords) {
        this.coords = coords;
        this.func_70296_d();
    }

    public void setCoordSide(int coords, int side) {
        this.coords = coords;
        this.side = side;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.side = tag.func_74762_e("side");
        this.coords = tag.func_74762_e("coords");
    }

    @Override
    protected void readSyncNBT(NBTTagCompound tag) {
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.field_145850_b != null && this.getStoragePneumaticCraft() != null && this.getStoragePneumaticCraft().isInterfaceValid()) {
            this.getStoragePneumaticCraft().getInterfaceAirHandler().readFromNBTI(tag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("side", this.side);
        tag.func_74768_a("coords", this.coords);
    }

    @Override
    protected void writeSyncNBT(NBTTagCompound tag) {
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.field_145850_b != null && this.getStoragePneumaticCraft() != null && this.getStoragePneumaticCraft().isInterfaceValid()) {
            this.getStoragePneumaticCraft().getInterfaceAirHandler().writeToNBTI(tag);
        }
    }

    public void func_145845_h() {
        Node node;
        super.func_145845_h();
        if (Reference.PR_AVAILABLE) {
            this.updateIncomingSignals();
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE) {
            if (!this.getStoragePneumaticCraft().isInterfaceValid()) {
                this.getStoragePneumaticCraft().validateInterfaceAirHandler(this);
                int x = this.field_145851_c + ForgeDirection.getOrientation((int)this.side).getOpposite().offsetX;
                int y = this.field_145848_d + ForgeDirection.getOrientation((int)this.side).getOpposite().offsetY;
                int z = this.field_145849_e + ForgeDirection.getOrientation((int)this.side).getOpposite().offsetZ;
                this.field_145850_b.func_147460_e(x, y, z, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
            this.getStoragePneumaticCraft().getInterfaceAirHandler().updateEntityI();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (Reference.OC_AVAILABLE && (node = this.getStorageOC().getNode()) != null && node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (Reference.AE_AVAILABLE) {
            this.getGridNode(ForgeDirection.UNKNOWN);
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.side).getOpposite();
        TileEntity tileEntityInside = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (tileEntityInside != null) {
            for (AbstractSharedStorage storage : SharedStorageHandler.instance(false).getAllStorages(this.coords, this.side)) {
                if (!(storage instanceof AbstractHoppingStorage)) continue;
                this.hopStorage((AbstractHoppingStorage)storage, tileEntityInside);
            }
        }
    }

    private void updateIncomingSignals() {
        boolean needsNotify = false;
        boolean haveChanges = false;
        byte[] previous = this.getStorageBR().interfaceBundledSignal;
        byte[] current = ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.getOrientation((int)this.side).getOpposite().ordinal());
        if (current != null) {
            for (int i = 0; i < current.length; ++i) {
                if (previous[i] == current[i]) continue;
                haveChanges = true;
                previous[i] = current[i];
            }
        }
        if (haveChanges) {
            this.getStorageBR().machineNeedsNotify = true;
        }
        this.getStorageBR().setDirty();
    }

    private void hopStorage(AbstractHoppingStorage storage, TileEntity tileEntityInside) {
        if (storage != null && (storage.getHoppingMode() == 4 || storage.getHoppingMode() == 1 || storage.getHoppingMode() == 3 && storage.isAutoHoppingToInside())) {
            storage.hopToTileEntity(tileEntityInside, false);
        }
    }

    public int func_70302_i_() {
        return this.getStorageItem().func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.getStorageItem().func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.getStorageItem().func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.getStorageItem().func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.getStorageItem().setAutoHoppingToInside(false);
        this.getStorageItem().setDirty();
        this.getStorageItem().func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return this.hasCustomName() ? this.getCustomName() : "container.cm:interface";
    }

    public boolean func_145818_k_() {
        return this.hasCustomName();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        this.getStorageFluid().setAutoHoppingToInside(false);
        this.getStorageFluid().setDirty();
        return this.getStorageFluid().fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getStorageFluid().drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.getStorageFluid().drain(from, resource, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getStorageFluid().canDrain(from, fluid);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getStorageFluid().canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getStorageFluid().getTankInfo(from);
    }

    public FluidStack getFluid() {
        return this.getStorageFluid().getFluid();
    }

    @Optional.Method(modid="Mekanism")
    public int receiveGas(ForgeDirection from, GasStack stack) {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return 0;
        }
        this.getStorageGas().setAutoHoppingToInside(false);
        this.getStorageGas().setDirty();
        return this.getStorageGas().receiveGas(from, stack);
    }

    @Optional.Method(modid="Mekanism")
    public GasStack drawGas(ForgeDirection from, int amount) {
        return this.getStorageGas().drawGas(from, amount);
    }

    @Optional.Method(modid="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.receiveGas(side, stack);
    }

    @Optional.Method(modid="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.drawGas(side, amount);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canReceiveGas(ForgeDirection from, Gas type) {
        return this.getStorageGas().canReceiveGas(from, type);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canDrawGas(ForgeDirection from, Gas type) {
        return this.getStorageGas().canDrawGas(from, type);
    }

    @Optional.Method(modid="Mekanism")
    public GasStack getGasContents() {
        return this.getStorageGas().getGasContents();
    }

    @Optional.Method(modid="Mekanism")
    public boolean canTubeConnect(ForgeDirection side) {
        return ConfigurationHandler.enableIntegrationMekanism;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        this.getStorageFlux().setAutoHoppingToInside(false);
        this.getStorageFlux().setDirty();
        return this.getStorageFlux().receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.getStorageFlux().extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getStorageFlux().getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getStorageFlux().getMaxEnergyStored();
    }

    public int getHoppingMode(ForgeDirection from) {
        return this.getStorageFlux().getHoppingMode();
    }

    public CMGridBlock getGridBlock(ForgeDirection dir) {
        if (this.gridBlock == null) {
            this.gridBlock = new CMGridBlock(this);
        }
        return this.gridBlock;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection dir) {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        if (!ConfigurationHandler.enableIntegrationAE2) {
            return null;
        }
        return this.getStorageAE().getInterfaceNode(this.getGridBlock(dir));
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    @Optional.Method(modid="ProjRed|Transmission")
    public byte[] getBundledSignal(int dir) {
        if (!ConfigurationHandler.enableIntegrationProjectRed) {
            return null;
        }
        byte[] current = this.getStorageBR().machineBundledSignal;
        if (current == null) {
            return null;
        }
        byte[] result = new byte[current.length];
        for (int i = 0; i < current.length; ++i) {
            int a = current[i] & 0xFF;
            int b = this.getStorageBR().machineOutputtedSignal[i] & 0xFF;
            int c = a;
            if (b > 0) continue;
            result[i] = (byte)c;
        }
        this.getStorageBR().interfaceOutputtedSignal = result;
        this.getStorageBR().setDirty();
        return result;
    }

    @Optional.Method(modid="ProjRed|Transmission")
    public boolean canConnectBundled(int side) {
        return ConfigurationHandler.enableIntegrationProjectRed;
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        if (!ConfigurationHandler.enableIntegrationOpenComputers) {
            return null;
        }
        return this.getStorageOC().getNode();
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="Botania")
    public boolean isFull() {
        return this.getStorageBotania().isFull();
    }

    @Optional.Method(modid="Botania")
    public void recieveMana(int mana) {
        this.getStorageBotania().recieveMana(mana);
    }

    @Optional.Method(modid="Botania")
    public boolean canRecieveManaFromBursts() {
        return this.getStorageBotania().canRecieveManaFromBursts();
    }

    @Optional.Method(modid="Botania")
    public int getCurrentMana() {
        return this.getStorageBotania().getCurrentMana();
    }

    @Optional.Method(modid="Botania")
    public boolean isOutputtingPower() {
        return this.getStorageBotania().isOutputtingPower();
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean isConnectable(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return false;
        }
        return this.getStorageThaumcraft().isConnectable(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canInputFrom(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return false;
        }
        return this.getStorageThaumcraft().canInputFrom(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canOutputTo(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return false;
        }
        return this.getStorageThaumcraft().canOutputTo(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public void setSuction(Aspect aspect, int amount) {
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getSuctionType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return null;
        }
        return this.getStorageThaumcraft().getSuctionType(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getSuctionAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return this.getStorageThaumcraft().getSuctionAmount(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return this.getStorageThaumcraft().takeEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return this.getStorageThaumcraft().addEssentia(aspect, amount, face);
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getEssentiaType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return null;
        }
        return this.getStorageThaumcraft().getEssentiaType(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getEssentiaAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return this.getStorageThaumcraft().getEssentiaAmount(face);
    }

    @Optional.Method(modid="Thaumcraft")
    public int getMinimumSuction() {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return Integer.MAX_VALUE;
        }
        return this.getStorageThaumcraft().getMinimumSuction();
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean renderExtendedTube() {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return false;
        }
        return this.getStorageThaumcraft().renderExtendedTube();
    }

    @Optional.Method(modid="PneumaticCraft")
    public IAirHandler getAirHandler(ForgeDirection side) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return null;
        }
        if (this.getStoragePneumaticCraft().isInterfaceValid()) {
            return this.getStoragePneumaticCraft().getInterfaceAirHandler();
        }
        return null;
    }

    @Optional.Method(modid="PneumaticCraft")
    public void printManometerMessage(EntityPlayer player, List<String> curInfo) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return;
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.getStoragePneumaticCraft().isInterfaceValid()) {
            this.getStoragePneumaticCraft().getInterfaceAirHandler().printManometerMessage(player, curInfo);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        if (!ConfigurationHandler.enableIntegrationPneumaticCraft) {
            return;
        }
        if (Reference.PNEUMATICCRAFT_AVAILABLE && this.getStoragePneumaticCraft().isInterfaceValid()) {
            this.getStoragePneumaticCraft().getInterfaceAirHandler().onNeighborChange();
        }
    }
}

