/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.DimensionManager;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.machines.world.WorldProviderMachines;
import org.dave.CompactMachines.utility.LogHelper;

public class MessageConfiguration
implements IMessage,
IMessageHandler<MessageConfiguration, IMessage> {
    public void fromBytes(ByteBuf buf) {
        LogHelper.info("Receiving configuration from server");
        ConfigurationHandler.isServerConfig = true;
        ConfigurationHandler.dimensionId = buf.readInt();
        ConfigurationHandler.capacityRF = buf.readInt();
        ConfigurationHandler.capacityFluid = buf.readInt();
        ConfigurationHandler.capacityGas = buf.readInt();
        ConfigurationHandler.capacityMana = buf.readInt();
        ConfigurationHandler.allowRespawning = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(ConfigurationHandler.dimensionId);
        buf.writeInt(ConfigurationHandler.capacityRF);
        buf.writeInt(ConfigurationHandler.capacityFluid);
        buf.writeInt(ConfigurationHandler.capacityGas);
        buf.writeInt(ConfigurationHandler.capacityMana);
        buf.writeBoolean(ConfigurationHandler.allowRespawning);
    }

    public IMessage onMessage(MessageConfiguration message, MessageContext ctx) {
        LogHelper.info("Registering dimension " + ConfigurationHandler.dimensionId + " on client side");
        DimensionManager.registerProviderType((int)ConfigurationHandler.dimensionId, WorldProviderMachines.class, (boolean)true);
        DimensionManager.registerDimension((int)ConfigurationHandler.dimensionId, (int)ConfigurationHandler.dimensionId);
        return null;
    }
}

