/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.utility.ItemHelper;

public class ItemSharedStorage
extends AbstractHoppingStorage
implements IInventory {
    private int size = 1;
    private ItemStack[] items;

    public ItemSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.empty();
        this.max_cooldown = ConfigurationHandler.cooldownItems;
    }

    public void empty() {
        this.items = new ItemStack[this.size];
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = super.saveToTag();
        compound.func_74782_a("Items", (NBTBase)ItemHelper.writeItemStacksToTag(this.items));
        compound.func_74774_a("size", (byte)this.size);
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        super.loadFromTag(tag);
        this.size = tag.func_74771_c("size");
        this.empty();
        ItemHelper.readItemStacksFromTag(this.items, tag.func_150295_c("Items", 10));
    }

    public int func_70302_i_() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int slot) {
        ItemSharedStorage itemSharedStorage = this;
        synchronized (itemSharedStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int slot, int decreaseAmount) {
        ItemSharedStorage itemSharedStorage = this;
        synchronized (itemSharedStorage) {
            return ItemHelper.decrStackSize(this, slot, decreaseAmount);
        }
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slot, ItemStack stack) {
        ItemSharedStorage itemSharedStorage = this;
        synchronized (itemSharedStorage) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.setDirty();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void hopToTileEntity(TileEntity tileEntity, boolean opposite) {
        int amount;
        ISidedInventory inv;
        ItemStack stack = this.func_70301_a(0);
        if (stack == null || stack.field_77994_a == 0) {
            return;
        }
        int targetSlot = -1;
        if (tileEntity instanceof IInventory) {
            if (tileEntity instanceof ISidedInventory) {
                inv = (ISidedInventory)tileEntity;
                ForgeDirection hoppingSide = ForgeDirection.getOrientation((int)this.side);
                if (opposite) {
                    hoppingSide = hoppingSide.getOpposite();
                }
                targetSlot = ItemHelper.findBestSlotForSidedInventory(inv, stack, hoppingSide);
            } else {
                inv = (IInventory)tileEntity;
                targetSlot = ItemHelper.findBestSlotForInventory((IInventory)inv, stack);
            }
        }
        if (targetSlot == -1) {
            return;
        }
        inv = (IInventory)tileEntity;
        ItemStack targetStack = inv.func_70301_a(targetSlot);
        int max = Math.min(stack.func_77976_d(), inv.func_70297_j_());
        if (targetStack == null) {
            if (stack.field_77994_a <= max) {
                inv.func_70299_a(targetSlot, stack);
                stack = null;
            } else {
                inv.func_70299_a(targetSlot, stack.func_77979_a(max));
            }
            inv.func_70296_d();
        } else if (targetStack.func_77969_a(stack) && stack.field_77994_a <= max && (amount = Math.min(stack.field_77994_a, max - targetStack.field_77994_a)) > 0) {
            targetStack.field_77994_a += amount;
            stack.field_77994_a -= amount;
            if (stack.field_77994_a < 1) {
                stack = null;
            }
            inv.func_70296_d();
        }
        this.func_70299_a(0, stack);
    }
}

