/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.appeng;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import java.util.HashMap;
import java.util.UUID;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractSharedStorage;
import org.dave.CompactMachines.integration.appeng.CMGridBlock;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.utility.WorldUtils;

public class AESharedStorage
extends AbstractSharedStorage {
    public int coord;
    public int side;
    public HashMap<Integer, Boolean> isConnected;
    public HashMap<Integer, IGridNode> machineNodes;
    public IGridNode interfaceNode;
    public String random = UUID.randomUUID().toString();

    public AESharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.side = side;
        this.coord = coord;
        if (this.machineNodes == null) {
            this.machineNodes = new HashMap();
        }
        if (this.isConnected == null) {
            this.isConnected = new HashMap();
        }
    }

    @Override
    public String type() {
        return "appeng";
    }

    public void connectNodes(int entangledInstance) {
        if (this.interfaceNode == null || this.machineNodes == null || this.machineNodes.get(entangledInstance) == null) {
            return;
        }
        if (this.isConnected != null && this.isConnected.containsKey(entangledInstance)) {
            return;
        }
        if (!Reference.AE_AVAILABLE) {
            return;
        }
        try {
            AEApi.instance().createGridConnection(this.interfaceNode, this.machineNodes.get(entangledInstance));
            this.isConnected.put(entangledInstance, true);
        }
        catch (FailedConnection failedConnection) {
            // empty catch block
        }
    }

    public void connectAll() {
        if (this.machineNodes == null) {
            return;
        }
        for (int entangledIndex : this.machineNodes.keySet()) {
            if (this.isConnected.containsKey(entangledIndex) && this.isConnected.get(entangledIndex).booleanValue()) continue;
            this.connectNodes(entangledIndex);
        }
    }

    public IGridNode getInterfaceNode(CMGridBlock gridBlock) {
        if (this.interfaceNode == null) {
            this.interfaceNode = AEApi.instance().createGridNode((IGridBlock)gridBlock);
            this.interfaceNode.updateState();
        }
        this.connectAll();
        return this.interfaceNode;
    }

    public void destroyMachineNode(int entangledIndex) {
        IGridNode machineNode = this.machineNodes.get(entangledIndex);
        if (machineNode != null) {
            machineNode.destroy();
            this.machineNodes.remove(entangledIndex);
            this.isConnected.remove(entangledIndex);
        }
        this.connectAll();
    }

    public IGridNode getMachineNode(CMGridBlock gridBlock, int entangledIndex) {
        IGridNode machineNode = this.machineNodes.get(entangledIndex);
        if (machineNode == null) {
            machineNode = AEApi.instance().createGridNode((IGridBlock)gridBlock);
            machineNode.updateState();
            this.machineNodes.put(entangledIndex, machineNode);
            WorldUtils.updateNeighborAEGrids(gridBlock.getLocation().getWorld(), gridBlock.getLocation().x, gridBlock.getLocation().y, gridBlock.getLocation().z);
        }
        return machineNode;
    }
}

