/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.client.gui.inventory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.integration.thaumcraft.ThaumcraftSharedStorage;
import org.dave.CompactMachines.inventory.ContainerMachine;
import org.dave.CompactMachines.reference.Textures;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;

@SideOnly(value=Side.CLIENT)
public class GuiMachine
extends GuiContainer {
    private TileEntityMachine tileEntityMachine;
    private static int tankHeight = 16;
    private static int[] xPositions = new int[]{80, 80, 80, 109, 109, 51};
    private static int[] yPositions = new int[]{66, 24, 45, 66, 45, 45};
    private static IIcon essentiaIcon;

    public GuiMachine(InventoryPlayer inventoryPlayer, TileEntityMachine tileEntityMachine) {
        super((Container)new ContainerMachine(inventoryPlayer, tileEntityMachine));
        this.tileEntityMachine = tileEntityMachine;
        this.field_146999_f = 176;
        this.field_147000_g = 187;
    }

    protected boolean isPointInRegion(int x, int y, int w, int h, int a, int b) {
        return this.func_146978_c(x, y, w, h, a, b);
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    public void drawTooltips(int mouseX, int mouseY) {
        ArrayList<String> lines = new ArrayList<String>(2);
        for (int i = 0; i < this.tileEntityMachine._fluidid.length; ++i) {
            int fluidId = this.tileEntityMachine._fluidid[i];
            Fluid fluid = FluidRegistry.getFluid((int)fluidId);
            int fluidAmount = this.tileEntityMachine._fluidamount[i];
            int gasId = this.tileEntityMachine._gasid[i];
            int gasAmount = this.tileEntityMachine._gasamount[i];
            int energyAmount = this.tileEntityMachine._energy[i];
            int manaAmount = this.tileEntityMachine._mana;
            int aspectId = this.tileEntityMachine._aspectid[i];
            int aspectAmount = this.tileEntityMachine._aspectamount[i];
            if (!this.isPointInRegion(xPositions[i] - 4, yPositions[i], 24, 16, mouseX, mouseY)) continue;
            String side = ForgeDirection.getOrientation((int)i).toString();
            side = side.substring(0, 1) + side.substring(1).toLowerCase();
            lines.add(side);
            if (energyAmount > 0) {
                lines.add("RF: " + energyAmount);
            }
            if (fluidAmount > 0) {
                FluidStack fluidStack = new FluidStack(fluid, fluidAmount);
                lines.add(fluidStack.getLocalizedName() + ": " + fluidAmount + "mB");
            }
            if (gasAmount > 0) {
                GasStack gasStack = new GasStack(gasId, gasAmount);
                Gas gas = gasStack.getGas();
                lines.add(gas.getLocalizedName() + ": " + gasAmount);
            }
            if (manaAmount > 0) {
                double ratio = (double)manaAmount * 1.0 / (double)ConfigurationHandler.capacityMana;
                if (ratio > 1.0) {
                    ratio = 1.0;
                }
                lines.add(String.format("%s: %.1f%%", StatCollector.func_74838_a((String)"tooltip.cm:machine.mana"), ratio * 100.0));
            }
            if (aspectAmount <= 0) continue;
            Aspect aspect = ThaumcraftSharedStorage.getAspectForID(aspectId);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || aspect == null) continue;
            if (ThaumcraftApiHelper.hasDiscoveredAspect((String)player.func_70005_c_(), (Aspect)aspect)) {
                lines.add(aspect.getName() + ": " + aspectAmount);
                continue;
            }
            lines.add(StatCollector.func_74838_a((String)"tooltip.cm:machine.unknownaspect") + ": " + aspectAmount);
        }
        if (lines.size() > 0) {
            this.drawTooltip(lines, mouseX, mouseY);
        }
    }

    protected void drawTooltip(List<String> lines, int x, int y) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        int tooltipWidth = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int tempWidth = this.field_146289_q.func_78256_a(lines.get(i));
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x - (12 + tooltipWidth);
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (this.field_147009_r + yStart + tooltipHeight + 6 > this.field_146295_m) {
            yStart = this.field_146295_m - tooltipHeight - this.field_147009_r - 6;
        }
        this.field_73735_i = 300.0f;
        GuiMachine.field_146296_j.field_77023_b = 300.0f;
        int color1 = -267386864;
        this.func_73733_a(xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.func_73733_a(xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3);
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            String line = lines.get(stringIndex);
            line = stringIndex == 0 ? "\u00a7" + Integer.toHexString(15) + line : "\u00a77" + line;
            this.field_146289_q.func_78261_a(line, xStart, yStart, -1);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        this.field_73735_i = 0.0f;
        GuiMachine.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146979_b(int x, int y) {
        String containerName = StatCollector.func_74838_a((String)this.tileEntityMachine.func_145825_b());
        this.field_146289_q.func_78276_b(containerName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(containerName) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (int i = 0; i < this.tileEntityMachine._fluidid.length; ++i) {
            int gasId;
            int fluidId = this.tileEntityMachine._fluidid[i];
            int fluidAmount = this.tileEntityMachine._fluidamount[i];
            int gasAmount = this.tileEntityMachine._gasamount[i];
            Fluid fluid = FluidRegistry.getFluid((int)fluidId);
            if (fluid != null && fluidAmount > 0) {
                FluidStack fluidStack = new FluidStack(fluid, fluidAmount);
                int tankSize = fluidAmount * tankHeight / ConfigurationHandler.capacityFluid;
                this.drawFluidTank(xPositions[i] - 4, yPositions[i] + 16, fluidStack, tankSize, gasAmount > 0);
            }
            if ((gasId = this.tileEntityMachine._gasid[i]) != -1 && gasAmount > 0) {
                GasStack gas = new GasStack(gasId, gasAmount);
                int tankSize = gasAmount * tankHeight / ConfigurationHandler.capacityGas;
                int xOffsetDelta = fluidAmount > 0 ? 2 : 4;
                this.drawGasTank(xPositions[i] - xOffsetDelta, yPositions[i] + 16, gas, tankSize, fluidAmount > 0);
            }
            int energyAmount = this.tileEntityMachine._energy[i];
            int aspectAmount = this.tileEntityMachine._aspectamount[i];
            if (energyAmount > 0) {
                int energySize = energyAmount * tankHeight / ConfigurationHandler.capacityRF;
                this.drawEnergyTank(xPositions[i] + 16, yPositions[i] + 16, Textures.Gui.INTERFACE, 176, 0, energySize, aspectAmount > 0);
            }
            if (aspectAmount <= 0) continue;
            int tankSize = aspectAmount * tankHeight / ConfigurationHandler.capacityEssentia;
            Aspect aspect = ThaumcraftSharedStorage.getAspectForID(this.tileEntityMachine._aspectid[i]);
            int xOffsetDelta = energyAmount > 0 ? 2 : 0;
            this.drawEssentiaTank(xPositions[i] + 16 + xOffsetDelta, yPositions[i] + 16, aspect, tankSize, energyAmount > 0);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Textures.Gui.MACHINE);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawGauge(int xOffset, int yOffset, IIcon icon, ResourceLocation texSheet, int level, boolean halfWidth) {
        int vertOffset = 0;
        if (texSheet != null) {
            this.bindTexture(texSheet);
        }
        while (level > 0) {
            int texHeight = 0;
            if (level > 4) {
                texHeight = 4;
                level -= 4;
            } else {
                texHeight = level;
                level = 0;
            }
            this.func_94065_a(xOffset, yOffset - texHeight - vertOffset, icon, halfWidth ? 2 : 4, texHeight);
            vertOffset += 4;
        }
    }

    protected void drawEnergyTank(int xOffset, int yOffset, ResourceLocation tex, int u, int v, int level, boolean halfWidth) {
        int vertOffset = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(tex);
        while (level > 0) {
            int texHeight = 0;
            if (level > 4) {
                texHeight = 4;
                level -= 4;
            } else {
                texHeight = level;
                level = 0;
            }
            this.func_73729_b(xOffset, yOffset - texHeight - vertOffset, u, v, halfWidth ? 2 : 4, texHeight);
            vertOffset += 4;
        }
    }

    protected void drawGasTank(int xOffset, int yOffset, GasStack stack, int level, boolean halfWidth) {
        if (stack == null) {
            return;
        }
        Gas gas = stack.getGas();
        if (gas == null) {
            return;
        }
        IIcon icon = gas.getIcon();
        if (icon == null) {
            icon = Blocks.field_150356_k.func_149691_a(0, 0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawGauge(xOffset, yOffset, icon, TextureMap.field_110575_b, level, halfWidth);
    }

    protected void drawFluidTank(int xOffset, int yOffset, FluidStack fluidStack, int level, boolean halfWidth) {
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        IIcon icon = fluid.getIcon(fluidStack);
        if (icon == null) {
            icon = Blocks.field_150356_k.func_149691_a(0, 0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(fluid);
        this.drawGauge(xOffset, yOffset, icon, null, level, halfWidth);
    }

    protected void drawEssentiaTank(int xOffset, int yOffset, Aspect aspect, int level, boolean halfWidth) {
        if (essentiaIcon == null) {
            try {
                Block block = Block.func_149634_a((Item)ItemApi.getBlock((String)"blockJar", (int)0).func_77973_b());
                Field iconFld = block.getClass().getField("iconLiquid");
                essentiaIcon = (IIcon)iconFld.get(block);
            }
            catch (Exception e) {
                essentiaIcon = Blocks.field_150356_k.func_149691_a(0, 0);
            }
        }
        Color aspectColor = new Color(aspect.getColor());
        GL11.glColor4f((float)((float)aspectColor.getRed() / 256.0f), (float)((float)aspectColor.getGreen() / 256.0f), (float)((float)aspectColor.getBlue() / 256.0f), (float)((float)aspectColor.getAlpha() / 256.0f));
        this.drawGauge(xOffset, yOffset, essentiaIcon, TextureMap.field_110575_b, level, halfWidth);
    }

    protected void bindTexture(ResourceLocation tex) {
        this.field_146297_k.field_71446_o.func_110577_a(tex);
    }

    protected void bindTexture(Fluid fluid) {
        if (fluid.getSpriteNumber() == 0) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        } else {
            GL11.glBindTexture((int)3553, (int)fluid.getSpriteNumber());
        }
    }
}

