/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cofh.api.tileentity.IPortableData;
import cofh.lib.util.position.BlockPosition;
import cofh.lib.util.position.IRotateableTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;
import powercrystals.minefactoryreloaded.circuits.Noop;
import powercrystals.minefactoryreloaded.item.ItemLogicUpgradeCard;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;

public class TileEntityRedNetLogic
extends TileEntityBase
implements IRotateableTile,
IPortableData {
    private int _circuitCount = 6;
    private int _variableCount = 16;
    private IRedNetLogicCircuit[] _prevCircuits = new IRedNetLogicCircuit[this._circuitCount];
    private IRedNetLogicCircuit[] _circuits = new IRedNetLogicCircuit[this._circuitCount];
    private boolean[] _updatable = new boolean[this._circuitCount];
    private int[][] _buffers = new int[15][];
    private int[][] _backBuffer = new int[6][];
    private BlockPosition bp = new BlockPosition(0, 0, 0);
    private PinMapping[][] _pinMappingInputs = new PinMapping[this._circuitCount][];
    private PinMapping[][] _pinMappingOutputs = new PinMapping[this._circuitCount][];
    private int[] _upgradeLevel = new int[6];
    public int crafters = 0;

    public TileEntityRedNetLogic() {
        int n;
        for (n = 0; n < 12; ++n) {
            this._buffers[n] = new int[16];
        }
        for (n = 0; n < 6; ++n) {
            this._backBuffer[n] = new int[16];
        }
        this._buffers[12] = null;
        this._buffers[13] = new int[this._variableCount];
        this._buffers[14] = new int[1];
        for (n = 0; n < this._circuits.length; ++n) {
            this.initCircuit(n, new Noop());
        }
    }

    public int getVariableBufferSize() {
        return this._variableCount;
    }

    public int getCircuitCount() {
        return this._circuitCount;
    }

    public int getBufferLength(int n) {
        return this._buffers[n].length;
    }

    public int getVariableValue(int n) {
        return this._buffers[13][n];
    }

    public IRedNetLogicCircuit getCircuit(int n) {
        return this._circuits[n];
    }

    @SideOnly(value=Side.CLIENT)
    public IRedNetLogicCircuit getLastCircuit(int n) {
        IRedNetLogicCircuit iRedNetLogicCircuit = this._prevCircuits[n];
        this._prevCircuits[n] = this._circuits[n];
        return iRedNetLogicCircuit;
    }

    public PinMapping getInputPinMapping(int n, int n2) {
        return this._pinMappingInputs[n][n2];
    }

    public void setInputPinMapping(int n, int n2, int n3, int n4) {
        this._pinMappingInputs[n][n2] = new PinMapping(n4, n3);
    }

    public PinMapping getOutputPinMapping(int n, int n2) {
        return this._pinMappingOutputs[n][n2];
    }

    public void setOutputPinMapping(int n, int n2, int n3, int n4) {
        this._pinMappingOutputs[n][n2] = new PinMapping(n4, n3);
    }

    private IRedNetLogicCircuit getNewCircuit(String string) {
        try {
            return (IRedNetLogicCircuit)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Noop();
        }
    }

    public void initCircuit(int n, String string) {
        this.initCircuit(n, this.getNewCircuit(string));
    }

    private void initCircuit(int n, IRedNetLogicCircuit iRedNetLogicCircuit) {
        int n2;
        this._updatable[n] = !(iRedNetLogicCircuit instanceof Noop);
        this._circuits[n] = iRedNetLogicCircuit;
        this._pinMappingInputs[n] = this._pinMappingInputs[n] == null ? new PinMapping[this._circuits[n].getInputCount()] : Arrays.copyOf(this._pinMappingInputs[n], (int)this._circuits[n].getInputCount());
        this._pinMappingOutputs[n] = this._pinMappingOutputs[n] == null ? new PinMapping[this._circuits[n].getOutputCount()] : Arrays.copyOf(this._pinMappingOutputs[n], (int)this._circuits[n].getOutputCount());
        for (n2 = 0; n2 < this._pinMappingInputs[n].length; ++n2) {
            if (this._pinMappingInputs[n][n2] != null) continue;
            this._pinMappingInputs[n][n2] = new PinMapping(0, 12);
        }
        for (n2 = 0; n2 < this._pinMappingOutputs[n].length; ++n2) {
            if (this._pinMappingOutputs[n][n2] != null) continue;
            this._pinMappingOutputs[n][n2] = new PinMapping(0, 14);
        }
    }

    public void reinitialize(EntityPlayer entityPlayer) {
        int n;
        for (n = 0; n < this._upgradeLevel.length; ++n) {
            if (this._upgradeLevel[n] <= 0) continue;
            ItemStack itemStack = new ItemStack(MFRThings.logicCardItem, 1, this._upgradeLevel[n] - 1);
            if (!entityPlayer.field_71071_by.func_70441_a(itemStack)) {
                entityPlayer.func_70099_a(itemStack, 0.0f);
            }
            this._upgradeLevel[n] = 0;
        }
        this.updateUpgradeLevels();
        for (n = 0; n < 12; ++n) {
            this._buffers[n] = new int[16];
        }
        for (n = 0; n < 6; ++n) {
            this._backBuffer[n] = new int[16];
        }
        this._buffers[12] = null;
        this._buffers[13] = new int[this._variableCount];
        this._buffers[14] = new int[1];
        for (n = 0; n < this._circuits.length; ++n) {
            this.initCircuit(n, new Noop());
            this.sendCircuitDefinition(n);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCircuitFromPacket(NBTTagCompound nBTTagCompound) {
        try {
            int n;
            int n2 = nBTTagCompound.func_74762_e("i");
            String string = nBTTagCompound.func_74779_i("name");
            this.initCircuit(n2, string);
            int n3 = nBTTagCompound.func_74771_c("input");
            int[] nArray = nBTTagCompound.func_74759_k("inputs");
            PinMapping[] pinMappingArray = this._pinMappingInputs[n2];
            for (n = 0; n < n3; ++n) {
                pinMappingArray[n] = new PinMapping(nArray[n << 1], nArray[n << 1 | 1]);
            }
            n3 = nBTTagCompound.func_74771_c("output");
            nArray = nBTTagCompound.func_74759_k("outputs");
            pinMappingArray = this._pinMappingOutputs[n2];
            for (n = 0; n < n3; ++n) {
                pinMappingArray[n] = new PinMapping(nArray[n << 1], nArray[n << 1 | 1]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void sendCircuitDefinition(int n) {
        int n2;
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("i", n);
        nBTTagCompound.func_74778_a("name", this._circuits[n].getClass().getName());
        int n3 = this._circuits[n].getInputCount();
        nBTTagCompound.func_74774_a("input", (byte)n3);
        int[] nArray = new int[n3 * 2];
        PinMapping[] pinMappingArray = this._pinMappingInputs[n];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n4] = pinMappingArray[n2].pin;
            nArray[++n4] = pinMappingArray[n2].buffer;
            ++n4;
        }
        nBTTagCompound.func_74783_a("inputs", nArray);
        n3 = this._circuits[n].getOutputCount();
        nBTTagCompound.func_74774_a("output", (byte)n3);
        nArray = new int[n3 * 2];
        pinMappingArray = this._pinMappingOutputs[n];
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n4] = pinMappingArray[n2].pin;
            nArray[++n4] = pinMappingArray[n2].buffer;
            ++n4;
        }
        nBTTagCompound.func_74783_a("outputs", nArray);
        Packets.sendToAllPlayersInRange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 10, (Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nBTTagCompound));
    }

    @Override
    public void func_145845_h() {
        Object object;
        Object object2;
        Object object3;
        int n;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (n = 0; n < 6; ++n) {
            int[] nArray = this._buffers[n + 6];
            object3 = this._backBuffer[n];
            int n2 = 16;
            while (n2-- > 0) {
                object3[n2] = nArray[n2];
                nArray[n2] = 0;
            }
        }
        int n3 = this._circuits.length;
        for (n = 0; n < n3; ++n) {
            if (!this._updatable[n]) continue;
            object3 = this._circuits[n];
            PinMapping[] pinMappingArray = this._pinMappingInputs[n];
            object2 = new int[object3.getInputCount()];
            int n4 = ((int[])object2).length;
            for (int i = 0; i < n4; ++i) {
                PinMapping pinMapping = pinMappingArray[i];
                object2[i] = pinMapping.buffer == 12 ? pinMapping.pin : this._buffers[pinMapping.buffer][pinMapping.pin];
            }
            object = object3.recalculateOutputValues(this.field_145850_b.func_82737_E(), (int[])object2);
            pinMappingArray = this._pinMappingOutputs[n];
            int n5 = ((int[])object).length;
            for (n4 = 0; n4 < n5; ++n4) {
                PinMapping pinMapping = pinMappingArray[n4];
                this._buffers[pinMapping.buffer][pinMapping.pin] = object[n4];
            }
        }
        BlockPosition blockPosition = this.bp;
        for (n3 = 0; n3 < 6; ++n3) {
            if (TileEntityRedNetLogic.areEqual(this._backBuffer[n3], this._buffers[n3 + 6])) continue;
            blockPosition.x = this.field_145851_c;
            blockPosition.y = this.field_145848_d;
            blockPosition.z = this.field_145849_e;
            object3 = ForgeDirection.VALID_DIRECTIONS[n3];
            blockPosition.step((ForgeDirection)object3);
            Block block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (block instanceof IRedNetNetworkContainer) {
                ((IRedNetNetworkContainer)block).updateNetwork(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, object3.getOpposite());
                continue;
            }
            if (!(block instanceof IRedNetInputNode)) continue;
            object2 = (IRedNetInputNode)block;
            object = (Object)object2.getConnectionType(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, object3.getOpposite());
            if (!object.isConnected) continue;
            if (object.isAllSubnets) {
                object2.onInputsChanged(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, object3.getOpposite(), this._buffers[n3 + 6]);
                continue;
            }
            if (!object.isSingleSubnet) continue;
            object2.onInputChanged(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, object3.getOpposite(), this._buffers[n3 + 6][0]);
        }
        this.markChunkDirty();
    }

    public int getOutputValue(ForgeDirection forgeDirection, int n) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return this._buffers[forgeDirection.ordinal() + 6][n];
    }

    public int[] getOutputValues(ForgeDirection forgeDirection) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return new int[16];
        }
        return this._buffers[forgeDirection.ordinal() + 6];
    }

    public void onInputsChanged(ForgeDirection forgeDirection, int[] nArray) {
        if (forgeDirection != ForgeDirection.UNKNOWN) {
            this._buffers[forgeDirection.ordinal()] = nArray;
        }
    }

    public String getDataType() {
        return "tile.mfr.rednet.logic.name";
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.writeCricuitsOnly(nBTTagCompound, false);
        if (nBTTagCompound.func_150297_b("circuits", 9)) {
            nBTTagCompound.func_74774_a("p_rot", (byte)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.memorycard.uploaded", new Object[0]));
        } else {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.memorycard.empty", new Object[0]));
        }
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canRotate()) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.memorycard.error2", new Object[0]));
            return;
        }
        int n = nBTTagCompound.func_150295_c("circuits", 10).func_74745_c();
        if (n > this.getCircuitCount()) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.memorycard.error", new Object[0]));
        } else {
            this.readCircuitsOnly(nBTTagCompound);
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.memorycard.downloaded", new Object[0]));
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        this.writeCricuitsOnly(nBTTagCompound, true);
        if (nBTTagCompound.func_150297_b("circuits", 9)) {
            nBTTagCompound.func_74774_a("p_rot", (byte)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        for (int n : this._upgradeLevel) {
            if (n == 0) continue;
            nBTTagCompound.func_74783_a("upgrades", this._upgradeLevel);
            break;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("p_rot", (byte)-1);
        nBTTagCompound.func_74783_a("vars", this._buffers[13]);
    }

    public void writeCricuitsOnly(NBTTagCompound nBTTagCompound, boolean bl) {
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this._circuits.length; ++i) {
            NBTTagCompound nBTTagCompound2;
            if (this._circuits[i] instanceof Noop) continue;
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.func_74778_a("circuit", this._circuits[i].getClass().getName());
            if (bl) {
                nBTTagCompound3.func_74768_a("index", i);
            }
            NBTTagList nBTTagList2 = new NBTTagList();
            for (int j = 0; j < this._pinMappingInputs[i].length; ++j) {
                nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74768_a("buffer", this._pinMappingInputs[i][j].buffer);
                nBTTagCompound2.func_74768_a("pin", this._pinMappingInputs[i][j].pin);
                nBTTagList2.func_74742_a((NBTBase)nBTTagCompound2);
            }
            if (nBTTagList2.func_74745_c() > 0) {
                nBTTagCompound3.func_74782_a("inputPins", (NBTBase)nBTTagList2);
            }
            NBTTagList nBTTagList3 = new NBTTagList();
            for (int j = 0; j < this._pinMappingOutputs[i].length; ++j) {
                NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                nBTTagCompound4.func_74768_a("buffer", this._pinMappingOutputs[i][j].buffer);
                nBTTagCompound4.func_74768_a("pin", this._pinMappingOutputs[i][j].pin);
                nBTTagList3.func_74742_a((NBTBase)nBTTagCompound4);
            }
            if (nBTTagList3.func_74745_c() > 0) {
                nBTTagCompound3.func_74782_a("outputPins", (NBTBase)nBTTagList3);
            }
            nBTTagCompound2 = new NBTTagCompound();
            this._circuits[i].writeToNBT(nBTTagCompound2);
            if (!nBTTagCompound2.func_82582_d()) {
                nBTTagCompound3.func_74782_a("state", (NBTBase)nBTTagCompound2);
            }
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound3);
        }
        if (nBTTagList.func_74745_c() > 0) {
            nBTTagCompound.func_74782_a("circuits", (NBTBase)nBTTagList);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        int[] nArray = nBTTagCompound.func_74759_k("upgrades");
        if (nArray != null && nArray.length == this._upgradeLevel.length) {
            this._upgradeLevel = nArray;
        }
        this.updateUpgradeLevels();
        int[] nArray2 = nBTTagCompound.func_74759_k("vars");
        if (nArray2 != null && nArray2.length == this._buffers[13].length) {
            this._buffers[13] = nArray2;
        }
        this.readCircuitsOnly(nBTTagCompound);
    }

    public void readCircuitsOnly(NBTTagCompound nBTTagCompound) {
        int n;
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("circuits", 10);
        int n2 = nBTTagCompound.func_74764_b("p_rot") ? (int)nBTTagCompound.func_74771_c("p_rot") : -1;
        int n3 = 0;
        int[] nArray = new int[]{0, 1, 2, 3};
        if (n2 != -1) {
            n3 = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
            int[][] nArrayArray = new int[][]{{0, 1, 2, 3}, {3, 2, 0, 1}, {1, 0, 3, 2}, {2, 3, 1, 0}};
            n = n3 - n2;
            if (n < 0) {
                n += 4;
            }
            nArray = nArrayArray[n];
        }
        if (nBTTagList != null) {
            int n4;
            n = nBTTagList.func_74745_c();
            Arrays.fill(this._circuits, null);
            for (n4 = 0; n4 < n; ++n4) {
                NBTTagList nBTTagList2;
                int n5;
                NBTTagCompound nBTTagCompound2;
                NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(n4);
                int n6 = nBTTagCompound3.func_74764_b("index") ? nBTTagCompound3.func_74762_e("index") : n4;
                this.initCircuit(n6, nBTTagCompound3.func_74779_i("circuit"));
                NBTTagList nBTTagList3 = nBTTagCompound3.func_150295_c("inputPins", 10);
                if (nBTTagList3 != null) {
                    for (int i = 0; i < nBTTagList3.func_74745_c() && i < this._pinMappingInputs[n4].length; ++i) {
                        nBTTagCompound2 = nBTTagList3.func_150305_b(i);
                        int n7 = nBTTagCompound2.func_74762_e("pin");
                        n5 = nBTTagCompound2.func_74762_e("buffer");
                        this._pinMappingInputs[n6][i] = new PinMapping(n7, this.mapBuffer(nArray, n5));
                    }
                }
                if ((nBTTagList2 = nBTTagCompound3.func_150295_c("outputPins", 10)) != null) {
                    for (int i = 0; i < nBTTagList2.func_74745_c() && i < this._pinMappingOutputs[n4].length; ++i) {
                        NBTTagCompound nBTTagCompound4 = nBTTagList2.func_150305_b(i);
                        n5 = nBTTagCompound4.func_74762_e("pin");
                        int n8 = nBTTagCompound4.func_74762_e("buffer");
                        this._pinMappingOutputs[n6][i] = new PinMapping(n5, this.mapBuffer(nArray, n8));
                    }
                }
                if ((nBTTagCompound2 = nBTTagCompound3.func_74775_l("state")) == null) continue;
                this._circuits[n6].readFromNBT(nBTTagCompound2);
            }
            n = this._circuits.length;
            for (n4 = 0; n4 < n; ++n4) {
                if (this._circuits[n4] != null) continue;
                this.initCircuit(n4, new Noop());
            }
        }
    }

    private int mapBuffer(int[] nArray, int n) {
        if (n > 1 && n < 6) {
            n = 2 + nArray[n - 2 & 3];
        } else if (n > 7 && n < 12) {
            n = 8 + nArray[n - 8 & 3];
        }
        return n;
    }

    public Packet func_145844_m() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74783_a("upgrades", this._upgradeLevel);
        S35PacketUpdateTileEntity s35PacketUpdateTileEntity = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nBTTagCompound);
        return s35PacketUpdateTileEntity;
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity s35PacketUpdateTileEntity) {
        switch (s35PacketUpdateTileEntity.func_148853_f()) {
            case 0: {
                this._upgradeLevel = s35PacketUpdateTileEntity.func_148857_g().func_74759_k("upgrades");
                this.updateUpgradeLevels();
                this._prevCircuits = Arrays.copyOf(this._prevCircuits, this._circuitCount);
                break;
            }
            case 1: {
                this.setCircuitFromPacket(s35PacketUpdateTileEntity.func_148857_g());
            }
        }
    }

    public boolean insertUpgrade(int n) {
        for (int i = 0; i < 6; ++i) {
            if (this._upgradeLevel[i] != 0) continue;
            if (!this.field_145850_b.field_72995_K) {
                this._upgradeLevel[i] = n;
                this.updateUpgradeLevels();
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void setUpgrade(int n, int n2) {
        this._upgradeLevel[n] = n2;
    }

    public int getLevelForSlot(int n) {
        return this._upgradeLevel[n];
    }

    private void updateUpgradeLevels() {
        int n;
        int n2 = 6;
        int n3 = 16;
        for (int i = 0; i < this._upgradeLevel.length; ++i) {
            n2 += ItemLogicUpgradeCard.getCircuitsForLevel(this._upgradeLevel[i]);
            n3 += ItemLogicUpgradeCard.getVariablesForLevel(this._upgradeLevel[i]);
        }
        this._circuitCount = n2;
        this._variableCount = n3;
        this._circuits = Arrays.copyOf(this._circuits, this._circuitCount);
        this._updatable = Arrays.copyOf(this._updatable, this._circuitCount);
        this._buffers[13] = Arrays.copyOf(this._buffers[13], this._variableCount);
        PinMapping[][] pinMappingArrayArray = new PinMapping[this._circuitCount][];
        for (int i = 0; i < pinMappingArrayArray.length; ++i) {
            if (i >= this._pinMappingInputs.length || this._pinMappingInputs[i] == null) continue;
            pinMappingArrayArray[i] = this._pinMappingInputs[i];
        }
        this._pinMappingInputs = pinMappingArrayArray;
        PinMapping[][] pinMappingArrayArray2 = new PinMapping[this._circuitCount][];
        for (n = 0; n < pinMappingArrayArray2.length; ++n) {
            if (n >= this._pinMappingOutputs.length || this._pinMappingOutputs[n] == null) continue;
            pinMappingArrayArray2[n] = this._pinMappingOutputs[n];
        }
        this._pinMappingOutputs = pinMappingArrayArray2;
        for (n = 0; n < this._circuits.length; ++n) {
            if (this._circuits[n] != null) continue;
            this.initCircuit(n, new Noop());
        }
    }

    public boolean canRotate() {
        return this.crafters == 0;
    }

    public boolean canRotate(ForgeDirection forgeDirection) {
        return this.crafters == 0;
    }

    public void rotate(ForgeDirection forgeDirection) {
        if (this.canRotate(forgeDirection)) {
            int n = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int n2 = n + 1 & 3;
            int[] nArray = new int[]{0, 1, 2, 3};
            Object object = new int[][]{{0, 1, 2, 3}, {3, 2, 0, 1}, {1, 0, 3, 2}, {2, 3, 1, 0}};
            int n3 = n2 - n;
            if (n3 < 0) {
                n3 += 4;
            }
            nArray = object[n3];
            object = new PinMapping[][][]{this._pinMappingInputs, this._pinMappingOutputs};
            n3 = ((int[][])object).length;
            for (int i = 0; i < n3; ++i) {
                int[] nArray2;
                int[] nArray3 = nArray2 = object[i];
                int n4 = nArray3.length;
                for (int j = 0; j < n4; ++j) {
                    int n5;
                    for (void var16_16 : n5 = nArray3[j]) {
                        var16_16.buffer = this.mapBuffer(nArray, var16_16.buffer);
                    }
                }
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, n2, 3);
        }
    }

    public void rotateDirectlyTo(int n) {
        if (this.canRotate() && n >= 2 && n < 6) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, n - 2, 3);
        }
    }

    public ForgeDirection getDirectionFacing() {
        int n = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        return ForgeDirection.getOrientation((int)(n + 2));
    }

    private static boolean areEqual(int[] nArray, int[] nArray2) {
        if (nArray == null | nArray2 == null || nArray.length != nArray2.length) {
            return false;
        }
        int n = nArray.length;
        while (n-- > 0) {
            if (nArray[n] == nArray2[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 4096.0;
    }

    public static class PinMapping {
        public int pin;
        public int buffer;

        public PinMapping(int n, int n2) {
            this.pin = n;
            this.buffer = n2;
        }
    }
}

