/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TurtleUtils {
    private static final int NUMBER_OF_TURTLE_TOOLS = 7;

    private static ItemStack tryGetTurtle(String itemName) {
        ItemStack result = GameRegistry.findItemStack((String)"CCTurtle", (String)itemName, (int)1);
        if (result != null) {
            return result;
        }
        result = GameRegistry.findItemStack((String)"ComputerCraft", (String)itemName, (int)1);
        return result;
    }

    public static ItemStack getExpandedTurtleItemStack() {
        return TurtleUtils.tryGetTurtle("CC-TurtleExpanded");
    }

    public static ItemStack getAdvancedTurtleItemStack() {
        return TurtleUtils.tryGetTurtle("CC-TurtleAdvanced");
    }

    public static void createTurtleItemStack(List<ItemStack> result, boolean isAdvanced, Short left, Short right) {
        ItemStack turtle;
        ItemStack itemStack = turtle = isAdvanced ? TurtleUtils.getAdvancedTurtleItemStack() : TurtleUtils.getExpandedTurtleItemStack();
        if (turtle == null) {
            return;
        }
        NBTTagCompound tag = turtle.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            turtle.func_77982_d(tag);
        }
        if (left != null) {
            tag.func_74777_a("leftUpgrade", left.shortValue());
        }
        if (right != null) {
            tag.func_74777_a("rightUpgrade", right.shortValue());
        }
        result.add(turtle);
    }

    private static void addUpgradedTurtles(List<ItemStack> result, short upgradeId, boolean isAdvanced) {
        TurtleUtils.createTurtleItemStack(result, isAdvanced, upgradeId, null);
        for (int i = 1; i < 7; ++i) {
            TurtleUtils.createTurtleItemStack(result, isAdvanced, upgradeId, (short)i);
        }
    }

    public static void addUpgradedTurtles(List<ItemStack> result, short upgradeId) {
        TurtleUtils.addUpgradedTurtles(result, upgradeId, false);
        TurtleUtils.addUpgradedTurtles(result, upgradeId, true);
    }
}

