/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.block.OpenBlock;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;
import openmods.utils.BlockManipulator;
import openmods.utils.BlockUtils;

@BookDocumentation
public class BlockRopeLadder
extends OpenBlock {
    public static final float RENDER_THICKNESS = 0.015625f;
    private static final float COLLISION_THICKNESS = 0.0625f;

    public BlockRopeLadder() {
        super(Material.field_151594_q);
        this.func_149711_c(0.4f);
        this.func_149672_a(field_149774_o);
        this.setRotationMode(BlockRotationMode.FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    @Override
    public int func_149645_b() {
        return OpenBlocks.renderIdFlat;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public int func_149745_a(Random random) {
        return Config.infiniteLadder ? 0 : 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB bb, List list, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            int meta = world.func_72805_g(x, y, z);
            Orientation orientation = this.getOrientation(meta);
            ForgeDirection playerRotation = BlockUtils.get2dOrientation((EntityLivingBase)((EntityLivingBase)entity));
            if (orientation.north() == playerRotation) {
                super.func_149743_a(world, x, y, z, bb, list, entity);
            }
        } else {
            super.func_149743_a(world, x, y, z, bb, list, entity);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.getBlockBounds((IBlockAccess)world, x, y, z, 0.0625f);
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.getBlockBounds((IBlockAccess)world, x, y, z, 0.015625f);
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.getBlockBounds(world, x, y, z, 0.015625f);
    }

    private void getBlockBounds(IBlockAccess world, int x, int y, int z, float thickness) {
        int meta = world.func_72805_g(x, y, z);
        Orientation orientation = this.getOrientation(meta);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)thickness);
        AxisAlignedBB rotatedAabb = BlockSpaceTransform.instance.mapBlockToWorld(orientation, aabb);
        this.setBlockBounds(rotatedAabb);
    }

    public boolean canRotateWithTool() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection dir = this.getOrientation(meta).north();
        if (world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) && world.func_147439_a(x, y + 1, z) != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        Block bottomBlock;
        if (--y > 0 && (bottomBlock = world.func_147439_a(x, y, z)) == block) {
            this.func_149697_b(world, x, y, z, meta, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void afterBlockPlaced(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, Orientation orientation, float hitX, float hitY, float hitZ, int itemMeta) {
        super.afterBlockPlaced(world, player, stack, x, y, z, side, orientation, hitX, hitY, hitZ, itemMeta);
        int blockMeta = this.getRotationMode().toValue(orientation);
        while (--y > 0 && (Config.infiniteLadder || stack.field_77994_a > 1)) {
            BlockManipulator manipulator = new BlockManipulator(world, player, x, y, z);
            if (world.func_147437_c(x, y, z) && manipulator.place((Block)this, blockMeta)) {
                if (Config.infiniteLadder) continue;
                --stack.field_77994_a;
                continue;
            }
            return;
        }
    }
}

