/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityGuide;
import openmods.api.ISelectionAware;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.geometry.AabbUtils;
import openmods.geometry.BlockSpaceTransform;
import openmods.geometry.BlockTextureTransform;
import openmods.geometry.BoundingBoxMap;
import openmods.geometry.HalfAxis;
import openmods.geometry.Orientation;
import openmods.infobook.BookDocumentation;

@BookDocumentation(hasVideo=true)
public class BlockGuide
extends OpenBlock
implements ISelectionAware {
    private AxisAlignedBB selection;
    private static double P = 0.0625;
    private static final double SELECTION_BOX_DEPTH = 0.01;
    private BoundingBoxMap<BoundingBoxMap<IShapeManipulator>> buttons = BoundingBoxMap.create();
    protected IIcon centerIcon;

    private static IShapeManipulator createHalfAxisIncrementer(ForgeDirection dir) {
        final HalfAxis halfAxis = HalfAxis.fromDirection((ForgeDirection)dir);
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.incrementHalfAxis(halfAxis, player);
            }
        };
    }

    private static IShapeManipulator createHalfAxisDecrementer(ForgeDirection dir) {
        final HalfAxis halfAxis = HalfAxis.fromDirection((ForgeDirection)dir);
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.decrementHalfAxis(halfAxis, player);
            }
        };
    }

    private static IShapeManipulator createHalfAxisCopier(ForgeDirection dir) {
        final HalfAxis halfAxis = HalfAxis.fromDirection((ForgeDirection)dir);
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return te.copyHalfAxis(halfAxis, halfAxis.negate(), player);
            }
        };
    }

    private IShapeManipulator createRotationManipulator(final HalfAxis ha) {
        return new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                return BlockGuide.this.createRotationHelper(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e).rotateAroundAxis(ha);
            }
        };
    }

    private static AxisAlignedBB addButton(ForgeDirection side, BlockTextureTransform transform, int left, int top, int width, int height) {
        BlockTextureTransform.WorldCoords min = transform.textureCoordsToWorldVec(side, (double)left * P, (double)top * P, -0.01);
        BlockTextureTransform.WorldCoords max = transform.textureCoordsToWorldVec(side, (double)(left + width) * P, (double)(top + height) * P, 0.01);
        return AabbUtils.createAabb((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    private void createNSWESide(BoundingBoxMap<BoundingBoxMap<IShapeManipulator>> output, ForgeDirection face) {
        BlockTextureTransform transform = this.getRotationMode().textureTransform;
        BoundingBoxMap subBoxes = BoundingBoxMap.create();
        ForgeDirection right = face.getRotation(ForgeDirection.DOWN);
        ForgeDirection left = right.getOpposite();
        ForgeDirection top = ForgeDirection.UP;
        ForgeDirection bottom = ForgeDirection.DOWN;
        subBoxes.addBox(BlockGuide.addButton(face, transform, 4, 1, 3, 3), (Object)BlockGuide.createHalfAxisDecrementer(top));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 9, 1, 3, 3), (Object)BlockGuide.createHalfAxisIncrementer(top));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 6, 4, 4, 2), (Object)BlockGuide.createHalfAxisCopier(top));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 12, 4, 3, 3), (Object)BlockGuide.createHalfAxisDecrementer(right));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 12, 9, 3, 3), (Object)BlockGuide.createHalfAxisIncrementer(right));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 10, 6, 2, 4), (Object)BlockGuide.createHalfAxisCopier(right));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 9, 12, 3, 3), (Object)BlockGuide.createHalfAxisDecrementer(bottom));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 4, 12, 3, 3), (Object)BlockGuide.createHalfAxisIncrementer(bottom));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 6, 10, 4, 2), (Object)BlockGuide.createHalfAxisCopier(bottom));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 1, 9, 3, 3), (Object)BlockGuide.createHalfAxisDecrementer(left));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 1, 4, 3, 3), (Object)BlockGuide.createHalfAxisIncrementer(left));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 4, 6, 2, 4), (Object)BlockGuide.createHalfAxisCopier(left));
        BlockTextureTransform.WorldCoords overboxMin = transform.textureCoordsToWorldVec(face, P, P, -0.01);
        BlockTextureTransform.WorldCoords overboxMax = transform.textureCoordsToWorldVec(face, 1.0 - P, 1.0 - P, 0.01);
        output.addBox(AabbUtils.createAabb((double)overboxMin.x, (double)overboxMin.y, (double)overboxMin.z, (double)overboxMax.x, (double)overboxMax.y, (double)overboxMax.z), (Object)subBoxes);
    }

    private void createTopBottomSide(BoundingBoxMap<BoundingBoxMap<IShapeManipulator>> output, ForgeDirection face) {
        BlockTextureTransform transform = this.getRotationMode().textureTransform;
        BoundingBoxMap subBoxes = BoundingBoxMap.create();
        subBoxes.addBox(BlockGuide.addButton(face, transform, 1, 7, 4, 7), (Object)this.createRotationManipulator(HalfAxis.NEG_Y));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 11, 7, 4, 7), (Object)this.createRotationManipulator(HalfAxis.POS_Y));
        subBoxes.addBox(BlockGuide.addButton(face, transform, 5, 2, 6, 3), (Object)new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                te.incrementMode((EntityPlayer)player);
                return true;
            }
        });
        subBoxes.addBox(BlockGuide.addButton(face, transform, 5, 8, 6, 3), (Object)new IShapeManipulator(){

            @Override
            public boolean activate(TileEntityGuide te, EntityPlayerMP player) {
                te.decrementMode((EntityPlayer)player);
                return true;
            }
        });
        BlockTextureTransform.WorldCoords overboxMin = transform.textureCoordsToWorldVec(face, P, P, -0.01);
        BlockTextureTransform.WorldCoords overboxMax = transform.textureCoordsToWorldVec(face, 1.0 - P, 1.0 - P, 0.01);
        output.addBox(AabbUtils.createAabb((double)overboxMin.x, (double)overboxMin.y, (double)overboxMin.z, (double)overboxMax.x, (double)overboxMax.y, (double)overboxMax.z), (Object)subBoxes);
    }

    public BlockGuide() {
        super(Material.field_151576_e);
        this.createTopBottomSide(this.buttons, ForgeDirection.UP);
        this.createNSWESide(this.buttons, ForgeDirection.NORTH);
        this.createNSWESide(this.buttons, ForgeDirection.SOUTH);
        this.createNSWESide(this.buttons, ForgeDirection.EAST);
        this.createNSWESide(this.buttons, ForgeDirection.WEST);
        this.createTopBottomSide(this.buttons, ForgeDirection.DOWN);
        this.func_149715_a(0.6f);
        this.setRotationMode(BlockRotationMode.THREE_FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        super.func_149651_a(registry);
        Icons.marker = registry.func_94245_a("openblocks:guide");
        this.centerIcon = registry.func_94245_a(this.getCenterIconName());
        this.setTextures(registry.func_94245_a("openblocks:guide_top_new"), new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN});
        this.setTextures(registry.func_94245_a("openblocks:guide_side_new"), new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST});
    }

    protected String getCenterIconName() {
        return "openblocks:guide_center_normal";
    }

    public IIcon getCenterTexture() {
        return this.centerIcon;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.selection != null ? this.selection : super.func_149633_g(world, x, y, z);
    }

    private Map.Entry<AxisAlignedBB, IShapeManipulator> findClickBox(Vec3 pos) {
        Map.Entry subSideBox;
        Map.Entry sideBox = this.buttons.findEntryContainingPoint(pos);
        if (sideBox != null && (subSideBox = ((BoundingBoxMap)sideBox.getValue()).findEntryContainingPoint(pos)) != null) {
            return subSideBox;
        }
        return null;
    }

    protected boolean areButtonsActive(EntityPlayer player) {
        return true;
    }

    protected boolean onItemUse(EntityPlayerMP player, TileEntityGuide guide, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSelected(World world, int x, int y, int z, DrawBlockHighlightEvent evt) {
        if (this.areButtonsActive(evt.player)) {
            Vec3 hitVec = evt.target.field_72307_f;
            int metadata = world.func_72805_g(x, y, z);
            BlockRotationMode rotationMode = this.getRotationMode();
            Orientation orientation = rotationMode.fromValue(metadata);
            Vec3 localHit = BlockSpaceTransform.instance.mapWorldToBlock(orientation, hitVec.field_72450_a - (double)x, hitVec.field_72448_b - (double)y, hitVec.field_72449_c - (double)z);
            Map.Entry<AxisAlignedBB, IShapeManipulator> clickBox = this.findClickBox(localHit);
            this.selection = clickBox != null ? BlockSpaceTransform.instance.mapBlockToWorld(orientation, clickBox.getKey()).func_72317_d((double)x, (double)y, (double)z) : null;
        } else {
            this.selection = null;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityGuide guide;
        if (player instanceof EntityPlayerMP && (guide = (TileEntityGuide)((Object)BlockGuide.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityGuide.class))) != null) {
            ItemStack heldStack;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (this.areButtonsActive((EntityPlayer)playerMP)) {
                int metadata = world.func_72805_g(x, y, z);
                BlockRotationMode rotationMode = this.getRotationMode();
                Orientation orientation = rotationMode.fromValue(metadata);
                Vec3 localHit = BlockSpaceTransform.instance.mapWorldToBlock(orientation, (double)hitX, (double)hitY, (double)hitZ);
                Map.Entry<AxisAlignedBB, IShapeManipulator> clickBox = this.findClickBox(localHit);
                if (clickBox != null) {
                    return clickBox.getValue().activate(guide, playerMP);
                }
            }
            if ((heldStack = playerMP.func_70694_bm()) != null && guide.onItemUse(playerMP, heldStack, side, hitX, hitY, hitZ)) {
                return true;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        world.func_72869_a("smoke", (double)((float)x + 0.5f), (double)((float)y + 0.7f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
        world.func_72869_a("flame", (double)((float)x + 0.5f), (double)((float)y + 0.7f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0);
    }

    public static class Icons {
        public static IIcon marker;
    }

    private static interface IShapeManipulator {
        public boolean activate(TileEntityGuide var1, EntityPlayerMP var2);
    }
}

