/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import openblocks.api.InventoryEvent;
import openblocks.common.PlayerInventoryStore;
import openmods.Log;
import openmods.utils.BlockUtils;
import openmods.utils.CommandUtils;
import openmods.utils.InventoryUtils;

public class CommandInventory
implements ICommand {
    private static final String COMMAND_RESTORE = "restore";
    private static final String COMMAND_SPAWN = "spawn";
    private static final String COMMAND_STORE = "store";
    private static final String NAME = "ob_inventory";
    private static final String ID_MAIN_INVENTORY = "main";
    private static final List<String> SUB_COMMANDS = Lists.newArrayList((Object[])new String[]{"store", "restore", "spawn"});

    public int compareTo(Object o) {
        return NAME.compareTo(((ICommand)o).func_71517_b());
    }

    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "ob_inventory store <player> OR ob_inventory restore <player> <file without 'inventory-' and '.dat'> OR ob_inventory spawn <file without 'inventory-' and '.dat'> [<sub_inventory OR 'main'>,  [<index of item>]]";
    }

    public List func_71514_a() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new SyntaxErrorException();
        }
        String subCommand = args[0];
        if (subCommand.equalsIgnoreCase(COMMAND_RESTORE)) {
            boolean success;
            if (args.length != 3) {
                throw new SyntaxErrorException();
            }
            String playerName = args[1];
            String id = args[2];
            EntityPlayerMP player = CommandUtils.getPlayer((ICommandSender)sender, (String)playerName);
            try {
                success = PlayerInventoryStore.instance.restoreInventory((EntityPlayer)player, id);
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to restore inventory, player %s, file %s", (Object[])new Object[]{playerName, id});
                throw new CommandException("openblocks.misc.cant_restore_player", new Object[]{playerName});
            }
            if (!success) throw new CommandException("openblocks.misc.cant_restore_player", new Object[]{playerName});
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.restored_inventory", new Object[]{playerName}));
            return;
        }
        if (subCommand.equalsIgnoreCase(COMMAND_STORE)) {
            if (args.length != 2) {
                throw new SyntaxErrorException();
            }
            String playerName = args[1];
            EntityPlayerMP player = CommandUtils.getPlayer((ICommandSender)sender, (String)playerName);
            try {
                File result = PlayerInventoryStore.instance.storePlayerInventory((EntityPlayer)player, "command");
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.stored_inventory", new Object[]{result.getAbsolutePath()}));
                return;
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to store inventory, player %s, file %s", (Object[])new Object[]{playerName});
                throw new CommandException("openblocks.misc.cant_store", new Object[]{playerName});
            }
        } else {
            List toRestore;
            ItemStack stack2;
            int item;
            Object inventory;
            if (!subCommand.equalsIgnoreCase(COMMAND_SPAWN)) throw new SyntaxErrorException();
            if (args.length != 2 && args.length != 3 && args.length != 4) {
                throw new SyntaxErrorException();
            }
            String id = args[1];
            String target = args.length > 1 ? args[2] : ID_MAIN_INVENTORY;
            PlayerInventoryStore.LoadedInventories loadedInventories = CommandInventory.loadInventories(sender, id);
            if (loadedInventories == null) {
                throw new CommandException("openblocks.misc.cant_restore_inventory", new Object[0]);
            }
            if (ID_MAIN_INVENTORY.equals(target)) {
                inventory = loadedInventories.mainInventory;
                if (inventory == null) {
                    throw new CommandException("openblocks.misc.cant_restore_inventory", new Object[0]);
                }
                if (args.length == 4) {
                    item = CommandInventory.getSlotId(args[3]);
                    stack2 = inventory.func_70301_a(item);
                    if (stack2 == null) {
                        throw new CommandException("openblocks.misc.empty_slot", new Object[0]);
                    }
                    toRestore = Lists.newArrayList((Object[])new ItemStack[]{stack2});
                } else {
                    toRestore = InventoryUtils.getInventoryContents((IInventory)inventory);
                }
            } else {
                inventory = loadedInventories.subInventories.get(target);
                if (inventory == null) {
                    throw new CommandException("openblocks.misc.invalid_sub_inventory", new Object[]{target});
                }
                if (args.length == 4) {
                    item = CommandInventory.getSlotId(args[3]);
                    stack2 = ((InventoryEvent.SubInventory)inventory).getItemStack(item);
                    if (stack2 == null) {
                        throw new CommandException("openblocks.misc.empty_slot", new Object[0]);
                    }
                    toRestore = Lists.newArrayList((Object[])new ItemStack[]{stack2});
                } else {
                    toRestore = Lists.newArrayList(((InventoryEvent.SubInventory)inventory).asMap().values());
                }
            }
            ChunkCoordinates coords = sender.func_82114_b();
            for (ItemStack stack2 : toRestore) {
                if (stack2 == null) continue;
                BlockUtils.dropItemStackInWorld((World)sender.func_130014_f_(), (double)coords.field_71574_a, (double)coords.field_71572_b, (double)coords.field_71573_c, (ItemStack)stack2);
            }
        }
    }

    private static PlayerInventoryStore.LoadedInventories loadInventories(ICommandSender sender, String id) {
        try {
            return PlayerInventoryStore.instance.loadInventories(sender.func_130014_f_(), id);
        }
        catch (Exception e) {
            Log.warn((Throwable)e, (String)"Failed to restore inventory, file %s", (Object[])new Object[]{id});
            throw new CommandException("openblocks.misc.cant_restore_inventory", new Object[0]);
        }
    }

    private static int getSlotId(String item) {
        try {
            return Integer.parseInt(item);
        }
        catch (Exception t) {
            throw new CommandException("openblocks.misc.invalid_index", new Object[0]);
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender.func_70003_b(4, NAME);
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            return CommandUtils.filterPrefixes((String)args[0], SUB_COMMANDS);
        }
        String subCommand = args[0];
        if (subCommand.equals(COMMAND_SPAWN)) {
            if (args.length == 2) {
                return PlayerInventoryStore.instance.getMatchedDumps(sender.func_130014_f_(), args[1]);
            }
            if (args.length == 3) {
                String fileId = args[1];
                try {
                    PlayerInventoryStore.LoadedInventories inventories = PlayerInventoryStore.instance.loadInventories(sender.func_130014_f_(), fileId);
                    if (inventories == null) {
                        return null;
                    }
                    ArrayList result = Lists.newArrayList((Object[])new String[]{ID_MAIN_INVENTORY});
                    result.addAll(inventories.subInventories.keySet());
                    return CommandUtils.filterPrefixes((String)args[2], (Iterable)result);
                }
                catch (Exception e) {}
            }
        } else {
            if (args.length == 2) {
                return CommandUtils.fiterPlayerNames((String)args[1]);
            }
            if (args.length == 3) {
                String prefix = args[2];
                if (subCommand.equalsIgnoreCase(COMMAND_RESTORE)) {
                    return PlayerInventoryStore.instance.getMatchedDumps(sender.func_130014_f_(), prefix);
                }
            }
        }
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        if (args.length > 1 && args[0].equals(COMMAND_SPAWN)) {
            return false;
        }
        return index == 1;
    }
}

