/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.OpenBlocks;
import openblocks.client.ChangelogBuilder;
import openblocks.client.gui.ChangelogPage;
import openblocks.client.gui.page.IntroPage;
import openblocks.common.PlayerInventoryStore;
import openmods.Log;
import openmods.gui.ComponentGui;
import openmods.gui.DummyContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.PageBase;
import openmods.gui.component.page.SectionPage;
import openmods.gui.component.page.TitledPage;
import openmods.infobook.PageBuilder;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiInfoBook
extends ComponentGui {
    private GuiComponentBook book;

    public GuiInfoBook() {
        super((Container)new DummyContainer(), 0, 0);
    }

    private static void setupBookmark(GuiComponentLabel label, GuiComponentBook book, int index) {
        label.setListener(book.createBookmarkListener(index));
    }

    public void func_73866_w_() {
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    private static int alignToEven(GuiComponentBook book) {
        int index = book.getNumberOfPages();
        if ((index & 1) == 1) {
            book.addPage((BaseComponent)PageBase.BLANK_PAGE);
            ++index;
        }
        return index;
    }

    private static int tocLine(int index) {
        int tocStartHeight = 70;
        int tocLineHeight = 15;
        return 70 + index * 15;
    }

    public void func_146282_l() {
        super.func_146282_l();
        if (Keyboard.getEventKeyState()) {
            switch (Keyboard.getEventKey()) {
                case 201: {
                    this.book.prevPage();
                    break;
                }
                case 209: {
                    this.book.nextPage();
                    break;
                }
                case 199: {
                    this.book.firstPage();
                    break;
                }
                case 207: {
                    this.book.lastPage();
                }
            }
        }
    }

    protected BaseComposite createRoot() {
        this.book = new GuiComponentBook();
        TitledPage contentsPage = new TitledPage("openblocks.gui.welcome.title", "openblocks.gui.welcome.content");
        GuiComponentLabel lblBlocks = new GuiComponentLabel(27, GuiInfoBook.tocLine(0), "- " + StatCollector.func_74838_a((String)"openblocks.gui.blocks"));
        contentsPage.addComponent((BaseComponent)lblBlocks);
        GuiComponentLabel lblItems = new GuiComponentLabel(27, GuiInfoBook.tocLine(1), "- " + StatCollector.func_74838_a((String)"openblocks.gui.items"));
        contentsPage.addComponent((BaseComponent)lblItems);
        GuiComponentLabel lblMisc = new GuiComponentLabel(27, GuiInfoBook.tocLine(2), "- " + StatCollector.func_74838_a((String)"openblocks.gui.misc"));
        contentsPage.addComponent((BaseComponent)lblMisc);
        GuiComponentLabel lblChangelogs = new GuiComponentLabel(27, GuiInfoBook.tocLine(3), "- " + StatCollector.func_74838_a((String)"openblocks.gui.changelogs"));
        contentsPage.addComponent((BaseComponent)lblChangelogs);
        this.book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        this.book.addPage((BaseComponent)new IntroPage());
        this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.credits.title", "openblocks.gui.credits.content"));
        this.book.addPage((BaseComponent)contentsPage);
        int blocksIndex = GuiInfoBook.alignToEven(this.book);
        GuiInfoBook.setupBookmark(lblBlocks, this.book, blocksIndex);
        this.book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        this.book.addPage((BaseComponent)new SectionPage("openblocks.gui.blocks"));
        PageBuilder builder = new PageBuilder();
        builder.includeModId("OpenBlocks");
        builder.createBlockPages();
        builder.insertTocPages(this.book, 4, 4, 1.5f);
        GuiInfoBook.alignToEven(this.book);
        builder.insertPages(this.book);
        int itemsIndex = GuiInfoBook.alignToEven(this.book);
        GuiInfoBook.setupBookmark(lblItems, this.book, itemsIndex);
        this.book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        this.book.addPage((BaseComponent)new SectionPage("openblocks.gui.items"));
        builder = new PageBuilder();
        builder.includeModId("OpenBlocks");
        builder.createItemPages();
        builder.insertTocPages(this.book, 4, 4, 1.5f);
        GuiInfoBook.alignToEven(this.book);
        builder.insertPages(this.book);
        int miscIndex = GuiInfoBook.alignToEven(this.book);
        GuiInfoBook.setupBookmark(lblMisc, this.book, miscIndex);
        this.book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        this.book.addPage((BaseComponent)new SectionPage("openblocks.gui.misc"));
        this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.config.title", "openblocks.gui.config.content"));
        this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.restore_inv.title", "openblocks.gui.restore_inv.content").addActionButton(10, 133, GuiInfoBook.getSavePath(), PageBase.ActionIcon.FOLDER.icon, "openblocks.gui.save_folder"));
        this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.bkey.title", "openblocks.gui.bkey.content"));
        if (OpenBlocks.Enchantments.explosive != null) {
            this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.unstable.title", "openblocks.gui.unstable.content"));
        }
        if (OpenBlocks.Enchantments.lastStand != null) {
            this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.laststand.title", "openblocks.gui.laststand.content"));
        }
        if (OpenBlocks.Enchantments.flimFlam != null) {
            this.book.addPage((BaseComponent)new TitledPage("openblocks.gui.flimflam.title", "openblocks.gui.flimflam.content"));
        }
        int changelogsIndex = GuiInfoBook.alignToEven(this.book);
        this.book.addPage((BaseComponent)PageBase.BLANK_PAGE);
        GuiInfoBook.setupBookmark(lblChangelogs, this.book, changelogsIndex);
        this.book.addPage((BaseComponent)new SectionPage("openblocks.gui.changelogs"));
        GuiInfoBook.createChangelogPages(this.book);
        this.book.enablePages();
        this.field_146999_f = this.book.getWidth();
        this.field_147000_g = this.book.getHeight();
        return this.book;
    }

    private static File getSavePath() {
        try {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null) {
                WorldServer world = server.func_71218_a(0);
                File saveFolder = PlayerInventoryStore.getSaveFolder((World)world);
                return saveFolder;
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to get save folder from local server", (Object[])new Object[0]);
        }
        try {
            return Minecraft.func_71410_x().field_71412_D;
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to get save folder from MC data dir", (Object[])new Object[0]);
            return new File("invalid.path");
        }
    }

    private static void createChangelogPages(GuiComponentBook book) {
        String prevVersion = null;
        int prevIndex = 0;
        ArrayList prevPages = Lists.newArrayList();
        List<ChangelogBuilder.Changelog> changelogs = ChangelogBuilder.readChangeLogs();
        for (int i = 0; i < changelogs.size(); ++i) {
            ChangelogBuilder.Changelog changelog = changelogs.get(i);
            String currentVersion = changelog.version;
            int currentPage = book.getNumberOfPages();
            for (ChangelogPage prevPage : prevPages) {
                prevPage.addNextVersionBookmark(book, currentVersion, currentPage);
            }
            prevPages.clear();
            for (ChangelogBuilder.ChangelogSection section : changelog.sections) {
                ChangelogPage page = new ChangelogPage(currentVersion, section.title, section.lines);
                book.addPage((BaseComponent)page);
                prevPages.add(page);
                if (i <= 0) continue;
                page.addPrevVersionBookmark(book, prevVersion, prevIndex);
            }
            GuiInfoBook.alignToEven(book);
            prevVersion = currentVersion;
            prevIndex = currentPage;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.renderOverlay(this.field_146297_k, this.field_147003_i, this.field_147009_r, par1 - this.field_147003_i, par2 - this.field_147009_r);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }
}

