/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.util.HashMap;
import java.util.Map;
import li.cil.repack.org.luaj.vm2.LuaDouble;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaArray;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaClass;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaInstance;

public class CoerceJavaToLua {
    static final Map COERCIONS = new HashMap();
    static final Coercion instanceCoercion;
    static final Coercion arrayCoercion;
    static final Coercion luaCoercion;

    public static LuaValue coerce(Object o) {
        if (o == null) {
            return LuaValue.NIL;
        }
        Class<?> clazz = o.getClass();
        Coercion c = (Coercion)COERCIONS.get(clazz);
        if (c == null) {
            c = clazz.isArray() ? arrayCoercion : (o instanceof LuaValue ? luaCoercion : instanceCoercion);
            COERCIONS.put(clazz, c);
        }
        return c.coerce(o);
    }

    static {
        Coercion boolCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Boolean b = (Boolean)javaValue;
                return b != false ? LuaValue.TRUE : LuaValue.FALSE;
            }
        };
        Coercion intCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Number n = (Number)javaValue;
                return LuaInteger.valueOf(n.intValue());
            }
        };
        Coercion charCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Character c = (Character)javaValue;
                return LuaInteger.valueOf(c.charValue());
            }
        };
        Coercion doubleCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                Number n = (Number)javaValue;
                return LuaDouble.valueOf(n.doubleValue());
            }
        };
        Coercion stringCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return LuaString.valueOf(javaValue.toString());
            }
        };
        Coercion bytesCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return LuaValue.valueOf((byte[])javaValue);
            }
        };
        Coercion classCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return JavaClass.forClass((Class)javaValue);
            }
        };
        COERCIONS.put(Boolean.class, boolCoercion);
        COERCIONS.put(Byte.class, intCoercion);
        COERCIONS.put(Character.class, charCoercion);
        COERCIONS.put(Short.class, intCoercion);
        COERCIONS.put(Integer.class, intCoercion);
        COERCIONS.put(Long.class, doubleCoercion);
        COERCIONS.put(Float.class, doubleCoercion);
        COERCIONS.put(Double.class, doubleCoercion);
        COERCIONS.put(String.class, stringCoercion);
        COERCIONS.put(byte[].class, bytesCoercion);
        COERCIONS.put(Class.class, classCoercion);
        instanceCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return new JavaInstance(javaValue);
            }
        };
        arrayCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return new JavaArray(javaValue);
            }
        };
        luaCoercion = new Coercion(){

            @Override
            public LuaValue coerce(Object javaValue) {
                return (LuaValue)javaValue;
            }
        };
    }

    static interface Coercion {
        public LuaValue coerce(Object var1);
    }
}

