/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.com.naef.jnlua;

public class LuaStackTraceElement {
    private String functionName;
    private String sourceName;
    private int lineNumber;

    public LuaStackTraceElement(String functionName, String sourceName, int lineNumber) {
        this.functionName = functionName;
        this.sourceName = sourceName;
        this.lineNumber = lineNumber;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        int result2 = this.functionName != null ? this.functionName.hashCode() : 0;
        result2 = result2 * 65599 + this.sourceName != null ? this.sourceName.hashCode() : 0;
        result2 = result2 * 65599 + this.lineNumber;
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LuaStackTraceElement)) {
            return false;
        }
        LuaStackTraceElement other = (LuaStackTraceElement)obj;
        return this.safeEquals(this.functionName, other.functionName) && this.safeEquals(this.sourceName, other.sourceName) && this.lineNumber == other.lineNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.functionName != null) {
            sb.append(this.functionName);
        } else {
            sb.append("(Unknown Function)");
        }
        sb.append(" (");
        if (this.sourceName != null) {
            sb.append(this.sourceName);
            if (this.lineNumber >= 0) {
                sb.append(':');
                sb.append(this.lineNumber);
            }
        } else {
            sb.append("External Function");
        }
        sb.append(')');
        return sb.toString();
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

