/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.vanilla;

import li.cil.oc.api.driver.EnvironmentAware;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.world.World;

public final class DriverNoteBlock
extends DriverTileEntity
implements EnvironmentAware {
    @Override
    public Class<?> getTileEntityClass() {
        return TileEntityNote.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
        return new Environment((TileEntityNote)world.func_147438_o(x, y, z));
    }

    @Override
    public Class<? extends li.cil.oc.api.network.Environment> providedEnvironment(ItemStack stack) {
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150323_B) {
            return Environment.class;
        }
        return null;
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<TileEntityNote>
    implements NamedBlock {
        public Environment(TileEntityNote tileEntity) {
            super(tileEntity, "note_block");
        }

        @Override
        public String preferredName() {
            return "note_block";
        }

        @Override
        public int priority() {
            return 0;
        }

        @Callback(direct=true, doc="function():number -- Get the currently set pitch on this note block.")
        public Object[] getPitch(Context context, Arguments args) {
            return new Object[]{((TileEntityNote)this.tileEntity).field_145879_a + 1};
        }

        @Callback(doc="function(value:number) -- Set the pitch for this note block. Must be in the interval [1, 25].")
        public Object[] setPitch(Context context, Arguments args) {
            this.setPitch(args.checkInteger(0));
            return new Object[]{true};
        }

        @Callback(doc="function([pitch:number]):boolean -- Triggers the note block if possible. Allows setting the pitch for to save a tick.")
        public Object[] trigger(Context context, Arguments args) {
            int z;
            int y;
            int x;
            World world;
            Material material;
            if (args.count() > 0 && args.checkAny(0) != null) {
                this.setPitch(args.checkInteger(0));
            }
            boolean canTrigger = (material = (world = ((TileEntityNote)this.tileEntity).func_145831_w()).func_147439_a(x = ((TileEntityNote)this.tileEntity).field_145851_c, (y = ((TileEntityNote)this.tileEntity).field_145848_d) + 1, z = ((TileEntityNote)this.tileEntity).field_145849_e).func_149688_o()) == Material.field_151579_a;
            ((TileEntityNote)this.tileEntity).func_145878_a(world, x, y, z);
            return new Object[]{canTrigger};
        }

        private void setPitch(int value) {
            if (value < 1 || value > 25) {
                throw new IllegalArgumentException("invalid pitch");
            }
            ((TileEntityNote)this.tileEntity).field_145879_a = (byte)(value - 1);
            ((TileEntityNote)this.tileEntity).func_70296_d();
        }
    }
}

