/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.ic2;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.world.World;

public final class DriverReactorChamber
extends DriverTileEntity {
    @Override
    public Class<?> getTileEntityClass() {
        return IReactorChamber.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
        return new Environment((IReactorChamber)world.func_147438_o(x, y, z));
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<IReactorChamber>
    implements NamedBlock {
        public Environment(IReactorChamber tileEntity) {
            super(tileEntity, "reactor_chamber");
        }

        @Override
        public String preferredName() {
            return "reactor_chamber";
        }

        @Override
        public int priority() {
            return 0;
        }

        @Callback(doc="function():number -- Get the reactor's heat.")
        public Object[] getHeat(Context context, Arguments args) {
            IReactor reactor = ((IReactorChamber)this.tileEntity).getReactor();
            if (reactor != null) {
                return new Object[]{reactor.getHeat()};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's maximum heat before exploding.")
        public Object[] getMaxHeat(Context context, Arguments args) {
            IReactor reactor = ((IReactorChamber)this.tileEntity).getReactor();
            if (reactor != null) {
                return new Object[]{((IReactorChamber)this.tileEntity).getReactor().getMaxHeat()};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's energy output. Not multiplied with the base EU/t value.")
        public Object[] getReactorEnergyOutput(Context context, Arguments args) {
            IReactor reactor = ((IReactorChamber)this.tileEntity).getReactor();
            if (reactor != null) {
                return new Object[]{Float.valueOf(((IReactorChamber)this.tileEntity).getReactor().getReactorEnergyOutput())};
            }
            return new Object[]{0};
        }

        @Callback(doc="function():number -- Get the reactor's base EU/t value.")
        public Object[] getReactorEUOutput(Context context, Arguments args) {
            return new Object[]{((IReactorChamber)this.tileEntity).getReactor().getReactorEUEnergyOutput()};
        }

        @Callback(doc="function():boolean -- Get whether the reactor is active and supposed to produce energy.")
        public Object[] producesEnergy(Context context, Arguments args) {
            IReactor reactor = ((IReactorChamber)this.tileEntity).getReactor();
            if (reactor != null) {
                return new Object[]{((IReactorChamber)this.tileEntity).getReactor().produceEnergy()};
            }
            return new Object[]{false};
        }
    }
}

