/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.machine.MachineHost;
import li.cil.oc.common.SaveHandler$;
import li.cil.oc.common.SaveHandlerJava17Functionality$;
import li.cil.oc.util.BlockPosition;
import li.cil.oc.util.BlockPosition$;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SaveHandler$ {
    public static final SaveHandler$ MODULE$;
    private final String li$cil$oc$common$SaveHandler$$uuidRegex;
    private final int li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves;
    private final Map<Object, Map<ChunkCoordIntPair, Map<String, byte[]>>> saveData;

    static {
        new SaveHandler$();
    }

    public String li$cil$oc$common$SaveHandler$$uuidRegex() {
        return this.li$cil$oc$common$SaveHandler$$uuidRegex;
    }

    public int li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves() {
        return this.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves;
    }

    public Map<Object, Map<ChunkCoordIntPair, Map<String, byte[]>>> saveData() {
        return this.saveData;
    }

    public File savePath() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), Settings$.MODULE$.savePath());
    }

    public File statePath() {
        return new File(this.savePath(), "state");
    }

    public void scheduleSave(MachineHost host, NBTTagCompound nbt, String name, byte[] data) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(host), nbt, name, data);
    }

    public void scheduleSave(MachineHost host, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(host, nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(EnvironmentHost host, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(host), nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(World world, double x, double z, NBTTagCompound nbt, String name, byte[] data) {
        this.scheduleSave(BlockPosition$.MODULE$.apply(x, 0.0, z, world), nbt, name, data);
    }

    public void scheduleSave(World world, double x, double z, NBTTagCompound nbt, String name, Function1<NBTTagCompound, BoxedUnit> save2) {
        this.scheduleSave(world, x, z, nbt, name, this.writeNBT(save2));
    }

    public void scheduleSave(BlockPosition position, NBTTagCompound nbt, String name, byte[] data) {
        World world = (World)position.world().get();
        int dimension = world.field_73011_w.field_76574_g;
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(position.x() >> 4, position.z() >> 4);
        nbt.func_74768_a("dimension", dimension);
        nbt.func_74768_a("chunkX", chunk.field_77276_a);
        nbt.func_74768_a("chunkZ", chunk.field_77275_b);
        this.scheduleSave(dimension, chunk, name, data);
    }

    private byte[] writeNBT(Function1<NBTTagCompound, BoxedUnit> save2) {
        NBTTagCompound tmpNbt = new NBTTagCompound();
        save2.apply((Object)tmpNbt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        CompressedStreamTools.func_74800_a((NBTTagCompound)tmpNbt, (DataOutput)dos);
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NBTTagCompound loadNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound nBTTagCompound;
        byte[] data = this.load(nbt, name);
        if (data.length <= 0) {
            nBTTagCompound = new NBTTagCompound();
            return nBTTagCompound;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            nBTTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)dis);
            return nBTTagCompound;
        }
        catch (Throwable throwable) {
            OpenComputers$.MODULE$.log().warn("There was an error trying to restore a block's state from external data. This indicates that data was somehow corrupted.", throwable);
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public byte[] load(NBTTagCompound nbt, String name) {
        int dimension = nbt.func_74762_e("dimension");
        ChunkCoordIntPair chunk = new ChunkCoordIntPair(nbt.func_74762_e("chunkX"), nbt.func_74762_e("chunkZ"));
        return this.load(dimension, chunk, name);
    }

    public Map<String, byte[]> scheduleSave(int dimension, ChunkCoordIntPair chunk, String name, byte[] data) {
        Map<Object, Map<ChunkCoordIntPair, Map<String, byte[]>>> map = this.saveData();
        synchronized (map) {
            if (chunk == null) {
                throw new IllegalArgumentException("chunk is null");
            }
            this.saveData().values().foreach((Function1)new Serializable(name){
                public final String name$1;

                public final void apply(Map<ChunkCoordIntPair, Map<String, byte[]>> chunks) {
                    chunks.values().foreach((Function1)new Serializable(this){
                        private final /* synthetic */ anonfun.scheduleSave.1 $outer;

                        public final Map<String, byte[]> apply(Map<String, byte[]> x$1) {
                            return (Map)x$1.$minus$eq((Object)this.$outer.name$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.name$1 = name$1;
                }
            });
            Map chunks = (Map)this.saveData().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)dimension), (Function0)new Serializable(){

                public final Map<ChunkCoordIntPair, Map<String, byte[]>> apply() {
                    return Map$.MODULE$.empty();
                }
            });
            MapLike mapLike = ((MapLike)chunks.getOrElseUpdate((Object)chunk, (Function0)new Serializable(){

                public final Map<String, byte[]> apply() {
                    return Map$.MODULE$.empty();
                }
            })).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)data));
            return (Map)mapLike;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] load(int dimension, ChunkCoordIntPair chunk, String name) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (chunk == null) {
            throw new IllegalArgumentException("chunk is null");
        }
        Option option = this.saveData().get((Object)BoxesRunTime.boxToInteger((int)dimension));
        if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            Map chunks = (Map)some.x();
            Option option2 = chunks.get((Object)chunk);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Map map = (Map)some2.x();
                Option option3 = map.get((Object)name);
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    return (byte[])some3.x();
                }
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        File path = this.statePath();
        File dimPath = new File(path, ((Object)BoxesRunTime.boxToInteger((int)dimension)).toString());
        File chunkPath = new File(dimPath, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)chunk.field_77276_a), BoxesRunTime.boxToInteger((int)chunk.field_77275_b)})));
        File file = new File(chunkPath, name);
        if (!file.exists()) return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int read = 0;
            do {
                if ((read = bis.read(buffer)) <= 0) continue;
                bos.write(buffer, 0, read);
            } while (read >= 0);
            bis.close();
            byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            OpenComputers$.MODULE$.log().warn("Error loading auxiliary tile entity data.", (Throwable)iOException);
            byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        }
        return byArray;
    }

    @SubscribeEvent
    public Object onChunkSave(ChunkDataEvent.Save e) {
        Map<Object, Map<ChunkCoordIntPair, Map<String, byte[]>>> map = this.saveData();
        synchronized (map) {
            Object object;
            Option option;
            File path = this.statePath();
            int dimension = e.world.field_73011_w.field_76574_g;
            ChunkCoordIntPair chunk = e.getChunk().func_76632_l();
            File dimPath = new File(path, ((Object)BoxesRunTime.boxToInteger((int)dimension)).toString());
            File chunkPath = new File(dimPath, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)chunk.field_77276_a), BoxesRunTime.boxToInteger((int)chunk.field_77275_b)})));
            if (chunkPath.exists() && chunkPath.isDirectory() && chunkPath.list() != null) {
                Predef$.MODULE$.refArrayOps((Object[])chunkPath.listFiles()).withFilter((Function1)new Serializable(){

                    public final boolean apply(File file) {
                        return System.currentTimeMillis() - file.lastModified() > (long)SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves();
                    }
                }).foreach((Function1)new Serializable(){

                    public final boolean apply(File file) {
                        return file.delete();
                    }
                });
            }
            if ((option = this.saveData().get((Object)BoxesRunTime.boxToInteger((int)dimension))) instanceof Some) {
                Boolean bl;
                Some some = (Some)option;
                Map chunks = (Map)some.x();
                Option option2 = chunks.get((Object)chunk);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Map entries = (Map)some2.x();
                    chunkPath.mkdirs();
                    entries.withFilter((Function1)new Serializable(){

                        public final boolean apply(Tuple2<String, byte[]> check$ifrefutable$1) {
                            Tuple2<String, byte[]> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(chunkPath){
                        private final File chunkPath$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void apply(Tuple2<String, byte[]> x$2) {
                            BoxedUnit boxedUnit;
                            Tuple2<String, byte[]> tuple2 = x$2;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            String name = (String)tuple2._1();
                            byte[] data = (byte[])tuple2._2();
                            File file = new File(this.chunkPath$1, name);
                            try {
                                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
                                fos.write(data);
                                fos.close();
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (IOException iOException) {
                                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error saving auxiliary tile entity data to '", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})), (Throwable)iOException);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        }
                        {
                            this.chunkPath$1 = chunkPath$1;
                        }
                    });
                    bl = BoxedUnit.UNIT;
                } else {
                    bl = BoxesRunTime.boxToBoolean((boolean)chunkPath.delete());
                }
                object = bl;
            } else {
                object = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load e) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7)) {
            SaveHandlerJava17Functionality$.MODULE$.visitJava17(this.statePath());
        } else {
            this.visitJava16();
        }
    }

    private void visitJava16() {
        this.li$cil$oc$common$SaveHandler$$recurse$1(this.statePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldSave(WorldEvent.Save e) {
        block5: {
            File[] emptyDirs;
            Map<Object, Map<ChunkCoordIntPair, Map<String, byte[]>>> map = this.saveData();
            synchronized (map) {
                Option option = this.saveData().get((Object)BoxesRunTime.boxToInteger((int)e.world.field_73011_w.field_76574_g));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Map chunks = (Map)some.x();
                    chunks.clear();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : map
                emptyDirs = this.savePath().listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        String[] list2;
                        return file.isDirectory() && file.getName().matches(SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$uuidRegex()) && System.currentTimeMillis() - file.lastModified() > (long)SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves() && ((list2 = file.list()) == null || Predef$.MODULE$.refArrayOps((Object[])list2).isEmpty());
                    }
                });
                if (emptyDirs == null) break block5;
            }
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])emptyDirs).filter((Function1)new Serializable(){

                public final boolean apply(File x$3) {
                    return x$3 != null;
                }
            })).foreach((Function1)new Serializable(){

                public final boolean apply(File x$4) {
                    return x$4.delete();
                }
            });
        }
    }

    public final void li$cil$oc$common$SaveHandler$$recurse$1(File file) {
        file.setLastModified(System.currentTimeMillis());
        if (file.exists() && file.isDirectory() && file.list() != null) {
            Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).foreach((Function1)new Serializable(){

                public final void apply(File file) {
                    SaveHandler$.MODULE$.li$cil$oc$common$SaveHandler$$recurse$1(file);
                }
            });
        }
    }

    private SaveHandler$() {
        MODULE$ = this;
        this.li$cil$oc$common$SaveHandler$$uuidRegex = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
        this.li$cil$oc$common$SaveHandler$$TimeToHoldOntoOldSaves = 60000;
        this.saveData = Map$.MODULE$.empty();
    }
}

