/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

public class Stack<E>
implements Iterable<E> {
    private final List<E> data;

    public Stack() {
        this.data = Lists.newArrayList();
    }

    public Stack(int initialCapacity) {
        this.data = Lists.newArrayListWithCapacity((int)initialCapacity);
    }

    public void push(E value) {
        this.data.add(value);
    }

    public E pop() {
        if (this.data.isEmpty()) {
            throw new StackUnderflowException();
        }
        try {
            return this.data.remove(this.data.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new StackUnderflowException();
        }
    }

    public E peek(int index) {
        return this.data.get(this.data.size() - 1 - index);
    }

    public void dup() {
        E last = this.data.get(this.data.size() - 1);
        this.data.add(last);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public static <T> Stack<T> create() {
        return new Stack();
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    public static class StackUnderflowException
    extends RuntimeException {
        private static final long serialVersionUID = 360455673552034663L;

        public StackUnderflowException() {
            super("stack underflow");
        }
    }
}

