/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.cls;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import openmods.reflection.FieldAccess;
import openmods.reflection.TypeUtils;
import openmods.serializable.IObjectSerializer;
import openmods.serializable.SerializerRegistry;
import openmods.serializable.cls.Serialize;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.InputBitStream;
import openmods.utils.io.OutputBitStream;
import openmods.utils.io.StreamUtils;

public class ClassSerializerBuilder<T> {
    private final Class<? extends T> ownerClass;
    private final List<SerializableField> fields = Lists.newArrayList();
    private final Set<Field> addedFields = Sets.newHashSet();
    private int nullableCount = 0;

    public ClassSerializerBuilder(Class<? extends T> ownerClass) {
        this.ownerClass = ownerClass;
    }

    public void appendField(Field field) {
        boolean isNullable;
        Preconditions.checkArgument((boolean)field.getDeclaringClass().isAssignableFrom(this.ownerClass), (String)"%s does not belong to %s", (Object[])new Object[]{field, this.ownerClass});
        boolean newlyAdded = this.addedFields.add(field);
        Preconditions.checkState((boolean)newlyAdded, (String)"%s already added", (Object[])new Object[]{field});
        Serialize annotation = field.getAnnotation(Serialize.class);
        boolean bl = isNullable = !field.getType().isPrimitive() && annotation != null && annotation.nullable();
        if (isNullable) {
            ++this.nullableCount;
        }
        this.fields.add(new SerializableField(this.ownerClass, field, isNullable));
    }

    public IObjectSerializer<T> create() {
        return this.nullableCount != 0 ? new NullableSerializer(this.fields, StreamUtils.bitsToBytes(this.nullableCount)) : new NonNullableSerializer(this.fields);
    }

    private static class NullableSerializer<T>
    implements IObjectSerializer<T> {
        private final List<SerializableField> fields;
        private final int nullBytesCount;

        public NullableSerializer(List<SerializableField> fields, int nullBytesCount) {
            this.fields = ImmutableList.copyOf(fields);
            this.nullBytesCount = nullBytesCount;
        }

        @Override
        public void readFromStream(T object, DataInput input) throws IOException {
            byte[] nullBits = StreamUtils.readBytes(input, this.nullBytesCount);
            InputBitStream nullBitStream = InputBitStream.create(nullBits);
            for (SerializableField field : this.fields) {
                boolean isNull = field.isNullable && nullBitStream.readBit();
                Object value = isNull ? null : (Object)field.serializer.readFromStream(input);
                field.set(object, value);
            }
        }

        @Override
        public void writeToStream(T object, DataOutput output) throws IOException {
            ByteArrayDataOutput payload = ByteStreams.newDataOutput();
            OutputBitStream nullBitsStream = OutputBitStream.create(output);
            for (SerializableField field : this.fields) {
                Object value = field.get(object);
                if (field.isNullable) {
                    if (value == null) {
                        nullBitsStream.writeBit(true);
                        continue;
                    }
                    nullBitsStream.writeBit(false);
                    field.serializer.writeToStream(value, (DataOutput)payload);
                    continue;
                }
                field.serializer.writeToStream(value, (DataOutput)payload);
            }
            nullBitsStream.flush();
            output.write(payload.toByteArray());
        }
    }

    private static class NonNullableSerializer<T>
    implements IObjectSerializer<T> {
        private final List<SerializableField> fields;

        public NonNullableSerializer(List<SerializableField> fields) {
            this.fields = ImmutableList.copyOf(fields);
        }

        @Override
        public void readFromStream(T object, DataInput input) throws IOException {
            for (SerializableField field : this.fields) {
                Object value = field.serializer.readFromStream(input);
                field.set(object, value);
            }
        }

        @Override
        public void writeToStream(T object, DataOutput output) throws IOException {
            for (SerializableField field : this.fields) {
                Object value = field.get(object);
                Preconditions.checkNotNull(value, (String)"Non-nullable %s has null value", (Object[])new Object[]{field.field});
                field.serializer.writeToStream(value, output);
            }
        }
    }

    private static class SerializableField
    extends FieldAccess<Object> {
        private final IStreamSerializer<Object> serializer;
        private final boolean isNullable;

        public SerializableField(Class<?> ownerCls, Field field, boolean isNullable) {
            super(field);
            this.isNullable = isNullable;
            TypeToken<?> fieldType = TypeUtils.resolveFieldType(ownerCls, field);
            this.serializer = SerializerRegistry.instance.findSerializer(fieldType.getType());
            Preconditions.checkNotNull(this.serializer, (String)"Invalid field %s type", (Object[])new Object[]{field});
        }
    }
}

