/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import com.google.common.base.Strings;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.page.BookScaleConfig;
import openmods.gui.component.page.PageBase;
import openmods.utils.RecipeUtils;
import openmods.utils.render.FakeIcon;

public class StandardRecipePage
extends PageBase {
    public static IIcon iconCraftingGrid = FakeIcon.createSheetIcon(0, 180, 56, 56);
    public static IIcon iconArrow = FakeIcon.createSheetIcon(60, 198, 48, 15);

    public StandardRecipePage(String title, String description, ItemStack resultingItem) {
        ItemStack[][] input;
        this.addComponent(new GuiComponentSprite(75, 40, iconArrow, BOOK_TEXTURE));
        this.addComponent(new GuiComponentItemStackSpinner(140, 30, resultingItem));
        IRecipe recipe = RecipeUtils.getFirstRecipeForItemStack(resultingItem);
        if (recipe != null && (input = RecipeUtils.getFullRecipeInput(recipe)) != null) {
            this.addComponent(new GuiComponentCraftingGrid(10, 20, input, iconCraftingGrid, BOOK_TEXTURE));
        }
        String translatedTitle = StatCollector.func_74838_a((String)title);
        GuiComponentLabel titleLabel = new GuiComponentLabel(0, 2, translatedTitle);
        titleLabel.setX((this.getWidth() - titleLabel.getWidth()) / 2);
        titleLabel.setScale(BookScaleConfig.getPageTitleScale());
        this.addComponent(titleLabel);
        String translatedDescription = StatCollector.func_74838_a((String)description).replaceAll("\\\\n", "\n");
        GuiComponentLabel lblDescription = new GuiComponentLabel(10, 80, this.getWidth() - 5, 200, translatedDescription);
        lblDescription.setScale(BookScaleConfig.getPageContentScale());
        lblDescription.setAdditionalLineHeight(BookScaleConfig.getRecipePageSeparator());
        this.addComponent(lblDescription);
    }

    public StandardRecipePage(String title, String description, String videoLink, ItemStack resultingItem) {
        this(title, description, resultingItem);
        if (!Strings.isNullOrEmpty((String)videoLink)) {
            this.addActionButton(10, 133, videoLink, PageBase.ActionIcon.YOUTUBE.icon, "openmodslib.gui.watch_video");
        }
    }
}

