/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Preconditions;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.geometry.HalfAxis;
import openmods.geometry.Matrix3d;

public enum Orientation {
    XN_YN(HalfAxis.NEG_X, HalfAxis.NEG_Y),
    XN_YP(HalfAxis.NEG_X, HalfAxis.POS_Y),
    XN_ZN(HalfAxis.NEG_X, HalfAxis.NEG_Z),
    XN_ZP(HalfAxis.NEG_X, HalfAxis.POS_Z),
    XP_YN(HalfAxis.POS_X, HalfAxis.NEG_Y),
    XP_YP(HalfAxis.POS_X, HalfAxis.POS_Y),
    XP_ZN(HalfAxis.POS_X, HalfAxis.NEG_Z),
    XP_ZP(HalfAxis.POS_X, HalfAxis.POS_Z),
    YN_ZP(HalfAxis.NEG_Y, HalfAxis.POS_Z),
    YN_XN(HalfAxis.NEG_Y, HalfAxis.NEG_X),
    YN_XP(HalfAxis.NEG_Y, HalfAxis.POS_X),
    YN_ZN(HalfAxis.NEG_Y, HalfAxis.NEG_Z),
    YP_XN(HalfAxis.POS_Y, HalfAxis.NEG_X),
    YP_XP(HalfAxis.POS_Y, HalfAxis.POS_X),
    YP_ZN(HalfAxis.POS_Y, HalfAxis.NEG_Z),
    YP_ZP(HalfAxis.POS_Y, HalfAxis.POS_Z),
    ZN_XP(HalfAxis.NEG_Z, HalfAxis.POS_X),
    ZN_XN(HalfAxis.NEG_Z, HalfAxis.NEG_X),
    ZN_YP(HalfAxis.NEG_Z, HalfAxis.POS_Y),
    ZN_YN(HalfAxis.NEG_Z, HalfAxis.NEG_Y),
    ZP_XN(HalfAxis.POS_Z, HalfAxis.NEG_X),
    ZP_XP(HalfAxis.POS_Z, HalfAxis.POS_X),
    ZP_YN(HalfAxis.POS_Z, HalfAxis.NEG_Y),
    ZP_YP(HalfAxis.POS_Z, HalfAxis.POS_Y);

    public static final Orientation[] VALUES;
    private static final TIntObjectMap<Orientation> LOOKUP_XY;
    private static final TIntObjectMap<Orientation> LOOKUP_XZ;
    private static final TIntObjectMap<Orientation> LOOKUP_YZ;
    private static final Orientation[][] ROTATIONS;
    public final HalfAxis x;
    public final HalfAxis y;
    public final HalfAxis z;
    private final ForgeDirection[] localToGlobalDirections = new ForgeDirection[ForgeDirection.values().length];
    private final ForgeDirection[] globalToLocalDirections = new ForgeDirection[ForgeDirection.values().length];

    private static int lookupKey(HalfAxis a, HalfAxis b) {
        return a.ordinal() << 3 | b.ordinal() << 0;
    }

    private static void addToLookup(TIntObjectMap<Orientation> lookup, Orientation o, HalfAxis a, HalfAxis b) {
        int key = Orientation.lookupKey(a, b);
        Orientation prev = (Orientation)((Object)lookup.put(key, (Object)o));
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Key %s duplicate: %s->%s", (Object[])new Object[]{key, prev, o});
    }

    public static Orientation lookupXY(HalfAxis x, HalfAxis y) {
        int key = Orientation.lookupKey(x, y);
        return (Orientation)((Object)LOOKUP_XY.get(key));
    }

    public static Orientation lookupXZ(HalfAxis x, HalfAxis z) {
        int key = Orientation.lookupKey(x, z);
        return (Orientation)((Object)LOOKUP_XZ.get(key));
    }

    public static Orientation lookupYZ(HalfAxis y, HalfAxis z) {
        int key = Orientation.lookupKey(y, z);
        return (Orientation)((Object)LOOKUP_YZ.get(key));
    }

    private static Orientation lookupXYNotNull(HalfAxis x, HalfAxis y) {
        Orientation v = Orientation.lookupXY(x, y);
        if (v == null) {
            throw new NullPointerException((Object)((Object)x) + ":" + (Object)((Object)y));
        }
        return v;
    }

    public static Orientation rotateAround(Orientation orientation, HalfAxis axis) {
        return ROTATIONS[orientation.ordinal()][axis.ordinal()];
    }

    public Orientation rotateAround(HalfAxis axis) {
        return Orientation.rotateAround(this, axis);
    }

    private void addDirectionMapping(ForgeDirection local, ForgeDirection global) {
        this.localToGlobalDirections[local.ordinal()] = global;
        this.globalToLocalDirections[global.ordinal()] = local;
    }

    private void addDirectionMappings(ForgeDirection local, ForgeDirection global) {
        this.addDirectionMapping(local, global);
        this.addDirectionMapping(local.getOpposite(), global.getOpposite());
    }

    private Orientation(HalfAxis x, HalfAxis y) {
        this.x = x;
        this.y = y;
        this.z = x.cross(y);
        this.addDirectionMappings(ForgeDirection.EAST, x.dir);
        this.addDirectionMappings(ForgeDirection.UP, y.dir);
        this.addDirectionMappings(ForgeDirection.SOUTH, this.z.dir);
        this.addDirectionMapping(ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN);
    }

    public ForgeDirection localToGlobalDirection(ForgeDirection local) {
        return this.localToGlobalDirections[local.ordinal()];
    }

    public ForgeDirection globalToLocalDirection(ForgeDirection global) {
        return this.globalToLocalDirections[global.ordinal()];
    }

    public ForgeDirection north() {
        return this.localToGlobalDirection(ForgeDirection.NORTH);
    }

    public ForgeDirection south() {
        return this.localToGlobalDirection(ForgeDirection.SOUTH);
    }

    public ForgeDirection east() {
        return this.localToGlobalDirection(ForgeDirection.EAST);
    }

    public ForgeDirection west() {
        return this.localToGlobalDirection(ForgeDirection.WEST);
    }

    public ForgeDirection up() {
        return this.localToGlobalDirection(ForgeDirection.UP);
    }

    public ForgeDirection down() {
        return this.localToGlobalDirection(ForgeDirection.DOWN);
    }

    public double transformX(double x, double y, double z) {
        return (double)this.x.x * x + (double)this.y.x * y + (double)this.z.x * z;
    }

    public int transformX(int x, int y, int z) {
        return this.x.x * x + this.y.x * y + this.z.x * z;
    }

    public double transformY(double x, double y, double z) {
        return (double)this.x.y * x + (double)this.y.y * y + (double)this.z.y * z;
    }

    public int transformY(int x, int y, int z) {
        return this.x.y * x + this.y.y * y + this.z.y * z;
    }

    public double transformZ(double x, double y, double z) {
        return (double)this.x.z * x + (double)this.y.z * y + (double)this.z.z * z;
    }

    public int transformZ(int x, int y, int z) {
        return this.x.z * x + this.y.z * y + this.z.z * z;
    }

    public Matrix3d createTransformMatrix() {
        Matrix3d mat = new Matrix3d();
        mat.m00 = this.x.x;
        mat.m01 = this.x.y;
        mat.m02 = this.x.z;
        mat.m10 = this.y.x;
        mat.m11 = this.y.y;
        mat.m12 = this.y.z;
        mat.m20 = this.z.x;
        mat.m21 = this.z.y;
        mat.m22 = this.z.z;
        return mat;
    }

    static {
        VALUES = Orientation.values();
        LOOKUP_XY = new TIntObjectHashMap(VALUES.length);
        LOOKUP_XZ = new TIntObjectHashMap(VALUES.length);
        LOOKUP_YZ = new TIntObjectHashMap(VALUES.length);
        ROTATIONS = new Orientation[VALUES.length][HalfAxis.VALUES.length];
        for (Orientation o : VALUES) {
            Orientation.addToLookup(LOOKUP_XY, o, o.x, o.y);
            Orientation.addToLookup(LOOKUP_YZ, o, o.y, o.z);
            Orientation.addToLookup(LOOKUP_XZ, o, o.x, o.z);
        }
        for (Orientation o : VALUES) {
            int i = o.ordinal();
            Orientation.ROTATIONS[i][HalfAxis.POS_X.ordinal()] = Orientation.lookupXYNotNull(o.x, o.z.negate());
            Orientation.ROTATIONS[i][HalfAxis.NEG_X.ordinal()] = Orientation.lookupXYNotNull(o.x, o.z);
            Orientation.ROTATIONS[i][HalfAxis.POS_Y.ordinal()] = Orientation.lookupXYNotNull(o.z, o.y);
            Orientation.ROTATIONS[i][HalfAxis.NEG_Y.ordinal()] = Orientation.lookupXYNotNull(o.z.negate(), o.y);
            Orientation.ROTATIONS[i][HalfAxis.POS_Z.ordinal()] = Orientation.lookupXYNotNull(o.y.negate(), o.x);
            Orientation.ROTATIONS[i][HalfAxis.NEG_Z.ordinal()] = Orientation.lookupXYNotNull(o.y, o.x.negate());
        }
    }
}

