/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import openmods.calc.BinaryOperator;
import openmods.calc.IExecutable;
import openmods.calc.Operator;
import openmods.calc.UnaryOperator;

public class OperatorDictionary<E> {
    private final Map<String, BinaryOperator<E>> binaryOperators = Maps.newHashMap();
    private final Map<String, UnaryOperator<E>> unaryOperators = Maps.newHashMap();

    public void registerBinaryOperator(String id, BinaryOperator<E> operator) {
        IExecutable prev = this.binaryOperators.put(id, operator);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operator '%s': %s -> %s", (Object[])new Object[]{prev, operator});
    }

    public void registerUnaryOperator(String id, UnaryOperator<E> operator) {
        IExecutable prev = this.unaryOperators.put(id, operator);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate operator '%s': %s -> %s", (Object[])new Object[]{prev, operator});
    }

    public void registerMixedOperator(String id, BinaryOperator<E> binaryOperator, UnaryOperator<E> unaryOperator) {
        this.registerBinaryOperator(id, binaryOperator);
        this.registerUnaryOperator(id, unaryOperator);
    }

    public Set<String> allOperators() {
        return Sets.union(this.binaryOperators.keySet(), this.unaryOperators.keySet());
    }

    public Operator<E> getBinaryOperator(String op) {
        return this.binaryOperators.get(op);
    }

    public Operator<E> getUnaryOperator(String value) {
        return this.unaryOperators.get(value);
    }

    public Operator<E> getAnyOperator(String value) {
        Operator op = this.binaryOperators.get(value);
        if (op != null) {
            return op;
        }
        return this.unaryOperators.get(value);
    }
}

