/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.cse.fire;

import WayofTime.alchemicalWizardry.api.spell.ComplexSpellEffect;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellModifier;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellType;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigmSelf;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.fire.SelfOffensiveFire;

public class CSESelfOffensiveFire
extends ComplexSpellEffect {
    public CSESelfOffensiveFire() {
        super(ComplexSpellType.FIRE, ComplexSpellModifier.OFFENSIVE);
    }

    public CSESelfOffensiveFire(int power, int cost, int potency) {
        this();
        this.powerEnhancement = power;
        this.costEnhancement = cost;
        this.potencyEnhancement = potency;
    }

    @Override
    public void modifyParadigm(SpellParadigm parad) {
        if (parad instanceof SpellParadigmSelf) {
            ((SpellParadigmSelf)parad).addSelfSpellEffect(new SelfOffensiveFire(this.powerEnhancement, this.potencyEnhancement, this.costEnhancement));
        }
    }

    @Override
    public ComplexSpellEffect copy(int power, int cost, int potency) {
        return new CSESelfOffensiveFire(power, cost, potency);
    }

    @Override
    public int getCostOfEffect() {
        return (int)((double)(300 * (3 * this.powerEnhancement + 1) * (2 * this.potencyEnhancement + 1)) * Math.pow(0.85, this.costEnhancement));
    }
}

