/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.potion;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyPotionHelper;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AlchemyFlask
extends Item {
    public AlchemyFlask() {
        this.func_77656_e(8);
        this.func_77625_d(1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:PotionFlask");
    }

    public static ArrayList<AlchemyPotionHelper> getEffects(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("CustomFlaskEffects")) {
            ArrayList<AlchemyPotionHelper> arraylist = new ArrayList<AlchemyPotionHelper>();
            NBTTagList nbttaglist = par1ItemStack.func_77978_p().func_150295_c("CustomFlaskEffects", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                arraylist.add(AlchemyPotionHelper.readEffectFromNBT(nbttagcompound));
            }
            return arraylist;
        }
        return null;
    }

    public static ArrayList<PotionEffect> getPotionEffects(ItemStack par1ItemStack) {
        ArrayList<AlchemyPotionHelper> list = AlchemyFlask.getEffects(par1ItemStack);
        if (list != null) {
            ArrayList<PotionEffect> newList = new ArrayList<PotionEffect>();
            for (AlchemyPotionHelper aph : list) {
                newList.add(aph.getPotionEffect());
            }
            return newList;
        }
        return null;
    }

    public static void setEffects(ItemStack par1ItemStack, List<AlchemyPotionHelper> list) {
        NBTTagCompound itemTag = par1ItemStack.func_77978_p();
        if (itemTag == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (AlchemyPotionHelper aph : list) {
            nbttaglist.func_74742_a((NBTBase)AlchemyPotionHelper.setEffectToNBT(aph));
        }
        par1ItemStack.func_77978_p().func_74782_a("CustomFlaskEffects", (NBTBase)nbttaglist);
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrayList<AlchemyPotionHelper> list;
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
            par1ItemStack.func_77964_b(par1ItemStack.func_77960_j() + 1);
        }
        if (!par2World.field_72995_K && (list = AlchemyFlask.getEffects(par1ItemStack)) != null) {
            for (AlchemyPotionHelper aph : list) {
                PotionEffect pe = aph.getPotionEffect();
                if (pe == null) continue;
                par3EntityPlayer.func_70690_d(pe);
            }
        }
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        if (this.isPotionThrowable(par1ItemStack)) {
            return EnumAction.none;
        }
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par1ItemStack.func_77960_j() < par1ItemStack.func_77958_k()) {
            if (this.isPotionThrowable(par1ItemStack)) {
                EntityPotion entityPotion;
                if (!par2World.field_72995_K && (entityPotion = this.getEntityPotion(par1ItemStack, par2World, (EntityLivingBase)par3EntityPlayer)) != null) {
                    float velocityChange = 2.0f;
                    entityPotion.field_70159_w *= (double)velocityChange;
                    entityPotion.field_70181_x *= (double)velocityChange;
                    entityPotion.field_70179_y *= (double)velocityChange;
                    par2World.func_72838_d((Entity)entityPotion);
                    par1ItemStack.func_77964_b(par1ItemStack.func_77960_j() + 1);
                }
                return par1ItemStack;
            }
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public void setConcentrationOfPotion(ItemStack par1ItemStack, int potionID, int concentration) {
        ArrayList<AlchemyPotionHelper> list = AlchemyFlask.getEffects(par1ItemStack);
        if (list != null) {
            for (AlchemyPotionHelper aph : list) {
                if (aph.getPotionID() != potionID) continue;
                aph.setConcentration(concentration);
                break;
            }
            AlchemyFlask.setEffects(par1ItemStack, list);
        }
    }

    public void setDurationFactorOfPotion(ItemStack par1ItemStack, int potionID, int durationFactor) {
        ArrayList<AlchemyPotionHelper> list = AlchemyFlask.getEffects(par1ItemStack);
        if (list != null) {
            for (AlchemyPotionHelper aph : list) {
                if (aph.getPotionID() != potionID) continue;
                aph.setDurationFactor(durationFactor);
                break;
            }
            AlchemyFlask.setEffects(par1ItemStack, list);
        }
    }

    public boolean hasPotionEffect(ItemStack par1ItemStack, int potionID) {
        return false;
    }

    public int getNumberOfPotionEffects(ItemStack par1ItemStack) {
        if (AlchemyFlask.getEffects(par1ItemStack) != null) {
            return AlchemyFlask.getEffects(par1ItemStack).size();
        }
        return 0;
    }

    public boolean addPotionEffect(ItemStack par1ItemStack, int potionID, int tickDuration) {
        ArrayList<AlchemyPotionHelper> list = AlchemyFlask.getEffects(par1ItemStack);
        if (list != null) {
            for (AlchemyPotionHelper aph : list) {
                if (aph.getPotionID() != potionID) continue;
                return false;
            }
            list.add(new AlchemyPotionHelper(potionID, tickDuration, 0, 0));
            AlchemyFlask.setEffects(par1ItemStack, list);
            return true;
        }
        list = new ArrayList();
        list.add(new AlchemyPotionHelper(potionID, tickDuration, 0, 0));
        AlchemyFlask.setEffects(par1ItemStack, list);
        return true;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"tooltip.alchemyflask.swigsleft") + " " + (par1ItemStack.func_77958_k() - par1ItemStack.func_77960_j()) + "/" + par1ItemStack.func_77958_k());
        if (this.isPotionThrowable(par1ItemStack)) {
            par3List.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"tooltip.alchemyflask.caution"));
        }
        ArrayList<PotionEffect> list1 = AlchemyFlask.getPotionEffects(par1ItemStack);
        HashMultimap hashmultimap = HashMultimap.create();
        if (list1 != null && !list1.isEmpty()) {
            for (PotionEffect potioneffect : list1) {
                String s = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                Map map = potion.func_111186_k();
                if (map != null && map.size() > 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        hashmultimap.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1);
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s = s + " " + StatCollector.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                }
                if (potioneffect.func_76459_b() > 20) {
                    s = s + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                }
                if (potion.func_76398_f()) {
                    par3List.add(EnumChatFormatting.RED + s);
                    continue;
                }
                par3List.add(EnumChatFormatting.GRAY + s);
            }
        } else {
            String s1 = StatCollector.func_74838_a((String)"potion.empty").trim();
            par3List.add(EnumChatFormatting.GRAY + s1);
        }
        if (!hashmultimap.isEmpty()) {
            par3List.add("");
            par3List.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
            for (Map.Entry entry1 : hashmultimap.entries()) {
                AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    par3List.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                par3List.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
            }
        }
    }

    public boolean isPotionThrowable(ItemStack par1ItemStack) {
        return par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74767_n("throwable");
    }

    public void setIsPotionThrowable(boolean flag, ItemStack par1ItemStack) {
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74757_a("throwable", flag);
    }

    public EntityPotion getEntityPotion(ItemStack par1ItemStack, World worldObj, EntityLivingBase entityLivingBase) {
        ItemStack potionStack = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        potionStack.func_77982_d(new NBTTagCompound());
        ArrayList<PotionEffect> potionList = AlchemyFlask.getPotionEffects(par1ItemStack);
        if (potionList == null) {
            return null;
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (PotionEffect pe : potionList) {
            NBTTagCompound d = new NBTTagCompound();
            d.func_74774_a("Id", (byte)pe.func_76456_a());
            d.func_74774_a("Amplifier", (byte)pe.func_76458_c());
            d.func_74768_a("Duration", pe.func_76459_b());
            d.func_74757_a("Ambient", pe.func_82720_e());
            nbttaglist.func_74742_a((NBTBase)d);
        }
        potionStack.func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)nbttaglist);
        return new EntityPotion(worldObj, entityLivingBase, potionStack);
    }
}

