/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.leveling.LevelingTooltips;
import iguanaman.iguanatweakstconstruct.leveling.RandomBonuses;
import iguanaman.iguanatweakstconstruct.reference.Config;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import tconstruct.items.tools.Chisel;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.weaponry.entity.ShurikenEntity;
import tconstruct.weaponry.weapons.Shuriken;

public class LevelingEventHandler {
    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (!event.source.field_76373_n.equals("player") && !event.source.field_76373_n.equals("arrow")) {
            return;
        }
        if (!(event.source.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (event.source.func_76364_f() instanceof ShurikenEntity) {
            if (stack == null || !(stack.func_77973_b() instanceof Shuriken)) {
                stack = player.field_71071_by.field_70461_c == 0 ? player.field_71071_by.func_70301_a(8) : player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c + 1);
            }
            if (stack != null && !(stack.func_77973_b() instanceof Shuriken)) {
                stack = null;
            }
        }
        if (stack == null || !stack.func_77942_o()) {
            return;
        }
        if (stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ToolCore)) {
            return;
        }
        int xp = 0;
        xp = Arrays.asList(((ToolCore)stack.func_77973_b()).getTraits()).contains("weapon") ? Math.round(event.ammount) : Math.round((event.ammount - 0.1f) / 2.0f);
        if (event.entityLiving instanceof EntityAnimal) {
            xp = Math.max(1, xp / 2);
        }
        boolean cheatyXP = false;
        if (!event.entityLiving.func_70089_S()) {
            xp = Math.max(1, Math.round((float)xp / 4.0f));
            cheatyXP = true;
        }
        ItemStack ammo = null;
        if (stack.func_77973_b() instanceof ProjectileWeapon && event.source.field_76373_n.equals("arrow") && (ammo = ((ProjectileWeapon)stack.func_77973_b()).searchForAmmo(player, stack)) != null && !(ammo.func_77973_b() instanceof ToolCore)) {
            ammo = null;
        }
        if (!event.source.field_76373_n.equals("arrow")) {
            if (stack.func_77973_b() instanceof ProjectileWeapon) {
                return;
            }
            if (Arrays.asList(((ToolCore)stack.func_77973_b()).getTraits()).contains("ammo")) {
                return;
            }
        }
        if (xp > 0) {
            for (ItemStack itemstack : new ItemStack[]{stack, ammo}) {
                if (itemstack == null) continue;
                LevelingLogic.addXP(itemstack, player, xp);
                NBTTagCompound tags = itemstack.func_77978_p().func_74775_l("InfiTool");
                if (cheatyXP) {
                    int cxp = tags.func_74762_e("CheatyXP");
                    tags.func_74768_a("CheatyXP", cxp + xp);
                }
                if (event.entityLiving instanceof EntityAnimal) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LAPIS, xp + 5, tags);
                } else {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.ATTACK, xp, tags);
                }
                if (event.entityLiving instanceof EntitySpider) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BANE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityBlaze) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BLAZE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityPigZombie) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntityZombie) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.SMITE, Math.max(1, xp / 2), tags);
                } else if (event.entityLiving instanceof EntitySkeleton) {
                    if (((EntitySkeleton)event.entityLiving).func_82202_m() != 0) {
                        RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.LIFESTEAL, Math.max(1, xp / 2) + 2, tags);
                    }
                } else if (event.entityLiving instanceof EntityEnderman) {
                    RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.BEHEADING, Math.max(1, xp / 2) + 3, tags);
                }
                if (!player.func_70051_ag()) continue;
                RandomBonuses.addModifierExtraWeight(RandomBonuses.Modifier.KNOCKBACK, xp + 2, tags);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        ItemStack stack;
        EntityPlayer player = event.entityPlayer;
        if (player instanceof FakePlayer) {
            return;
        }
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        Block blockAbove = event.world.func_147439_a(event.x, event.y + 1, event.z);
        if (blockAbove.isAir((IBlockAccess)event.world, event.x, event.y + 1, event.z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d) && (stack = event.current) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
            LevelingLogic.addXP(stack, player, 1L);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting == null) {
            return;
        }
        ItemStack chisel = null;
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            if (event.craftMatrix.func_70301_a(i) == null || !(event.craftMatrix.func_70301_a(i).func_77973_b() instanceof Chisel)) continue;
            chisel = event.craftMatrix.func_70301_a(i);
        }
        if (chisel == null) {
            return;
        }
        LevelingLogic.addXP(chisel, event.player, 1L);
    }

    @SubscribeEvent
    public void onCraftTool(ToolCraftEvent.NormalTool event) {
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        LevelingLogic.addLevelingTags(toolTag, event.tool);
        toolTag.func_74768_a("Modifiers", Math.max(toolTag.func_74762_e("Modifiers") - (3 - Config.toolLevelingExtraModifiers), 0));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (Config.toolLeveling && Config.showDebugXP) {
            ItemStack equipped;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            if (!player.field_70128_L && mc.field_71474_y.field_74330_P && (equipped = player.func_71045_bC()) != null && equipped.func_77973_b() != null && equipped.func_77973_b() instanceof ToolCore) {
                int hLevel;
                NBTTagCompound tags = equipped.func_77978_p().func_74775_l("InfiTool");
                int level = tags.func_74762_e("ToolLevel");
                hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
                event.left.add("");
                if (Config.showTooltipXP) {
                    if (level <= 5) {
                        event.left.add(LevelingTooltips.getXpToolTip(equipped, null));
                    }
                    if (Config.levelingPickaxeBoost && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.func_74764_b("HarvestLevelModified") && (equipped.func_77973_b() instanceof Pickaxe || equipped.func_77973_b() instanceof Hammer)) {
                        event.left.add(LevelingTooltips.getBoostXpToolTip(equipped, null));
                    }
                }
            }
        }
    }
}

