/*
 * Decompiled with CFR 0.152.
 */
package org.github.trainerguy22.jtoml.impl;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.trainerguy22.jtoml.Getter;
import org.github.trainerguy22.jtoml.Util;

public class TomlWrapper
implements Getter {
    protected Map<String, Object> context;
    protected final Matcher keyPathMatcher = Pattern.compile("((\\w+[.])+).*").matcher("");

    public TomlWrapper(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public Object get(String key) {
        if (key == null || "".equals(key.trim())) {
            return this.context;
        }
        if (key.contains(".")) {
            String keyPath = this.keyPath(key);
            return this.findContext(this.context, keyPath).get(key.replace(keyPath + ".", ""));
        }
        return this.context.get(key);
    }

    @Override
    public String getString(String key) {
        return this.get(key, String.class);
    }

    @Override
    public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    @Override
    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    @Override
    public Calendar getDate(String key) {
        return this.get(key, Calendar.class);
    }

    @Override
    public List<Object> getList(String key) {
        return this.get(key, List.class);
    }

    @Override
    public Map<String, Object> getMap(String key) {
        return this.get(key, Map.class);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    @Override
    public <T> T getAs(String key, Class<T> clazz) {
        try {
            T result = clazz.newInstance();
            for (Field f : clazz.getDeclaredFields()) {
                Class<?> fieldType = f.getType();
                String fieldName = key == null || "".equals(key.trim()) ? f.getName() : key + "." + f.getName();
                Object fieldValue = Util.Reflection.isTomlSupportedType(fieldType) ? this.get(fieldName, fieldType) : this.getAs(fieldName, fieldType);
                Util.Reflection.setFieldValue(f, result, fieldValue);
            }
            return result;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not map value of key `" + key + "` to Object of class `" + clazz.getName() + "`.", e);
        }
    }

    private <T> T get(String key, Class<T> clazz) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        throw this.illegalArg(key, value, clazz);
    }

    private String keyPath(String key) {
        if (this.keyPathMatcher.reset(key).matches()) {
            return this.keyPathMatcher.group(1).substring(0, this.keyPathMatcher.group(1).length() - 1);
        }
        return key;
    }

    private IllegalArgumentException illegalArg(String key, Object value, Class<?> expected) {
        return new IllegalArgumentException(String.format("Value for key `%s` is `%s`%s.", key, value, value == null ? "" : ". Expected type was `" + expected.getName() + "`"));
    }

    public Map<String, Object> findContext(Map<String, Object> context, String key) {
        Map visitor = context;
        for (String part : key.split("[.]")) {
            if (!visitor.containsKey(part)) {
                return null;
            }
            visitor = (Map)visitor.get(part);
        }
        return visitor;
    }
}

