/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render.uv;

import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import java.util.ArrayList;
import java.util.Iterator;

public class UVTransformationList
extends UVTransformation {
    private ArrayList<UVTransformation> transformations = new ArrayList();

    public UVTransformationList(UVTransformation ... uVTransformationArray) {
        for (UVTransformation uVTransformation : uVTransformationArray) {
            if (uVTransformation instanceof UVTransformationList) {
                this.transformations.addAll(((UVTransformationList)uVTransformation).transformations);
                continue;
            }
            this.transformations.add(uVTransformation);
        }
        this.compact();
    }

    @Override
    public void apply(UV uV) {
        for (int i = 0; i < this.transformations.size(); ++i) {
            this.transformations.get(i).apply(uV);
        }
    }

    @Override
    public UVTransformationList with(UVTransformation uVTransformation) {
        if (uVTransformation.isRedundant()) {
            return this;
        }
        if (uVTransformation instanceof UVTransformationList) {
            this.transformations.addAll(((UVTransformationList)uVTransformation).transformations);
        } else {
            this.transformations.add(uVTransformation);
        }
        this.compact();
        return this;
    }

    public UVTransformationList prepend(UVTransformation uVTransformation) {
        if (uVTransformation.isRedundant()) {
            return this;
        }
        if (uVTransformation instanceof UVTransformationList) {
            this.transformations.addAll(0, ((UVTransformationList)uVTransformation).transformations);
        } else {
            this.transformations.add(0, uVTransformation);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<UVTransformation> arrayList = new ArrayList<UVTransformation>(this.transformations.size());
        Iterator<UVTransformation> iterator = this.transformations.iterator();
        UVTransformation uVTransformation = null;
        while (iterator.hasNext()) {
            UVTransformation uVTransformation2 = iterator.next();
            if (uVTransformation2.isRedundant()) continue;
            if (uVTransformation != null) {
                UVTransformation uVTransformation3 = uVTransformation.merge(uVTransformation2);
                if (uVTransformation3 == null) {
                    arrayList.add(uVTransformation);
                } else {
                    uVTransformation2 = uVTransformation3.isRedundant() ? null : uVTransformation3;
                }
            }
            uVTransformation = uVTransformation2;
        }
        if (uVTransformation != null) {
            arrayList.add(uVTransformation);
        }
        if (arrayList.size() < this.transformations.size()) {
            this.transformations = arrayList;
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.size() == 0;
    }

    @Override
    public UVTransformation inverse() {
        UVTransformationList uVTransformationList = new UVTransformationList(new UVTransformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            uVTransformationList.with((UVTransformation)this.transformations.get(i).inverse());
        }
        return uVTransformationList;
    }

    public String toString() {
        String string = "";
        for (UVTransformation uVTransformation : this.transformations) {
            string = string + "\n" + uVTransformation.toString();
        }
        return string.trim();
    }
}

