/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.repack.codechicken.lib.asm.InsnComparator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class InsnListSection
implements Iterable<AbstractInsnNode> {
    public InsnList list;
    public int start;
    public int end;

    public InsnListSection(InsnList insnList, int n, int n2) {
        this.list = insnList;
        this.start = n;
        this.end = n2;
    }

    public InsnListSection(InsnList insnList, AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this(insnList, insnList.indexOf(abstractInsnNode), insnList.indexOf(abstractInsnNode2) + 1);
    }

    public InsnListSection(InsnList insnList) {
        this(insnList, 0, insnList.size());
    }

    public InsnListSection() {
        this(new InsnList());
    }

    public void accept(MethodVisitor methodVisitor) {
        for (AbstractInsnNode abstractInsnNode : this) {
            abstractInsnNode.accept(methodVisitor);
        }
    }

    public AbstractInsnNode getFirst() {
        return this.size() == 0 ? null : this.list.get(this.start);
    }

    public AbstractInsnNode getLast() {
        return this.size() == 0 ? null : this.list.get(this.end - 1);
    }

    public int size() {
        return this.end - this.start;
    }

    public AbstractInsnNode get(int n) {
        return this.list.get(this.start + n);
    }

    public void set(int n, AbstractInsnNode abstractInsnNode) {
        this.list.set(this.get(n), abstractInsnNode);
    }

    public void remove(int n) {
        this.list.remove(this.get(n));
        --this.end;
    }

    public void replace(AbstractInsnNode abstractInsnNode, AbstractInsnNode abstractInsnNode2) {
        this.list.set(abstractInsnNode, abstractInsnNode2);
    }

    public void add(AbstractInsnNode abstractInsnNode) {
        this.list.add(abstractInsnNode);
        ++this.end;
    }

    public void insertBefore(InsnList insnList) {
        int n = insnList.size();
        if (this.list.size() == 0) {
            this.list.insert(insnList);
        } else {
            this.list.insertBefore(this.list.get(this.start), insnList);
        }
        this.start += n;
        this.end += n;
    }

    public void insert(InsnList insnList) {
        if (this.end == 0) {
            this.list.insert(insnList);
        } else {
            this.list.insert(this.list.get(this.end - 1), insnList);
        }
    }

    public void replace(InsnList insnList) {
        int n = insnList.size();
        this.remove();
        this.insert(insnList);
        this.end = this.start + n;
    }

    public void remove() {
        while (this.end != this.start) {
            this.remove(0);
        }
    }

    public void setLast(AbstractInsnNode abstractInsnNode) {
        this.end = this.list.indexOf(abstractInsnNode) + 1;
    }

    public void setFirst(AbstractInsnNode abstractInsnNode) {
        this.start = this.list.indexOf(abstractInsnNode);
    }

    public InsnListSection drop(int n) {
        return this.slice(n, this.size());
    }

    public InsnListSection take(int n) {
        return this.slice(0, n);
    }

    public InsnListSection slice(int n, int n2) {
        return new InsnListSection(this.list, this.start + n, this.start + n2);
    }

    public InsnListSection trim(Set<LabelNode> set) {
        while (this.start < this.end && !InsnComparator.insnImportant(this.getFirst(), set)) {
            ++this.start;
        }
        while (this.start < this.end && !InsnComparator.insnImportant(this.getLast(), set)) {
            --this.end;
        }
        return this;
    }

    public String toString() {
        Textifier textifier = new Textifier();
        this.accept((MethodVisitor)new TraceMethodVisitor((Printer)textifier));
        StringWriter stringWriter = new StringWriter();
        textifier.print(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public void println() {
        System.out.println(this.toString());
    }

    public HashMap<LabelNode, LabelNode> identityLabelMap() {
        HashMap<LabelNode, LabelNode> hashMap = new HashMap<LabelNode, LabelNode>();
        block7: for (AbstractInsnNode abstractInsnNode : this) {
            switch (abstractInsnNode.getType()) {
                case 8: {
                    hashMap.put((LabelNode)abstractInsnNode, (LabelNode)abstractInsnNode);
                    break;
                }
                case 7: {
                    hashMap.put(((JumpInsnNode)abstractInsnNode).label, ((JumpInsnNode)abstractInsnNode).label);
                    break;
                }
                case 12: {
                    Object object2;
                    LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)abstractInsnNode;
                    hashMap.put(lookupSwitchInsnNode.dflt, lookupSwitchInsnNode.dflt);
                    for (Object object2 : lookupSwitchInsnNode.labels) {
                        hashMap.put((LabelNode)object2, (LabelNode)object2);
                    }
                    continue block7;
                }
                case 11: {
                    TableSwitchInsnNode tableSwitchInsnNode = (TableSwitchInsnNode)abstractInsnNode;
                    hashMap.put(tableSwitchInsnNode.dflt, tableSwitchInsnNode.dflt);
                    Object object2 = tableSwitchInsnNode.labels.iterator();
                    while (object2.hasNext()) {
                        LabelNode labelNode = (LabelNode)object2.next();
                        hashMap.put(labelNode, labelNode);
                    }
                    continue block7;
                }
                case 14: {
                    Object object2 = (FrameNode)abstractInsnNode;
                    if (((FrameNode)object2).local != null) {
                        for (Object e : ((FrameNode)object2).local) {
                            if (!(e instanceof LabelNode)) continue;
                            hashMap.put((LabelNode)e, (LabelNode)e);
                        }
                    }
                    if (((FrameNode)object2).stack == null) break;
                    for (Object e : ((FrameNode)object2).stack) {
                        if (!(e instanceof LabelNode)) continue;
                        hashMap.put((LabelNode)e, (LabelNode)e);
                    }
                    break;
                }
            }
        }
        return hashMap;
    }

    public Map<LabelNode, LabelNode> cloneLabels() {
        HashMap<LabelNode, LabelNode> hashMap = this.identityLabelMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            entry.setValue(new LabelNode());
        }
        return hashMap;
    }

    public InsnListSection copy() {
        return this.copy(this.cloneLabels());
    }

    public InsnListSection copy(Map<LabelNode, LabelNode> map) {
        InsnListSection insnListSection = new InsnListSection();
        for (AbstractInsnNode abstractInsnNode : this) {
            insnListSection.add(abstractInsnNode.clone(map));
        }
        return insnListSection;
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return new InsnListSectionIterator();
    }

    private class InsnListSectionIterator
    implements Iterator<AbstractInsnNode> {
        int i = 0;

        private InsnListSectionIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < InsnListSection.this.size();
        }

        @Override
        public AbstractInsnNode next() {
            return InsnListSection.this.get(this.i++);
        }

        @Override
        public void remove() {
            InsnListSection.this.remove(--this.i);
        }
    }
}

