/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.core.RegistryEnderAttuned;
import cofh.core.RegistrySocial;
import cofh.core.command.CommandFriend;
import cofh.core.command.CommandHandler;
import cofh.core.enchantment.CoFHEnchantment;
import cofh.core.entity.DropHandler;
import cofh.core.gui.GuiHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketCore;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import cofh.core.util.ConfigHandler;
import cofh.core.util.FMLEventHandler;
import cofh.core.util.IBakeable;
import cofh.core.util.crafting.RecipeAugmentable;
import cofh.core.util.crafting.RecipeSecure;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.core.util.crafting.RecipeUpgradeOverride;
import cofh.core.util.energy.FurnaceFuelHandler;
import cofh.core.util.fluid.BucketHandler;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.core.world.FeatureParser;
import cofh.core.world.WorldHandler;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.UpdateManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="CoFHCore", name="CoFH Core", version="1.7.10R3.1.2", dependencies="required-after:Forge@[10.13.4.1448,10.14);", guiFactory="cofh.core.gui.GuiConfigCoreFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class CoFHCore
extends BaseMod {
    public static final String modId = "CoFHCore";
    public static final String modName = "CoFH Core";
    public static final String version = "1.7.10R3.1.2";
    public static final String version_max = "1.7.10R3.2.0";
    public static final String dependencies = "required-after:Forge@[10.13.4.1448,10.14);";
    public static final String modGuiFactory = "cofh.core.gui.GuiConfigCoreFactory";
    public static final String version_group = "required-after:CoFHCore@[1.7.10R3.1.2,1.7.10R3.2.0);";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/CoFHCore";
    @Mod.Instance(value="CoFHCore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.ProxyClient", serverSide="cofh.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler configCore;
    public static final ConfigHandler configLoot;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static MinecraftServer server;
    private final ArrayList<IBakeable> oven = new ArrayList();

    public static void registerBakeable(IBakeable iBakeable) {
        CoFHCore.instance.oven.add(iBakeable);
    }

    public CoFHCore() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        CoFHProps.configDir = fMLPreInitializationEvent.getModConfigurationDirectory();
        UpdateManager.registerUpdater(new UpdateManager(this, releaseURL, "http://teamcofh.com/downloads/"));
        configCore.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/client.cfg"), true));
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        proxy.preInit();
        this.moduleCore();
        this.moduleLoot();
        FeatureParser.initialize();
        WorldHandler.initialize();
        FMLEventHandler.initialize();
        BucketHandler.initialize();
        FurnaceFuelHandler.initialize();
        PacketHandler.instance.initialize();
        RecipeSorter.register((String)"cofh:augment", RecipeAugmentable.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        RecipeSorter.register((String)"cofh:secure", RecipeSecure.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"cofh:upgrade", RecipeUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        RecipeSorter.register((String)"cofh:upgradeoverride", RecipeUpgradeOverride.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        this.registerOreDictionaryEntries();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent fMLInitializationEvent) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        CommandHandler.registerSubCommand(CommandFriend.instance);
        SecurityHelper.setup();
        PacketCore.initialize();
        PacketSocial.initialize();
        RegistrySocial.initialize();
        RegistryEnderAttuned.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        OreDictionaryArbiter.initialize();
        CoFHEnchantment.postInit();
        proxy.registerKeyBinds();
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        proxy.registerPacketInformation();
        PacketHandler.instance.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        configCore.cleanUp(false, true);
        try {
            FeatureParser.parseGenerationFile();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent fMLServerAboutToStartEvent) {
        RegistryEnderAttuned.createClientRegistry();
        RegistryEnderAttuned.createServerRegistry();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent fMLServerStartingEvent) {
        OreDictionaryArbiter.initialize();
        CommandHandler.initCommands(fMLServerStartingEvent);
        server = fMLServerStartingEvent.getServer();
        for (IBakeable iBakeable : this.oven) {
            iBakeable.bake();
        }
    }

    public void handleConfigSync(PacketCoFHBase packetCoFHBase) {
        FMLEventHandler.instance.handleIdMappingEvent(null);
        RegistryEnderAttuned.createClientRegistry();
    }

    public PacketCoFHBase getConfigSync() {
        PacketCoFHBase packetCoFHBase = PacketCore.getPacket(PacketCore.PacketTypes.CONFIG_SYNC);
        return packetCoFHBase;
    }

    public void registerOreDictionaryEntries() {
        this.registerOreDictionaryEntry("blockCloth", new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        this.registerOreDictionaryEntry("coal", new ItemStack(Items.field_151044_h, 1, 0));
        this.registerOreDictionaryEntry("charcoal", new ItemStack(Items.field_151044_h, 1, 1));
    }

    private boolean registerOreDictionaryEntry(String string, ItemStack itemStack) {
        if (OreDictionary.getOres((String)string).isEmpty()) {
            OreDictionary.registerOre((String)string, (ItemStack)itemStack);
            return true;
        }
        return false;
    }

    private boolean moduleCore() {
        String string = "General";
        String string2 = "Set to TRUE to be informed of non-critical updates. You will still receive critical update notifications.";
        CoFHProps.enableUpdateNotice = configCore.get(string, "EnableUpdateNotifications", true, string2);
        string2 = "Set to TRUE for this to log when a block is dismantled.";
        CoFHProps.enableDismantleLogging = configCore.get(string, "EnableDismantleLogging", false, string2);
        string2 = "Set to TRUE to display death messages for any named entity.";
        CoFHProps.enableLivingEntityDeathMessages = configCore.get(string, "EnableGenericDeathMessage", true, string2);
        string2 = "Set to FALSE to disable items on the ground from trying to stack. This can improve server performance.";
        CoFHProps.enableItemStacking = configCore.get(string, "EnableItemStacking", true, string2);
        string = "Holiday";
        string2 = "Set this to TRUE to disable April Foolishness.";
        CoFHProps.holidayAprilFools = !configCore.get(string, "IHateApril", false, string2);
        string2 = "Set this to TRUE to disable Christmas cheer. Scrooge. :(";
        CoFHProps.holidayChristmas = !configCore.get(string, "HoHoNo", false, string2);
        string = "Security";
        string2 = "Set to TRUE to allow for Server Ops to access 'secure' blocks. Your players will be warned upon server connection.";
        CoFHProps.enableOpSecureAccess = configCore.get(string, "OpsCanAccessSecureBlocks", false, string2);
        string = "World.Tweaks";
        string2 = "Set this to a value > 1 to make trees grow more infrequently. Rate is 1 in N. Example: If this value is set to 3, trees will take 3x the time to grow, on average.";
        CoFHProps.treeGrowthChance = configCore.get(string, "TreeGrowthChance", 1, string2);
        configCore.save();
        return true;
    }

    private boolean moduleLoot() {
        configLoot.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/loot.cfg"), true));
        String string = "General";
        String string2 = "Set to false to disable this entire module.";
        boolean bl = configLoot.get(string, "EnableModule", true, string2);
        if (!bl) {
            configLoot.save();
            return false;
        }
        string = "Heads";
        string2 = "If enabled, mobs only drop heads when killed by players.";
        DropHandler.mobPvEOnly = configLoot.get(string, "MobsDropOnPvEOnly", DropHandler.mobPvEOnly, string2);
        string2 = "If enabled, players only drop heads when killed by other players.";
        DropHandler.playerPvPOnly = configLoot.get(string, "PlayersDropOnPvPOnly", DropHandler.playerPvPOnly, string2);
        string = "Heads.Players";
        DropHandler.playersEnabled = configLoot.get(string, "Enabled", DropHandler.playersEnabled);
        DropHandler.playerChance = configLoot.get(string, "Chance", DropHandler.playerChance);
        string = "Heads.Creepers";
        DropHandler.creeperEnabled = configLoot.get(string, "Enabled", DropHandler.creeperEnabled);
        DropHandler.creeperChance = configLoot.get(string, "Chance", DropHandler.creeperChance);
        string = "Heads.Skeletons";
        DropHandler.skeletonEnabled = configLoot.get(string, "Enabled", DropHandler.skeletonEnabled);
        DropHandler.skeletonChance = configLoot.get(string, "Chance", DropHandler.skeletonChance);
        string = "Heads.WitherSkeletons";
        DropHandler.skeletonEnabled = configLoot.get(string, "Enabled", DropHandler.witherSkeletonEnabled);
        DropHandler.witherSkeletonChance = configLoot.get(string, "Chance", DropHandler.witherSkeletonChance);
        string = "Heads.Zombies";
        DropHandler.zombieEnabled = configLoot.get(string, "Enabled", DropHandler.zombieEnabled);
        DropHandler.zombieChance = configLoot.get(string, "Chance", DropHandler.zombieChance);
        configLoot.save();
        MinecraftForge.EVENT_BUS.register((Object)DropHandler.instance);
        return true;
    }

    @Override
    public String getModId() {
        return modId;
    }

    @Override
    protected String getAssetDir() {
        return "cofh";
    }

    @Override
    public String getModName() {
        return modName;
    }

    @Override
    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        configCore = new ConfigHandler(version);
        configLoot = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
    }
}

