/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.items.teleportprobe.GuiTeleportProbe;

public class PacketAllReceiversReady
implements IMessage,
IMessageHandler<PacketAllReceiversReady, IMessage> {
    private List<TeleportDestinationClientInfo> destinationList;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.destinationList = new ArrayList<TeleportDestinationClientInfo>(size);
        for (int i = 0; i < size; ++i) {
            this.destinationList.add(new TeleportDestinationClientInfo(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.destinationList.size());
        for (TeleportDestination teleportDestination : this.destinationList) {
            teleportDestination.toBytes(buf);
        }
    }

    public PacketAllReceiversReady() {
    }

    public PacketAllReceiversReady(List<TeleportDestinationClientInfo> destinationList) {
        this.destinationList = new ArrayList<TeleportDestinationClientInfo>();
        this.destinationList.addAll(destinationList);
    }

    public IMessage onMessage(PacketAllReceiversReady message, MessageContext ctx) {
        GuiTeleportProbe.setReceivers(message.destinationList);
        return null;
    }
}

