/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.BlockMeta;
import mcjty.lib.varia.Logging;
import mcjty.rftools.CommonProxy;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RFToolsTools;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.crafting.KnownDimletShapedRecipe;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.dimension.description.SkyDescriptor;
import mcjty.rftools.dimension.description.WeatherDescriptor;
import mcjty.rftools.dimension.world.types.CelestialBodyType;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.dimension.world.types.EffectType;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.SkyType;
import mcjty.rftools.dimension.world.types.SpecialType;
import mcjty.rftools.dimension.world.types.StructureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.dimension.world.types.WeatherType;
import mcjty.rftools.items.dimlets.BiomeControllerMapping;
import mcjty.rftools.items.dimlets.DimletCosts;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.MobConfiguration;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class KnownDimletConfiguration {
    public static final String CATEGORY_KNOWNDIMLETS = "knowndimlets";
    public static final String CATEGORY_DIMLETSETTINGS = "dimletsettings";
    public static final String CATEGORY_RARITY = "rarity";
    public static final String CATEGORY_MOBSPAWNS = "mobspawns";
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_RECURRENTCOMPLEX = "recurrentcomplex";
    public static final Map<DimletKey, String> idToDisplayName = new HashMap<DimletKey, String>();
    public static final Map<DimletKey, DimletEntry> idToDimletEntry = new HashMap<DimletKey, DimletEntry>();
    public static final Map<DimletKey, List<String>> idToExtraInformation = new HashMap<DimletKey, List<String>>();
    public static final Set<DimletKey> craftableDimlets = new HashSet<DimletKey>();
    private static final Set<DimletKey> imcDimletBlackList = new HashSet<DimletKey>();
    private static final Set<DimletKey> dimletBlackList = new HashSet<DimletKey>();
    private static final Set<DimletKey> dimletRandomNotAllowed = new HashSet<DimletKey>();
    private static final Set<DimletKey> dimletLootNotAllowed = new HashSet<DimletKey>();
    private static final Set<Pair<DimletType, String>> bannedMods = new HashSet<Pair<DimletType, String>>();
    private static final Set<DimletKey> blacklistedKeys = new HashSet<DimletKey>();
    private static int lastId = 0;

    public static void initGeneralConfig(Configuration cfg) {
        DimletCosts.baseDimensionCreationCost = cfg.get(CATEGORY_GENERAL, "baseDimensionCreationCost", DimletCosts.baseDimensionCreationCost, "The base cost (in RF/tick) for creating a dimension").getInt();
        DimletCosts.baseDimensionMaintenanceCost = cfg.get(CATEGORY_GENERAL, "baseDimensionMaintenanceCost", DimletCosts.baseDimensionMaintenanceCost, "The base cost (in RF/tick) for maintaining a dimension").getInt();
        DimletCosts.baseDimensionTickCost = cfg.get(CATEGORY_GENERAL, "baseDimensionTickCost", DimletCosts.baseDimensionTickCost, "The base time (in ticks) for creating a dimension").getInt();
        DimletRandomizer.readRandomConfig(cfg);
        MobConfiguration.readMobConfig(cfg);
        for (DimletType type : DimletType.values()) {
            type.dimletType.setupFromConfig(cfg);
        }
    }

    private static void registerDimletEntry(int id, DimletEntry dimletEntry, DimletMapping mapping) {
        DimletKey key = dimletEntry.getKey();
        mapping.registerDimletKey(id, key);
        DimletRandomizer.dimletIds.add(key);
        idToDimletEntry.put(key, dimletEntry);
    }

    public static void blacklistDimlet(String keyName) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(keyName);
        if (key == null) {
            return;
        }
        imcDimletBlackList.add(key);
        Logging.log((String)("IMC: Blacklisted dimlet with key: '" + keyName + "'"));
    }

    public static void reconfigureDimlet(String keyName, String config) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(keyName);
        if (key == null) {
            return;
        }
        String[] splitted = StringUtils.split((String)config, (char)',');
        if (splitted.length < 4) {
            Logging.logError((String)"Bad format for configdimlet. Needs <Type>.<Name>=<CreateCost>,<MaintainCost>,<TickCost>,<Rarity>!");
            return;
        }
        try {
            int rfcreate = Integer.parseInt(splitted[0]);
            int rfmaintain = Integer.parseInt(splitted[1]);
            int ticks = Integer.parseInt(splitted[2]);
            int rarity = Integer.parseInt(splitted[3]);
            if (rarity < 0 || rarity > 6) {
                Logging.logError((String)"Rarity out of range in configdimlet!");
                return;
            }
            if (rfcreate < 0) {
                Logging.logError((String)"CreateCost out of range in configdimlet!");
                return;
            }
            if (rfmaintain < 0) {
                Logging.logError((String)"MaintainCost out of range in configdimlet!");
                return;
            }
            if (ticks < 0) {
                Logging.logError((String)"TickCost out of range in configdimlet!");
                return;
            }
            DimletCosts.dimletBuiltinRfCreate.put(key, rfcreate);
            DimletCosts.dimletBuiltinRfMaintain.put(key, rfmaintain);
            DimletCosts.dimletBuiltinTickCost.put(key, ticks);
            DimletRandomizer.dimletBuiltinRarity.put(key, rarity);
            Logging.log((String)("IMC: Reconfigured dimlet with key: '" + keyName + "' to " + config));
        }
        catch (NumberFormatException e) {
            Logging.logError((String)"Bad integers in configdimlet. Needs <Type>.<Name>=<CreateCost>,<MaintainCost>,<TickCost>,<Rarity>!");
        }
    }

    public static void preventDimletWorldGeneration(String keyName) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(keyName);
        if (key == null) {
            return;
        }
        dimletRandomNotAllowed.add(key);
        Logging.log((String)("IMC: Prevent dimlet with key key: '" + keyName + "' from being generated randomly in dimensions."));
    }

    public static void preventDimletLootGeneration(String keyName) {
        DimletKey key = KnownDimletConfiguration.getDimletKey(keyName);
        if (key == null) {
            return;
        }
        dimletLootNotAllowed.add(key);
        Logging.log((String)("IMC: Prevent dimlet with key key: '" + keyName + "' from being generated randomly in loot/chests."));
    }

    private static DimletKey getDimletKey(String keyName) {
        String[] splitted = StringUtils.split((String)keyName, (char)'.');
        if (splitted.length < 2) {
            Logging.logError((String)("Error parsing dimlet with key: '" + keyName + "'!"));
            return null;
        }
        String typeName = splitted[0];
        DimletType type = DimletType.getTypeByName(typeName);
        if (type == null) {
            Logging.logError((String)("Error parsing dimlet with key: '" + keyName + "', Unknown type '" + typeName + "'!"));
            return null;
        }
        StringBuffer name = new StringBuffer(splitted[1]);
        for (int i = 2; i < splitted.length; ++i) {
            name.append('.').append(splitted[i]);
        }
        return new DimletKey(type, name.toString());
    }

    private static boolean isBlacklistedKey(DimletKey key) {
        if (imcDimletBlackList.contains(key)) {
            return true;
        }
        if (dimletBlackList.contains(key)) {
            return true;
        }
        for (DimletKey blackKey : dimletBlackList) {
            String blackName;
            if (key.getType() != blackKey.getType() || !(blackName = blackKey.getName()).endsWith("*") || !key.getName().startsWith(blackName.substring(0, blackName.length() - 1))) continue;
            return true;
        }
        return DimletConfiguration.voidOnly && key.getType() == DimletType.DIMLET_TERRAIN && !"Void".equals(key.getName());
    }

    private static void readUserBlacklist(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(CATEGORY_KNOWNDIMLETS);
        for (Map.Entry entry : category.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith("modban.")) continue;
            String[] lst = StringUtils.split((String)name, (String)".");
            if (lst.length == 3) {
                String type = lst[1];
                String modid = lst[2];
                DimletType dt = DimletType.getTypeByName(type);
                if (dt == null) {
                    Logging.log((String)("Bad dimlet type in configuration for 'modban': " + name));
                    continue;
                }
                bannedMods.add((Pair<DimletType, String>)Pair.of((Object)((Object)dt), (Object)modid));
                Logging.log((String)("Banned dimlet type " + dt.dimletType.getName() + " for mod '" + modid + "'"));
                continue;
            }
            Logging.log((String)("Bad format in configuration for 'modban': " + name));
        }
    }

    private static boolean isBlacklistedMod(DimletType type, String modid) {
        Pair pair = Pair.of((Object)((Object)type), (Object)modid);
        return bannedMods.contains(pair);
    }

    public static boolean isBlacklisted(DimletKey key) {
        return blacklistedKeys.contains(key);
    }

    private static int registerDimlet(Configuration cfg, DimletKey key, DimletMapping mapping, boolean master, String modid, DimletEntry override) {
        Integer id = KnownDimletConfiguration.getDimletId(cfg, key, mapping, master, modid);
        if (id == -1) {
            mapping.removeKey(key);
            Logging.log((String)("Blacklisted dimlet " + key.getType().dimletType.getName() + ", " + key.getName()));
            blacklistedKeys.add(key);
            return id;
        }
        DimletEntry entry = override != null ? override : KnownDimletConfiguration.createDimletEntry(cfg, key);
        KnownDimletConfiguration.registerDimletEntry(id, entry, mapping);
        return id;
    }

    private static DimletEntry createDimletEntry(Configuration cfg, DimletKey key) {
        int rfCreateCost = KnownDimletConfiguration.checkCostConfig(cfg, "rfcreate.", key, DimletCosts.dimletBuiltinRfCreate, key.getType().dimletType.getCreationCost());
        int rfMaintainCost = KnownDimletConfiguration.checkCostConfig(cfg, "rfmaintain.", key, DimletCosts.dimletBuiltinRfMaintain, key.getType().dimletType.getMaintenanceCost());
        int tickCost = KnownDimletConfiguration.checkCostConfig(cfg, "ticks.", key, DimletCosts.dimletBuiltinTickCost, key.getType().dimletType.getTickCost());
        int rarity = KnownDimletConfiguration.checkCostConfig(cfg, "rarity.", key, DimletRandomizer.dimletBuiltinRarity, key.getType().dimletType.getRarity());
        boolean randomNotAllowed = KnownDimletConfiguration.checkFlagConfig(cfg, "expensive.", key, dimletRandomNotAllowed);
        boolean lootNotAllowed = KnownDimletConfiguration.checkFlagConfig(cfg, "noloot.", key, dimletLootNotAllowed);
        return new DimletEntry(key, rfCreateCost, rfMaintainCost, tickCost, rarity, randomNotAllowed, lootNotAllowed);
    }

    private static Integer getDimletId(Configuration cfg, DimletKey key, DimletMapping mapping, boolean master, String modid) {
        int blackid;
        String configEntry = "dimlet." + key.getType().dimletType.getName() + "." + key.getName();
        Integer id = mapping.getId(key);
        if (master && KnownDimletConfiguration.isBlacklistedKey(key)) {
            id = -1;
        } else if (master && modid != null && KnownDimletConfiguration.isBlacklistedMod(key.getType(), modid)) {
            id = -1;
        } else if (id == null) {
            if (!master) {
                id = -1;
            } else if (cfg.hasKey(CATEGORY_KNOWNDIMLETS, configEntry)) {
                id = cfg.get(CATEGORY_KNOWNDIMLETS, configEntry, -1).getInt();
            } else {
                id = lastId + 1;
                lastId = id;
            }
        } else if (master && cfg.hasKey(CATEGORY_KNOWNDIMLETS, configEntry) && (blackid = cfg.get(CATEGORY_KNOWNDIMLETS, configEntry, -1).getInt()) == -1) {
            id = -1;
        }
        return id;
    }

    private static boolean isBlacklisted(Configuration cfg, DimletKey key, DimletMapping mapping, boolean master, String modid) {
        int blackid;
        String configEntry = "dimlet." + key.getType().dimletType.getName() + "." + key.getName();
        Integer id = mapping.getId(key);
        if (master && KnownDimletConfiguration.isBlacklistedKey(key)) {
            return true;
        }
        if (master && modid != null && KnownDimletConfiguration.isBlacklistedMod(key.getType(), modid)) {
            return true;
        }
        if (id == null) {
            if (!master) {
                return true;
            }
            if (cfg.hasKey(CATEGORY_KNOWNDIMLETS, configEntry)) {
                id = cfg.get(CATEGORY_KNOWNDIMLETS, configEntry, -1).getInt();
                return id == -1;
            }
            return false;
        }
        if (master && cfg.hasKey(CATEGORY_KNOWNDIMLETS, configEntry) && (blackid = cfg.get(CATEGORY_KNOWNDIMLETS, configEntry, -1).getInt()) == -1) {
            return true;
        }
        return id == -1;
    }

    private static boolean checkFlagConfig(Configuration cfg, String prefix, DimletKey key, Set<DimletKey> builtinDefaults) {
        String k = prefix + key.getType().dimletType.getName() + "." + key.getName();
        boolean defaultValue = builtinDefaults.contains(key);
        if (cfg.getCategory(CATEGORY_DIMLETSETTINGS).containsKey(k)) {
            return cfg.get(CATEGORY_DIMLETSETTINGS, k, defaultValue).getBoolean();
        }
        return defaultValue;
    }

    private static int checkCostConfig(Configuration cfg, String prefix, DimletKey key, Map<DimletKey, Integer> builtinDefaults, int defCost) {
        String k = prefix + key.getType().dimletType.getName() + "." + key.getName();
        Integer defaultValue = builtinDefaults.get(key);
        if (defaultValue == null) {
            defaultValue = defCost;
        }
        int cost = defaultValue.equals(defCost) && !cfg.getCategory(CATEGORY_DIMLETSETTINGS).containsKey(k) ? defaultValue.intValue() : cfg.get(CATEGORY_DIMLETSETTINGS, k, defaultValue.intValue()).getInt();
        return cost;
    }

    public static void clean() {
        lastId = 0;
        idToDisplayName.clear();
        idToDimletEntry.clear();
        craftableDimlets.clear();
        dimletBlackList.clear();
        dimletRandomNotAllowed.clear();
        dimletLootNotAllowed.clear();
        DimletObjectMapping.clean();
        DimletRandomizer.clean();
    }

    private static void addExtraInformation(DimletKey key, String ... info) {
        ArrayList extraInfo = new ArrayList();
        Collections.addAll(extraInfo, info);
        idToExtraInformation.put(key, extraInfo);
    }

    public static boolean isInitialized() {
        return DimletMapping.isInitialized();
    }

    public static void init(World world, boolean master) {
        File modConfigDir = CommonProxy.modConfigDir;
        Configuration cfg = new Configuration(new File(modConfigDir.getPath() + File.separator + "rftools", "dimlets.cfg"));
        cfg.addCustomCategoryComment(CATEGORY_KNOWNDIMLETS, "Dimlet configuration");
        cfg.addCustomCategoryComment(CATEGORY_DIMLETSETTINGS, "Settings for specific dimlets");
        cfg.load();
        KnownDimletConfiguration.init(world, cfg, master);
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private static void init(World world, Configuration cfg, boolean master) {
        KnownDimletConfiguration.clean();
        DimletMapping mapping = DimletMapping.getDimletMapping(world);
        File modConfigDir = CommonProxy.modConfigDir;
        KnownDimletConfiguration.readDimletsJson();
        if (master) {
            KnownDimletConfiguration.readUserBlacklist(cfg);
        }
        KnownDimletConfiguration.updateLastId(cfg, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Default", ControllerType.CONTROLLER_DEFAULT, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Single", ControllerType.CONTROLLER_SINGLE, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Checkerboard", ControllerType.CONTROLLER_CHECKERBOARD, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Cold", ControllerType.CONTROLLER_COLD, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Medium", ControllerType.CONTROLLER_MEDIUM, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Warm", ControllerType.CONTROLLER_WARM, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Dry", ControllerType.CONTROLLER_DRY, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Wet", ControllerType.CONTROLLER_WET, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Fields", ControllerType.CONTROLLER_FIELDS, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Mountains", ControllerType.CONTROLLER_MOUNTAINS, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Filtered", ControllerType.CONTROLLER_FILTERED, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Magical", ControllerType.CONTROLLER_MAGICAL, mapping, master);
        KnownDimletConfiguration.initControllerItem(cfg, "Forest", ControllerType.CONTROLLER_FOREST, mapping, master);
        BiomeControllerMapping.setupControllerBiomes();
        DimletKey keyControllerDefault = new DimletKey(DimletType.DIMLET_CONTROLLER, "Default");
        KnownDimletConfiguration.addExtraInformation(keyControllerDefault, "The Default controller just uses the same", "biome distribution as the overworld");
        KnownDimletConfiguration.initDigitItem(cfg, 0, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 1, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 2, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 3, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 4, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 5, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 6, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 7, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 8, mapping, master);
        KnownDimletConfiguration.initDigitItem(cfg, 9, mapping, master);
        DimletKey keyMaterialNone = new DimletKey(DimletType.DIMLET_MATERIAL, "None");
        KnownDimletConfiguration.registerDimlet(cfg, keyMaterialNone, mapping, master, null, null);
        idToDisplayName.put(keyMaterialNone, DimletType.DIMLET_MATERIAL.dimletType.getName() + " Default Dimlet");
        DimletObjectMapping.idToBlock.put(keyMaterialNone, null);
        KnownDimletConfiguration.addExtraInformation(keyMaterialNone, "Use this material default dimlet to get normal", "biome specific stone generation");
        KnownDimletConfiguration.initMaterialDimlets(cfg, mapping, master);
        KnownDimletConfiguration.initFoliageItem(cfg, mapping, master);
        DimletKey keyLiquidNone = new DimletKey(DimletType.DIMLET_LIQUID, "None");
        KnownDimletConfiguration.registerDimlet(cfg, keyLiquidNone, mapping, master, null, null);
        DimletObjectMapping.idToFluid.put(keyLiquidNone, null);
        idToDisplayName.put(keyLiquidNone, DimletType.DIMLET_LIQUID.dimletType.getName() + " Default Dimlet");
        KnownDimletConfiguration.addExtraInformation(keyLiquidNone, "Use this liquid default dimlet to get normal", "water generation");
        KnownDimletConfiguration.initSpecialItem(cfg, "Peaceful", SpecialType.SPECIAL_PEACEFUL, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Peaceful"), "Normal mob spawning is disabled", "if you use this dimlet");
        KnownDimletConfiguration.initSpecialItem(cfg, "Efficiency", SpecialType.SPECIAL_EFFICIENCY, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Efficiency"), "Reduce the maintenance RF/tick of the", "generated dimension with 20%", "This is cumulative");
        KnownDimletConfiguration.initSpecialItem(cfg, "Mediocre Efficiency", SpecialType.SPECIAL_EFFICIENCY_LOW, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Mediocre Efficiency"), "Reduce the maintenance RF/tick of the", "generated dimension with 5%", "This is cumulative");
        KnownDimletConfiguration.initSpecialItem(cfg, "Shelter", SpecialType.SPECIAL_SHELTER, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Shelter"), "Generate a better sheltered spawn", "platform in the dimension");
        KnownDimletConfiguration.initSpecialItem(cfg, "Seed", SpecialType.SPECIAL_SEED, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Seed"), "Force a specific seed for a dimension.", "Right click in dimension to store seed.", "Shift-right click to lock seed");
        KnownDimletConfiguration.initSpecialItem(cfg, "Spawn", SpecialType.SPECIAL_SPAWN, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Spawn"), "With this dimlet you can force", "respawning in the rftools dimension", "(unless power is low).");
        KnownDimletConfiguration.initSpecialItem(cfg, "No Animals", SpecialType.SPECIAL_NOANIMALS, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "No Animals"), "Animal spawning is disabled", "if you use this dimlet");
        if (DimletConfiguration.ownerDimletsNeeded) {
            KnownDimletConfiguration.initSpecialItem(cfg, "Owner", SpecialType.SPECIAL_OWNER, mapping, master);
            KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_SPECIAL, "Owner"), "You need this dimlet to create", "a dimension tab");
        }
        KnownDimletConfiguration.initMobItem(cfg, "Default", mapping, master);
        for (Map.Entry<String, MobDescriptor> entry : MobConfiguration.mobClasses.entrySet()) {
            String name;
            Class<? extends EntityLiving> entityClass = entry.getValue().getEntityClass();
            if (entityClass == null || (name = entry.getKey()) == null || name.isEmpty()) continue;
            KnownDimletConfiguration.initMobItem(cfg, name, mapping, master);
        }
        DimletKey keyDefaultMobs = new DimletKey(DimletType.DIMLET_MOBS, "Default");
        KnownDimletConfiguration.addExtraInformation(keyDefaultMobs, "With this default dimlet you will just get", "the default mob spawning");
        KnownDimletConfiguration.initSkyItem(cfg, "Normal", new SkyDescriptor.Builder().skyType(SkyType.SKY_NORMAL).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Normal Day", new SkyDescriptor.Builder().sunBrightnessFactor(1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Bright Day", new SkyDescriptor.Builder().sunBrightnessFactor(1.5f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Day", new SkyDescriptor.Builder().sunBrightnessFactor(0.4f).skyColorFactor(0.6f, 0.6f, 0.6f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Normal Night", new SkyDescriptor.Builder().starBrightnessFactor(1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Bright Night", new SkyDescriptor.Builder().starBrightnessFactor(1.5f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Night", new SkyDescriptor.Builder().starBrightnessFactor(0.4f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Red Color", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.2f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Red Color", new SkyDescriptor.Builder().skyColorFactor(0.6f, 0.0f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Green Color", new SkyDescriptor.Builder().skyColorFactor(0.2f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Green Color", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.6f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Blue Color", new SkyDescriptor.Builder().skyColorFactor(0.2f, 0.2f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Blue Color", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.0f, 0.6f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Yellow Color", new SkyDescriptor.Builder().skyColorFactor(1.0f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Cyan Color", new SkyDescriptor.Builder().skyColorFactor(0.2f, 1.0f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Cyan Color", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.6f, 0.6f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Purple Color", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.2f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Dark Purple Color", new SkyDescriptor.Builder().skyColorFactor(0.6f, 0.0f, 0.6f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Black Color", new SkyDescriptor.Builder().skyColorFactor(0.0f, 0.0f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Gold Color", new SkyDescriptor.Builder().skyColorFactor(1.0f, 0.6f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Normal Fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 1.0f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Black Fog", new SkyDescriptor.Builder().fogColorFactor(0.0f, 0.0f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Red Fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 0.2f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Green Fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Blue Fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 0.2f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Yellow Fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Cyan Fog", new SkyDescriptor.Builder().fogColorFactor(0.2f, 1.0f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Purple Fog", new SkyDescriptor.Builder().fogColorFactor(1.0f, 0.2f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Ender", new SkyDescriptor.Builder().skyType(SkyType.SKY_ENDER).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Inferno", new SkyDescriptor.Builder().skyType(SkyType.SKY_INFERNO).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Stars1", new SkyDescriptor.Builder().skyType(SkyType.SKY_STARS1).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Stars2", new SkyDescriptor.Builder().skyType(SkyType.SKY_STARS2).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body None", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_NONE).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SUN).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Large Sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGESUN).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Small Sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SMALLSUN).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Red Sun", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_REDSUN).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_MOON).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Large Moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGEMOON).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Small Moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_SMALLMOON).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Red Moon", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_REDMOON).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Planet", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_PLANET).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Body Large Planet", new SkyDescriptor.Builder().addBody(CelestialBodyType.BODY_LARGEPLANET).build(), true, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Normal Clouds", new SkyDescriptor.Builder().resetCloudColor().build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Black Clouds", new SkyDescriptor.Builder().cloudColorFactor(0.0f, 0.0f, 0.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Red Clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 0.2f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Green Clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Blue Clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 0.2f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Yellow Clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 1.0f, 0.2f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Cyan Clouds", new SkyDescriptor.Builder().cloudColorFactor(0.2f, 1.0f, 1.0f).build(), false, mapping, master);
        KnownDimletConfiguration.initSkyItem(cfg, "Purple Clouds", new SkyDescriptor.Builder().cloudColorFactor(1.0f, 0.2f, 1.0f).build(), false, mapping, master);
        DimletKey keySkyNormal = new DimletKey(DimletType.DIMLET_SKY, "Normal");
        DimletKey keySkyNormalDay = new DimletKey(DimletType.DIMLET_SKY, "Normal Day");
        DimletKey keySkyNormalNight = new DimletKey(DimletType.DIMLET_SKY, "Normal Night");
        KnownDimletConfiguration.addExtraInformation(keySkyNormal, "A normal type of sky", "(as opposed to ender or inferno)");
        KnownDimletConfiguration.addExtraInformation(keySkyNormalDay, "Normal brightness level for daytime sky");
        KnownDimletConfiguration.addExtraInformation(keySkyNormalNight, "Normal brightness level for nighttime sky");
        KnownDimletConfiguration.initWeatherItem(cfg, "Default", new WeatherDescriptor.Builder().build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "No Rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_NORAIN).build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "Light Rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_LIGHTRAIN).build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "Hard Rain", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_HARDRAIN).build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "No Thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_NOTHUNDER).build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "Light Thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_LIGHTTHUNDER).build(), mapping, master);
        KnownDimletConfiguration.initWeatherItem(cfg, "Hard Thunder", new WeatherDescriptor.Builder().weatherType(WeatherType.WEATHER_HARDTHUNDER).build(), mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_WEATHER, "Default"), "Normal default weather");
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_NONE.getName(), StructureType.STRUCTURE_NONE, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_VILLAGE.getName(), StructureType.STRUCTURE_VILLAGE, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_STRONGHOLD.getName(), StructureType.STRUCTURE_STRONGHOLD, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_DUNGEON.getName(), StructureType.STRUCTURE_DUNGEON, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_FORTRESS.getName(), StructureType.STRUCTURE_FORTRESS, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_MINESHAFT.getName(), StructureType.STRUCTURE_MINESHAFT, mapping, master);
        KnownDimletConfiguration.initStructureItem(cfg, StructureType.STRUCTURE_SCATTERED.getName(), StructureType.STRUCTURE_SCATTERED, mapping, master);
        DimletKey keyStructureNone = new DimletKey(DimletType.DIMLET_STRUCTURE, "None");
        KnownDimletConfiguration.addExtraInformation(keyStructureNone, "With this none dimlet you can disable", "all normal structure spawning");
        KnownDimletConfiguration.initRecurrentComplexStructures(cfg, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Void", TerrainType.TERRAIN_VOID, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Flat", TerrainType.TERRAIN_FLAT, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Amplified", TerrainType.TERRAIN_AMPLIFIED, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Normal", TerrainType.TERRAIN_NORMAL, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Cavern", TerrainType.TERRAIN_CAVERN, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Island", TerrainType.TERRAIN_ISLAND, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Islands", TerrainType.TERRAIN_ISLANDS, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Chaotic", TerrainType.TERRAIN_CHAOTIC, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Plateaus", TerrainType.TERRAIN_PLATEAUS, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Grid", TerrainType.TERRAIN_GRID, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Low Cavern", TerrainType.TERRAIN_LOW_CAVERN, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Flooded Cavern", TerrainType.TERRAIN_FLOODED_CAVERN, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Nearlands", TerrainType.TERRAIN_NEARLANDS, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Liquid", TerrainType.TERRAIN_LIQUID, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Solid", TerrainType.TERRAIN_SOLID, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Waves", TerrainType.TERRAIN_WAVES, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Filled Waves", TerrainType.TERRAIN_FILLEDWAVES, mapping, master);
        KnownDimletConfiguration.initTerrainItem(cfg, "Rough", TerrainType.TERRAIN_ROUGH, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "None", FeatureType.FEATURE_NONE, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Caves", FeatureType.FEATURE_CAVES, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Ravines", FeatureType.FEATURE_RAVINES, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Orbs", FeatureType.FEATURE_ORBS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Oregen", FeatureType.FEATURE_OREGEN, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Lakes", FeatureType.FEATURE_LAKES, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Tendrils", FeatureType.FEATURE_TENDRILS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Canyons", FeatureType.FEATURE_CANYONS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Maze", FeatureType.FEATURE_MAZE, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Liquid Orbs", FeatureType.FEATURE_LIQUIDORBS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Shallow Ocean", FeatureType.FEATURE_SHALLOW_OCEAN, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Volcanoes", FeatureType.FEATURE_VOLCANOES, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Huge Orbs", FeatureType.FEATURE_HUGEORBS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Huge Liquid Orbs", FeatureType.FEATURE_HUGELIQUIDORBS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "No Dimlet Buildings", FeatureType.FEATURE_NODIMLETBUILDINGS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Pyramids", FeatureType.FEATURE_PYRAMIDS, mapping, master);
        KnownDimletConfiguration.initFeatureItem(cfg, "Clean", FeatureType.FEATURE_CLEAN, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_FEATURE, "None"), "With this none dimlet you can disable", "all special features");
        KnownDimletConfiguration.initEffectItem(cfg, "None", EffectType.EFFECT_NONE, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Poison", EffectType.EFFECT_POISON, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Poison II", EffectType.EFFECT_POISON2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Poison III", EffectType.EFFECT_POISON3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Regeneration", EffectType.EFFECT_REGENERATION, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Regeneration II", EffectType.EFFECT_REGENERATION2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Regeneration III", EffectType.EFFECT_REGENERATION3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Slowness", EffectType.EFFECT_MOVESLOWDOWN, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Slowness II", EffectType.EFFECT_MOVESLOWDOWN2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Slowness III", EffectType.EFFECT_MOVESLOWDOWN3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Slowness IV", EffectType.EFFECT_MOVESLOWDOWN4, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Speed", EffectType.EFFECT_MOVESPEED, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Speed II", EffectType.EFFECT_MOVESPEED2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Speed III", EffectType.EFFECT_MOVESPEED3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Mining Fatigue", EffectType.EFFECT_DIGSLOWDOWN, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Mining Fatigue II", EffectType.EFFECT_DIGSLOWDOWN2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Mining Fatigue III", EffectType.EFFECT_DIGSLOWDOWN3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Mining Fatigue IV", EffectType.EFFECT_DIGSLOWDOWN4, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Haste", EffectType.EFFECT_DIGSPEED, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Haste II", EffectType.EFFECT_DIGSPEED2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Haste III", EffectType.EFFECT_DIGSPEED3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Damage Boost", EffectType.EFFECT_DAMAGEBOOST, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Damage Boost II", EffectType.EFFECT_DAMAGEBOOST2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Damage Boost III", EffectType.EFFECT_DAMAGEBOOST3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Instant Health", EffectType.EFFECT_INSTANTHEALTH, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Harm", EffectType.EFFECT_HARM, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Jump", EffectType.EFFECT_JUMP, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Jump II", EffectType.EFFECT_JUMP2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Jump III", EffectType.EFFECT_JUMP3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Confusion", EffectType.EFFECT_CONFUSION, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Resistance", EffectType.EFFECT_RESISTANCE, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Resistance II", EffectType.EFFECT_RESISTANCE2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Resistance III", EffectType.EFFECT_RESISTANCE3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Fire Resistance", EffectType.EFFECT_FIRERESISTANCE, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Water Breathing", EffectType.EFFECT_WATERBREATHING, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Invisibility", EffectType.EFFECT_INVISIBILITY, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Blindness", EffectType.EFFECT_BLINDNESS, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Nightvision", EffectType.EFFECT_NIGHTVISION, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Hunger", EffectType.EFFECT_HUNGER, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Hunger II", EffectType.EFFECT_HUNGER2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Hunger III", EffectType.EFFECT_HUNGER3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Weakness", EffectType.EFFECT_WEAKNESS, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Weakness II", EffectType.EFFECT_WEAKNESS2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Weakness III", EffectType.EFFECT_WEAKNESS3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Wither", EffectType.EFFECT_WITHER, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Wither II", EffectType.EFFECT_WITHER2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Wither III", EffectType.EFFECT_WITHER3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Health Boost", EffectType.EFFECT_HEALTHBOOST, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Health Boost II", EffectType.EFFECT_HEALTHBOOST2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Health Boost III", EffectType.EFFECT_HEALTHBOOST3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Absorption", EffectType.EFFECT_ABSORPTION, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Absorption II", EffectType.EFFECT_ABSORPTION2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Absorption III", EffectType.EFFECT_ABSORPTION3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Saturation", EffectType.EFFECT_SATURATION, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Saturation II", EffectType.EFFECT_SATURATION2, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Saturation III", EffectType.EFFECT_SATURATION3, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Flight", EffectType.EFFECT_FLIGHT, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Strong Mobs", EffectType.EFFECT_STRONGMOBS, mapping, master);
        KnownDimletConfiguration.initEffectItem(cfg, "Brutal Mobs", EffectType.EFFECT_BRUTALMOBS, mapping, master);
        KnownDimletConfiguration.addExtraInformation(new DimletKey(DimletType.DIMLET_EFFECT, "None"), "With this none dimlet you can disable", "all special effects");
        KnownDimletConfiguration.initTimeItem(cfg, "Normal", null, null, mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Noon", Float.valueOf(0.0f), null, mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Midnight", Float.valueOf(0.5f), null, mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Morning", Float.valueOf(0.75f), null, mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Evening", Float.valueOf(0.2f), null, mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Fast", null, Float.valueOf(2.0f), mapping, master);
        KnownDimletConfiguration.initTimeItem(cfg, "Slow", null, Float.valueOf(0.5f), mapping, master);
        DimletKey keyTimeNormal = new DimletKey(DimletType.DIMLET_TIME, "Normal");
        KnownDimletConfiguration.addExtraInformation(keyTimeNormal, "With this normal dimlet you will get", "default day/night timing");
        KnownDimletConfiguration.initBiomeItems(cfg, mapping, master);
        KnownDimletConfiguration.initLiquidItems(cfg, mapping, master);
        KnownDimletConfiguration.initPatreonItem(cfg, "McJty", mapping, master, "McJty's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "SickHippie", mapping, master, "SickHippie's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "Lockesly", mapping, master, "Lockesly's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "Nissenfeld", mapping, master, "Nissenfeld's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "Puppeteer", mapping, master, "Puppeteer's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "Rouven", mapping, master, "Rouven's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "FireBall", mapping, master, "FireBall's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "DarkCorvuz", mapping, master, "DarkCorvuz's Support Dimlet");
        KnownDimletConfiguration.initPatreonItem(cfg, "TomWolf", mapping, master, "TomWolf's Support Dimlet");
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_WEATHER, "Default"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_EFFECT, "None"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_FEATURE, "None"));
        craftableDimlets.add(keyStructureNone);
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_TERRAIN, "Void"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_TERRAIN, "Flat"));
        craftableDimlets.add(keyControllerDefault);
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_CONTROLLER, "Single"));
        craftableDimlets.add(keyMaterialNone);
        craftableDimlets.add(keyLiquidNone);
        craftableDimlets.add(keySkyNormal);
        craftableDimlets.add(keySkyNormalDay);
        craftableDimlets.add(keySkyNormalNight);
        craftableDimlets.add(keyDefaultMobs);
        craftableDimlets.add(keyTimeNormal);
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "0"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "1"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "2"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "3"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "4"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "5"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "6"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "7"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "8"));
        craftableDimlets.add(new DimletKey(DimletType.DIMLET_DIGIT, "9"));
        KnownDimletConfiguration.readUserDimlets(cfg, modConfigDir, mapping, master);
        DimletRandomizer.setupWeightedRandomList();
        mapping.save(world);
    }

    private static void initMaterialDimlets(Configuration cfg, DimletMapping mapping, boolean master) {
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150484_ah, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150482_ag, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150475_bE, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150412_bA, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150371_ca, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150449_bY, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150340_R, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150352_o, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150339_S, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150366_p, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150365_q, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150368_y, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150369_x, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150402_ci, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150451_bX, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150450_ax, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150346_d, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150322_A, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150377_bs, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150424_aL, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150347_e, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150343_Z, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150425_aM, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150359_w, 0, mapping, master, null);
        for (int i = 0; i < 16; ++i) {
            KnownDimletConfiguration.initMaterialItem(cfg, (Block)Blocks.field_150399_cn, i, mapping, master, null);
            KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150406_ce, i, mapping, master, null);
        }
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150426_aN, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150341_Y, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150432_aD, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150403_cj, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150435_aG, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, Blocks.field_150405_ch, 0, mapping, master, null);
        KnownDimletConfiguration.initMaterialItem(cfg, DimletSetup.dimensionalShardBlock, 0, mapping, master, null);
        KnownDimletConfiguration.initOreDictionaryDimlets(cfg, mapping, master);
        KnownDimletConfiguration.initModMaterialItem(cfg, "chisel", "marble", 0, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "chisel", "limestone", 0, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.nether", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.bloodstained", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.infernal", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.infernal", 5, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.abyssal", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.sandy", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.quarried", 2, mapping, master, false);
        KnownDimletConfiguration.initModMaterialItem(cfg, "Railcraft", "tile.railcraft.brick.frostbound", 2, mapping, master, false);
    }

    private static void initOreDictionaryDimlets(Configuration cfg, DimletMapping mapping, boolean master) {
        for (String oreName : OreDictionary.getOreNames()) {
            Integer id;
            DimletKey key;
            int rfMaintain = -10000;
            int rfCreate = -10000;
            int ticks = -10000;
            int rarity = -10000;
            boolean blackListed = false;
            boolean noloot = false;
            boolean noworldgen = false;
            ArrayList stacks = OreDictionary.getOres((String)oreName);
            if (stacks.isEmpty() || !oreName.startsWith("ore")) continue;
            ItemStack itemStack = null;
            for (ItemStack stack : stacks) {
                DimletEntry entry;
                DimletKey key2;
                if (stack.func_77978_p() != null || (key2 = KnownDimletConfiguration.getMaterialDimletKey(stack)) == null) continue;
                if (itemStack == null) {
                    itemStack = stack;
                }
                if ((entry = KnownDimletConfiguration.createDimletEntry(cfg, key2)).getRarity() > rarity) {
                    rarity = entry.getRarity();
                }
                if (entry.getBaseRfMaintainCost() > rfMaintain) {
                    rfMaintain = entry.getBaseRfMaintainCost();
                }
                if (entry.getRfCreateCost() > rfCreate) {
                    rfCreate = entry.getRfCreateCost();
                }
                if (entry.getTickCost() > ticks) {
                    ticks = entry.getTickCost();
                }
                if (entry.isLootNotAllowed()) {
                    noloot = true;
                }
                if (entry.isRandomNotAllowed()) {
                    noworldgen = true;
                }
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                String modid = RFToolsTools.getModidForBlock(itemBlock.field_150939_a);
                if (!master || !KnownDimletConfiguration.isBlacklisted(cfg, key2, mapping, master, modid)) continue;
                blackListed = true;
            }
            if (itemStack == null || blackListed || (key = KnownDimletConfiguration.getMaterialDimletKey(itemStack)) == null || (id = mapping.getId(key)) != null && idToDimletEntry.containsKey(key)) continue;
            DimletEntry combinedEntry = new DimletEntry(key, rfCreate, rfMaintain, ticks, rarity, noworldgen, noloot);
            ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
            KnownDimletConfiguration.initMaterialItem(cfg, itemBlock.field_150939_a, itemStack.func_77960_j(), mapping, master, combinedEntry);
        }
    }

    private static DimletKey getMaterialDimletKey(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Block block = itemBlock.field_150939_a;
            int meta = itemStack.func_77960_j();
            return KnownDimletConfiguration.getMaterialDimletKey(block, meta);
        }
        return null;
    }

    private static DimletKey getMaterialDimletKey(Block block, int meta) {
        DimletKey key;
        String unlocalizedName = block.func_149739_a();
        if (unlocalizedName != null && !unlocalizedName.isEmpty()) {
            if (meta != 0) {
                unlocalizedName = unlocalizedName + meta;
            }
            key = new DimletKey(DimletType.DIMLET_MATERIAL, unlocalizedName);
        } else {
            key = null;
        }
        return key;
    }

    private static void initDigitCrafting(String from, String to, World world) {
        DimletKey keyFrom = new DimletKey(DimletType.DIMLET_DIGIT, from);
        DimletKey keyTo = new DimletKey(DimletType.DIMLET_DIGIT, to);
        GameRegistry.addRecipe((ItemStack)KnownDimletConfiguration.makeKnownDimlet(keyTo, world), (Object[])new Object[]{"   ", " 9 ", "   ", Character.valueOf('9'), KnownDimletConfiguration.makeKnownDimlet(keyFrom, world)});
    }

    public static void initCrafting(World world) {
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < recipeList.size(); ++i) {
            if (recipeList.get(i) instanceof ShapedRecipes) {
                ShapedRecipes r = (ShapedRecipes)recipeList.get(i);
                if (r.func_77571_b().func_77973_b() != DimletSetup.knownDimlet || r.field_77574_d[4].func_77973_b() != DimletSetup.knownDimlet) continue;
                recipeList.remove(i);
                --i;
                continue;
            }
            if (!(recipeList.get(i) instanceof KnownDimletShapedRecipe)) continue;
            recipeList.remove(i);
            --i;
        }
        KnownDimletConfiguration.initDigitCrafting("0", "1", world);
        KnownDimletConfiguration.initDigitCrafting("1", "2", world);
        KnownDimletConfiguration.initDigitCrafting("2", "3", world);
        KnownDimletConfiguration.initDigitCrafting("3", "4", world);
        KnownDimletConfiguration.initDigitCrafting("4", "5", world);
        KnownDimletConfiguration.initDigitCrafting("5", "6", world);
        KnownDimletConfiguration.initDigitCrafting("6", "7", world);
        KnownDimletConfiguration.initDigitCrafting("7", "8", world);
        KnownDimletConfiguration.initDigitCrafting("8", "9", world);
        KnownDimletConfiguration.initDigitCrafting("9", "0", world);
        Object redstoneTorch = Item.field_150901_e.func_82594_a("redstone_torch");
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_EFFECT, "None"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151034_e, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_FEATURE, "None"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151007_F, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_STRUCTURE, "None"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151103_aS, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_TERRAIN, "Void"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151118_aC, Character.valueOf('p'), Items.field_151121_aF));
        if (!DimletConfiguration.voidOnly) {
            GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_TERRAIN, "Flat"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151118_aC, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        }
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_CONTROLLER, "Default"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151132_bS, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_CONTROLLER, "Single"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151132_bS, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_MATERIAL, "None"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Blocks.field_150346_d, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_LIQUID, "None"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151133_ar, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_SKY, "Normal"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151008_G, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_SKY, "Normal Day"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151114_aO, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_SKY, "Normal Night"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151044_h, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_MOBS, "Default"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151078_bh, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_TIME, "Normal"), new Object[]{" r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151113_aN, Character.valueOf('p'), DimletSetup.dimletTemplate}));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_WEATHER, "Default"), " r ", "rwr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Items.field_151126_ay, Character.valueOf('p'), Items.field_151121_aF));
        GameRegistry.addRecipe((IRecipe)new KnownDimletShapedRecipe(new DimletKey(DimletType.DIMLET_DIGIT, "0"), " r ", "rtr", "ppp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), redstoneTorch, Character.valueOf('p'), Items.field_151121_aF));
    }

    private static int initModMaterialItem(Configuration cfg, String modid, String blockname, int meta, DimletMapping mapping, boolean master, boolean warn) {
        Block block = GameRegistry.findBlock((String)modid, (String)blockname);
        if (block != null) {
            return KnownDimletConfiguration.initMaterialItem(cfg, block, meta, mapping, master, null);
        }
        if (warn) {
            Logging.log((String)("Warning Custom dimlet: Could not find block '" + blockname + "' from mod '" + modid + "'!"));
        }
        return -1;
    }

    private static void updateLastId(Configuration cfg, DimletMapping mapping, boolean master) {
        lastId = 0;
        if (master) {
            ConfigCategory category = cfg.getCategory(CATEGORY_KNOWNDIMLETS);
            for (Map.Entry entry : category.entrySet()) {
                Integer id;
                String key = (String)entry.getKey();
                if (!key.startsWith("dimlet.") || (id = Integer.valueOf(((Property)entry.getValue()).getInt())) == -1 || id <= lastId) continue;
                lastId = id;
            }
        }
        for (Integer id : mapping.getIds()) {
            if (id <= lastId) continue;
            lastId = id;
        }
    }

    private static int initDigitItem(Configuration cfg, int digit, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_DIGIT, "" + digit);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_DIGIT.dimletType.getName() + " " + digit + " Dimlet");
            DimletObjectMapping.idToDigit.put(key, String.valueOf(digit));
        }
        return id;
    }

    private static int initMaterialItem(Configuration cfg, Block block, int meta, DimletMapping mapping, boolean master, DimletEntry override) {
        DimletKey key = KnownDimletConfiguration.getMaterialDimletKey(block, meta);
        if (key == null) {
            return -1;
        }
        String modid = RFToolsTools.getModidForBlock(block);
        ItemStack stack = new ItemStack(block, 1, meta);
        if (stack.func_77973_b() == null) {
            return -1;
        }
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, modid, override);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_MATERIAL.dimletType.getName() + " " + stack.func_82833_r() + " Dimlet");
            DimletObjectMapping.idToBlock.put(key, new BlockMeta(block, (byte)meta));
        }
        return id;
    }

    private static void readUserDimlets(Configuration cfg, File modConfigDir, DimletMapping mapping, boolean master) {
        try {
            File file = new File(modConfigDir.getPath() + File.separator + "rftools", "userdimlets.json");
            FileInputStream inputstream = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputstream, "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            for (JsonElement entry : element.getAsJsonArray()) {
                JsonArray array = entry.getAsJsonArray();
                String type = array.get(0).getAsString();
                if (!"material".equals(type)) continue;
                String modid = array.get(1).getAsString();
                String name = array.get(2).getAsString();
                Integer meta = array.get(3).getAsInt();
                KnownDimletConfiguration.initModMaterialItem(cfg, modid, name, meta, mapping, master, true);
            }
        }
        catch (IOException e) {
            Logging.log((String)"Could not read 'userdimlets.json', this is not an error!");
        }
    }

    private static void readDimletsJson() {
        try {
            InputStream inputstream = RFTools.class.getResourceAsStream("/assets/rftools/text/dimlets.json");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                if ("blacklist".equals(entry.getKey())) {
                    KnownDimletConfiguration.readBlacklistFromJson((JsonElement)entry.getValue());
                    continue;
                }
                if (!"dimlets".equals(entry.getKey())) continue;
                KnownDimletConfiguration.readDimletsFromJson((JsonElement)entry.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readBlacklistFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String typeName = entry.getAsJsonArray().get(0).getAsString();
            String name = entry.getAsJsonArray().get(1).getAsString();
            DimletType type = DimletType.getTypeByName(typeName);
            if (type == null) {
                Logging.logError((String)("Error in dimlets.json! Unknown type '" + typeName + "'!"));
                return;
            }
            dimletBlackList.add(new DimletKey(type, name));
        }
    }

    private static void readDimletsFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            JsonArray array = entry.getAsJsonArray();
            String typeName = array.get(0).getAsString();
            String name = array.get(1).getAsString();
            Integer rfcreate = array.get(2).getAsInt();
            Integer rfmaintain = array.get(3).getAsInt();
            Integer tickCost = array.get(4).getAsInt();
            Integer rarity = array.get(5).getAsInt();
            Integer expensive = array.get(6).getAsInt();
            Integer noloot = array.get(7).getAsInt();
            DimletType type = DimletType.getTypeByName(typeName);
            if (type == null) {
                Logging.logError((String)("Error in dimlets.json! Unknown type '" + typeName + "'!"));
                return;
            }
            DimletKey key = new DimletKey(type, name);
            if (!DimletCosts.dimletBuiltinRfCreate.containsKey(key)) {
                DimletCosts.dimletBuiltinRfCreate.put(key, rfcreate);
            }
            if (!DimletCosts.dimletBuiltinRfMaintain.containsKey(key)) {
                DimletCosts.dimletBuiltinRfMaintain.put(key, rfmaintain);
            }
            if (!DimletCosts.dimletBuiltinTickCost.containsKey(key)) {
                DimletCosts.dimletBuiltinTickCost.put(key, tickCost);
            }
            if (!DimletRandomizer.dimletBuiltinRarity.containsKey(key)) {
                DimletRandomizer.dimletBuiltinRarity.put(key, rarity);
            }
            if (expensive != 0) {
                dimletRandomNotAllowed.add(key);
            }
            if (noloot == 0) continue;
            dimletLootNotAllowed.add(key);
        }
    }

    public static void setupChestLoot() {
        KnownDimletConfiguration.setupChestLoot("dungeonChest");
        KnownDimletConfiguration.setupChestLoot("mineshaftCorridor");
        KnownDimletConfiguration.setupChestLoot("pyramidDesertyChest");
        KnownDimletConfiguration.setupChestLoot("pyramidJungleChest");
        KnownDimletConfiguration.setupChestLoot("strongholdCorridor");
        KnownDimletConfiguration.setupChestLoot("villageBlacksmith");
    }

    private static void setupChestLoot(String category) {
        if (DimletConfiguration.unknownDimletChestLootRarity > 0) {
            ChestGenHooks chest = ChestGenHooks.getInfo((String)category);
            chest.addItem(new WeightedRandomChestContent((Item)DimletSetup.unknownDimlet, 0, DimletConfiguration.unknownDimletChestLootMinimum, DimletConfiguration.unknownDimletChestLootMaximum, DimletConfiguration.unknownDimletChestLootRarity));
        }
    }

    private static int initControllerItem(Configuration cfg, String name, ControllerType type, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_CONTROLLER, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToControllerType.put(key, type);
            idToDisplayName.put(key, DimletType.DIMLET_CONTROLLER.dimletType.getName() + " " + name + " Dimlet");
        }
        return -1;
    }

    private static void initBiomeItems(Configuration cfg, DimletMapping mapping, boolean master) {
        BiomeGenBase[] biomeGenArray;
        for (BiomeGenBase biome : biomeGenArray = BiomeGenBase.func_150565_n()) {
            DimletKey key;
            int id;
            String name;
            if (biome == null || (name = biome.field_76791_y) == null || name.isEmpty() || (id = KnownDimletConfiguration.registerDimlet(cfg, key = new DimletKey(DimletType.DIMLET_BIOME, name), mapping, master, null, null)) == -1) continue;
            DimletObjectMapping.idToBiome.put(key, biome);
            idToDisplayName.put(key, DimletType.DIMLET_BIOME.dimletType.getName() + " " + name + " Dimlet");
        }
    }

    private static void initFoliageItem(Configuration cfg, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_FOLIAGE, "Oak");
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, "Foliage Oak Dimlet");
        }
    }

    private static void initLiquidItems(Configuration cfg, DimletMapping mapping, boolean master) {
        Map fluidMap = FluidRegistry.getRegisteredFluids();
        for (Map.Entry me : fluidMap.entrySet()) {
            String name;
            if (!((Fluid)me.getValue()).canBePlacedInWorld() || (name = (String)me.getKey()) == null || name.isEmpty()) continue;
            try {
                Block block = ((Fluid)me.getValue()).getBlock();
                if (block == null) continue;
                String modid = RFToolsTools.getModidForBlock(block);
                String displayName = new FluidStack((Fluid)me.getValue(), 1).getLocalizedName();
                DimletKey key = new DimletKey(DimletType.DIMLET_LIQUID, name);
                int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, modid, null);
                if (id == -1) continue;
                DimletObjectMapping.idToFluid.put(key, ((Fluid)me.getValue()).getBlock());
                idToDisplayName.put(key, DimletType.DIMLET_LIQUID.dimletType.getName() + " " + displayName + " Dimlet");
            }
            catch (Exception e) {
                Logging.logError((String)"Something went wrong getting the name of a fluid:");
                Logging.logError((String)("Fluid: " + name + ", unlocalizedName: " + ((Fluid)me.getValue()).getUnlocalizedName()));
            }
        }
    }

    private static int initSpecialItem(Configuration cfg, String name, SpecialType specialType, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_SPECIAL, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_SPECIAL.dimletType.getName() + " " + name + " Dimlet");
            DimletObjectMapping.idToSpecialType.put(key, specialType);
        }
        return id;
    }

    private static int initMobItem(Configuration cfg, String name, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_MOBS, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_MOBS.dimletType.getName() + " " + name + " Dimlet");
            DimletObjectMapping.idtoMob.put(key, MobConfiguration.mobClasses.get(name));
        }
        return id;
    }

    private static int initPatreonItem(Configuration cfg, String name, DimletMapping mapping, boolean master, String ... extraInformation) {
        DimletKey key = new DimletKey(DimletType.DIMLET_PATREON, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_PATREON.dimletType.getName() + " " + name + " Dimlet");
            KnownDimletConfiguration.addExtraInformation(key, extraInformation);
        }
        return id;
    }

    private static int initSkyItem(Configuration cfg, String name, SkyDescriptor skyDescriptor, boolean isbody, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_SKY, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToSkyDescriptor.put(key, skyDescriptor);
            idToDisplayName.put(key, DimletType.DIMLET_SKY.dimletType.getName() + " " + name + " Dimlet");
            if (isbody) {
                DimletObjectMapping.celestialBodies.add(key);
            }
        }
        return id;
    }

    private static int initWeatherItem(Configuration cfg, String name, WeatherDescriptor weatherDescriptor, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_WEATHER, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToWeatherDescriptor.put(key, weatherDescriptor);
            idToDisplayName.put(key, DimletType.DIMLET_WEATHER.dimletType.getName() + " " + name + " Dimlet");
        }
        return id;
    }

    private static void initRecurrentComplexStructures(Configuration cfg, DimletMapping mapping, boolean master) {
        ConfigCategory category = cfg.getCategory(CATEGORY_RECURRENTCOMPLEX);
        for (Map.Entry entry : category.entrySet()) {
            String[] strings;
            int id;
            if (!((String)entry.getKey()).startsWith("recurrentcomplex.") || (id = KnownDimletConfiguration.initStructureItem(cfg, (strings = StringUtils.split((String)((String)entry.getKey()), (String)"."))[1], StructureType.STRUCTURE_RECURRENTCOMPLEX, mapping, master)) == -1) continue;
            DimletObjectMapping.idToRecurrentComplexType.put(new DimletKey(DimletType.DIMLET_STRUCTURE, strings[1]), ((Property)entry.getValue()).getString());
        }
    }

    private static int initStructureItem(Configuration cfg, String name, StructureType structureType, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_STRUCTURE, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToStructureType.put(key, structureType);
            idToDisplayName.put(key, DimletType.DIMLET_STRUCTURE.dimletType.getName() + " " + name + " Dimlet");
        }
        return id;
    }

    private static int initTerrainItem(Configuration cfg, String name, TerrainType terrainType, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_TERRAIN, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToTerrainType.put(key, terrainType);
            idToDisplayName.put(key, DimletType.DIMLET_TERRAIN.dimletType.getName() + " " + name + " Dimlet");
        }
        return id;
    }

    private static int initEffectItem(Configuration cfg, String name, EffectType effectType, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_EFFECT, "" + name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            idToDisplayName.put(key, DimletType.DIMLET_EFFECT.dimletType.getName() + " " + name + " Dimlet");
            DimletObjectMapping.idToEffectType.put(key, effectType);
        }
        return id;
    }

    private static int initFeatureItem(Configuration cfg, String name, FeatureType featureType, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_FEATURE, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToFeatureType.put(key, featureType);
            idToDisplayName.put(key, DimletType.DIMLET_FEATURE.dimletType.getName() + " " + name + " Dimlet");
        }
        return id;
    }

    private static int initTimeItem(Configuration cfg, String name, Float angle, Float speed, DimletMapping mapping, boolean master) {
        DimletKey key = new DimletKey(DimletType.DIMLET_TIME, name);
        int id = KnownDimletConfiguration.registerDimlet(cfg, key, mapping, master, null, null);
        if (id != -1) {
            DimletObjectMapping.idToCelestialAngle.put(key, angle);
            DimletObjectMapping.idToSpeed.put(key, speed);
            idToDisplayName.put(key, DimletType.DIMLET_TIME.dimletType.getName() + " " + name + " Dimlet");
        }
        return id;
    }

    public static DimletEntry getEntry(DimletKey key) {
        return idToDimletEntry.get(key);
    }

    public static boolean isNewKnownDimlet(ItemStack dimletStack) {
        NBTTagCompound tagCompound = dimletStack.func_77978_p();
        return tagCompound != null && tagCompound.func_74764_b("dkey");
    }

    public static DimletKey getDimletKey(ItemStack dimletStack, World world) {
        NBTTagCompound tagCompound = dimletStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("dkey")) {
            DimletType type = DimletType.getTypeByOpcode(tagCompound.func_74779_i("ktype"));
            return new DimletKey(type, tagCompound.func_74779_i("dkey"));
        }
        int damage = dimletStack.func_77960_j();
        DimletMapping mapping = world == null ? DimletMapping.getInstance() : DimletMapping.getDimletMapping(world);
        return mapping.getKey(damage);
    }

    public static void setDimletKey(DimletKey key, ItemStack itemStack) {
        Integer id;
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("ktype", key.getType().dimletType.getOpcode());
        tagCompound.func_74778_a("dkey", key.getName());
        itemStack.func_77982_d(tagCompound);
        DimletMapping mapping = DimletMapping.getInstance();
        if (mapping != null && (id = mapping.getId(key)) != null) {
            itemStack.func_77964_b(id.intValue());
        }
    }

    public static ItemStack makeKnownDimlet(DimletKey key, World world) {
        DimletMapping mapping = world == null ? DimletMapping.getInstance() : DimletMapping.getDimletMapping(world);
        int id = mapping.getId(key);
        ItemStack itemStack = new ItemStack((Item)DimletSetup.knownDimlet, 1, id);
        KnownDimletConfiguration.setDimletKey(key, itemStack);
        return itemStack;
    }
}

