/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.dimlets.DimletType;

public enum FeatureType {
    FEATURE_NONE(null, null, 0, 0),
    FEATURE_CAVES(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CAVERN_OLD, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_RAVINES(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CAVERN_OLD, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_ORBS(null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 1, 0),
    FEATURE_OREGEN(null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 0, 0),
    FEATURE_LAKES(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CAVERN_OLD, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), new MMap(-1, new DimletType[]{DimletType.DIMLET_LIQUID}), 0, 0),
    FEATURE_TENDRILS(null, new MMap(1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_CANYONS(null, new MMap(1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_MAZE(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_NEARLANDS}), null, 0, 0),
    FEATURE_LIQUIDORBS(null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL, DimletType.DIMLET_LIQUID}), 1, 1),
    FEATURE_SHALLOW_OCEAN(new TSet(new TerrainType[]{TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_CHAOTIC}), new MMap(1, new DimletType[]{DimletType.DIMLET_LIQUID}), 0, 3),
    FEATURE_VOLCANOES(null, null, 0, 0),
    FEATURE_DENSE_CAVES(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CAVERN_OLD, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), null, 0, 0),
    FEATURE_HUGEORBS(null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 2, 0),
    FEATURE_HUGELIQUIDORBS(null, new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL, DimletType.DIMLET_LIQUID}), 1, 2),
    FEATURE_NODIMLETBUILDINGS(null, null, 0, 0),
    FEATURE_PYRAMIDS(new TSet(new TerrainType[]{TerrainType.TERRAIN_AMPLIFIED, TerrainType.TERRAIN_CAVERN, TerrainType.TERRAIN_CAVERN_OLD, TerrainType.TERRAIN_FLOODED_CAVERN, TerrainType.TERRAIN_FLAT, TerrainType.TERRAIN_CHAOTIC, TerrainType.TERRAIN_ISLAND, TerrainType.TERRAIN_ISLANDS, TerrainType.TERRAIN_LOW_CAVERN, TerrainType.TERRAIN_NEARLANDS, TerrainType.TERRAIN_NORMAL, TerrainType.TERRAIN_PLATEAUS, TerrainType.TERRAIN_SOLID, TerrainType.TERRAIN_WAVES, TerrainType.TERRAIN_FILLEDWAVES, TerrainType.TERRAIN_ROUGH}), new MMap(-1, new DimletType[]{DimletType.DIMLET_MATERIAL}), 1, 0),
    FEATURE_CLEAN(null, null, 0, 0);

    private final Set<TerrainType> supportedTerrains;
    private final Map<DimletType, Integer> supportedModifiers;
    private final int materialClass;
    private final int liquidClass;

    private FeatureType(Set<TerrainType> terrainTypes, Map<DimletType, Integer> modifiers, int materialClass, int liquidClass) {
        this.supportedTerrains = terrainTypes == null ? Collections.emptySet() : new HashSet<TerrainType>(terrainTypes);
        this.supportedModifiers = modifiers == null ? Collections.emptyMap() : new HashMap<DimletType, Integer>(modifiers);
        this.materialClass = materialClass;
        this.liquidClass = liquidClass;
    }

    public boolean isTerrainSupported(TerrainType type) {
        return this.supportedTerrains.isEmpty() || this.supportedTerrains.contains((Object)type);
    }

    public boolean supportsAllTerrains() {
        return this.supportedTerrains.isEmpty();
    }

    public int getMaterialClass() {
        return this.materialClass;
    }

    public int getLiquidClass() {
        return this.liquidClass;
    }

    public Integer getSupportedModifierAmount(DimletType type) {
        return this.supportedModifiers.get((Object)type);
    }

    private static class MMap
    extends HashMap<DimletType, Integer> {
        private MMap(int amount, DimletType ... dimletTypes) {
            for (DimletType type : dimletTypes) {
                this.put(type, amount);
            }
        }
    }

    private static class TSet
    extends HashSet<TerrainType> {
        private TSet(TerrainType ... terrainTypes) {
            for (TerrainType type : terrainTypes) {
                this.add(type);
            }
        }
    }
}

