/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.dimension.DamageSourcePowerLow;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.dimension.world.types.EffectType;
import mcjty.rftools.items.dimlets.types.Patreons;
import mcjty.rftools.playerprops.BuffProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DimensionTickEvent {
    public static final int MAXTICKS = 10;
    private int counter = 10;
    private static final int EFFECTS_MAX = 18;
    private int counterEffects = 18;
    private static Random random = new Random();
    private static int t = 0;
    private static int[] colors = new int[]{0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0xFFFFFF, 0xFF5555, 0x55FF55, 0x5555FF, 0xFFFF55, 0xFF55FF, 0x55FFFF, 0x555555};
    static final Map<EffectType, Integer> effectsMap = new HashMap<EffectType, Integer>();
    static final Map<EffectType, Integer> effectAmplifierMap = new HashMap<EffectType, Integer>();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            return;
        }
        --this.counter;
        if (this.counter <= 0) {
            this.counter = 10;
            --this.counterEffects;
            boolean doEffects = false;
            if (this.counterEffects <= 0) {
                this.counterEffects = 18;
                doEffects = true;
            }
            this.serverTick(doEffects);
        }
    }

    private void serverTick(boolean doEffects) {
        World entityWorld = MinecraftServer.func_71276_C().func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(entityWorld);
        if (!dimensionManager.getDimensions().isEmpty()) {
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(entityWorld);
            for (Map.Entry<Integer, DimensionDescriptor> entry : dimensionManager.getDimensions().entrySet()) {
                Integer id = entry.getKey();
                DimensionInformation information = dimensionManager.getDimensionInformation(id);
                WorldServer world = DimensionManager.getWorld((int)id);
                if (world != null || information.getProbeCounter() == 0) {
                    this.handlePower(doEffects, dimensionStorage, entry, id, information);
                }
                if (world == null || world.field_73010_i.isEmpty()) continue;
                this.handleRandomEffects(world, information);
            }
            dimensionStorage.save(entityWorld);
        }
    }

    private void handlePower(boolean doEffects, DimensionStorage dimensionStorage, Map.Entry<Integer, DimensionDescriptor> entry, Integer id, DimensionInformation information) {
        int cost = 0;
        if (DimletConfiguration.dimensionDifficulty != -1 && (cost = information.getActualRfCost()) == 0) {
            cost = entry.getValue().getRfMaintainCost();
        }
        int power = dimensionStorage.getEnergyLevel(id);
        if ((power -= cost * 10) < 0) {
            power = 0;
        }
        this.handleLowPower(id, power, doEffects, cost);
        if (doEffects && power > 0) {
            this.handleEffectsForDimension(power, id, information);
        }
        dimensionStorage.setEnergyLevel(id, power);
    }

    private void handleRandomEffects(WorldServer world, DimensionInformation information) {
        if (information.isPatreonBitSet(Patreons.PATREON_FIREWORKS)) {
            this.handleFireworks(world);
        }
        if (information.isPatreonBitSet(Patreons.PATREON_TOMWOLF)) {
            this.handleHowlingWolf(world, information);
        }
    }

    private void handleHowlingWolf(WorldServer world, DimensionInformation information) {
        if (information.getCelestialAngle() == null) {
            float a = world.func_72826_c(1.0f);
            if (--t <= 0) {
                t = 0;
            }
            if (Math.abs(a - 0.5f) < 0.05f && t <= 0) {
                this.playHowl(world);
                t = 40;
            }
        } else if ((double)random.nextFloat() < 0.001) {
            this.playHowl(world);
        }
    }

    private void playHowl(WorldServer world) {
        for (Object playerEntity : world.field_73010_i) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "rftools:wolfhowl", 1.0f, 1.0f);
        }
    }

    private void handleFireworks(WorldServer world) {
        if ((double)random.nextFloat() < 0.05) {
            double minPosX = 1.0E9;
            double minPosZ = 1.0E9;
            double maxPosX = -1.0E9;
            double maxPosZ = -1.0E9;
            for (Object playerEntity : world.field_73010_i) {
                EntityPlayer player = (EntityPlayer)playerEntity;
                if (player.field_70165_t > maxPosX) {
                    maxPosX = player.field_70165_t;
                }
                if (player.field_70165_t < minPosX) {
                    minPosX = player.field_70165_t;
                }
                if (player.field_70161_v > maxPosZ) {
                    maxPosZ = player.field_70161_v;
                }
                if (!(player.field_70161_v < minPosZ)) continue;
                minPosZ = player.field_70161_v;
            }
            double posX = (double)random.nextFloat() * (maxPosX - minPosX + 60.0) + minPosX - 30.0;
            double posZ = (double)random.nextFloat() * (maxPosZ - minPosZ + 60.0) + minPosZ - 30.0;
            ItemStack fireworkStack = new ItemStack(Items.field_151152_bP);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound fireworks = new NBTTagCompound();
            fireworks.func_74774_a("Flight", (byte)2);
            NBTTagList explosions = new NBTTagList();
            explosions.func_74742_a((NBTBase)this.makeExplosion(tag));
            fireworks.func_74782_a("Explosions", (NBTBase)explosions);
            tag.func_74782_a("Fireworks", (NBTBase)fireworks);
            fireworkStack.func_77982_d(tag);
            int y = world.func_72825_h((int)posX, (int)posZ);
            y = y == -1 ? 64 : (y += 3);
            EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket((World)world, posX, (double)y, posZ, fireworkStack);
            world.func_72838_d((Entity)entityfireworkrocket);
        }
    }

    private NBTTagCompound makeExplosion(NBTTagCompound tag) {
        NBTTagCompound explosion = new NBTTagCompound();
        explosion.func_74757_a("Flicker", true);
        explosion.func_74757_a("Tail", true);
        explosion.func_74774_a("Type", (byte)(random.nextInt(4) + 1));
        explosion.func_74783_a("Colors", new int[]{colors[random.nextInt(colors.length)], colors[random.nextInt(colors.length)], colors[random.nextInt(colors.length)]});
        tag.func_74782_a("Explosion", (NBTBase)explosion);
        return explosion;
    }

    private void handleEffectsForDimension(int power, int id, DimensionInformation information) {
        WorldServer world = DimensionManager.getWorld((int)id);
        if (world != null) {
            Set<EffectType> effects = information.getEffectTypes();
            ArrayList players = new ArrayList(world.field_73010_i);
            for (EntityPlayer player : players) {
                for (EffectType effect : effects) {
                    Integer potionEffect = effectsMap.get((Object)effect);
                    if (potionEffect != null) {
                        Integer amplifier = effectAmplifierMap.get((Object)effect);
                        if (amplifier == null) {
                            amplifier = 0;
                        }
                        player.func_70690_d(new PotionEffect(potionEffect.intValue(), 540, amplifier.intValue(), true));
                        continue;
                    }
                    if (effect != EffectType.EFFECT_FLIGHT) continue;
                    BuffProperties.addBuff(player, PlayerBuff.BUFF_FLIGHT, 360);
                }
                if (power < DimletConfiguration.DIMPOWER_WARN3) {
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 180, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 180, 2, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                    continue;
                }
                if (power < DimletConfiguration.DIMPOWER_WARN2) {
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 2, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 180, 2, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 1, true));
                    continue;
                }
                if (power >= DimletConfiguration.DIMPOWER_WARN1) continue;
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 0, true));
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 180, 0, true));
            }
        }
    }

    private void handleLowPower(Integer id, int power, boolean doEffects, int phasedCost) {
        block7: {
            WorldServer world;
            if (power > 0 || (world = DimensionManager.getWorld((int)id)) == null) break block7;
            ArrayList players = new ArrayList(world.field_73010_i);
            if (DimletConfiguration.dimensionDifficulty >= 1) {
                for (EntityPlayer player : players) {
                    if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, true, phasedCost)) {
                        player.func_70097_a((DamageSource)new DamageSourcePowerLow("powerLow"), 1000000.0f);
                        continue;
                    }
                    if (!doEffects || !DimletConfiguration.phasedFieldGeneratorDebuf) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 180, 2, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                }
            } else {
                Random random = new Random();
                for (EntityPlayer player : players) {
                    if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, true, phasedCost)) {
                        int z;
                        int x;
                        WorldServer worldServerForDimension = MinecraftServer.func_71276_C().func_71218_a(DimletConfiguration.spawnDimension);
                        int y = worldServerForDimension.func_72825_h(x = random.nextInt(2000) - 1000, z = random.nextInt(2000) - 1000);
                        if (y == -1) {
                            y = 63;
                        }
                        TeleportationTools.teleportToDimension(player, DimletConfiguration.spawnDimension, x, y, z);
                        continue;
                    }
                    if (!doEffects) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 180, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 180, 4, true));
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.func_76396_c(), 180, 2, true));
                }
            }
        }
    }

    static {
        effectsMap.put(EffectType.EFFECT_POISON, Potion.field_76436_u.func_76396_c());
        effectsMap.put(EffectType.EFFECT_POISON2, Potion.field_76436_u.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_POISON2, 1);
        effectsMap.put(EffectType.EFFECT_POISON3, Potion.field_76436_u.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_POISON3, 2);
        effectsMap.put(EffectType.EFFECT_REGENERATION, Potion.field_76428_l.func_76396_c());
        effectsMap.put(EffectType.EFFECT_REGENERATION2, Potion.field_76428_l.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_REGENERATION2, 1);
        effectsMap.put(EffectType.EFFECT_REGENERATION3, Potion.field_76428_l.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_REGENERATION3, 2);
        effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN, Potion.field_76421_d.func_76396_c());
        effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN2, Potion.field_76421_d.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN2, 1);
        effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN3, Potion.field_76421_d.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN3, 2);
        effectsMap.put(EffectType.EFFECT_MOVESLOWDOWN4, Potion.field_76421_d.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_MOVESLOWDOWN4, 3);
        effectsMap.put(EffectType.EFFECT_MOVESPEED, Potion.field_76424_c.func_76396_c());
        effectsMap.put(EffectType.EFFECT_MOVESPEED2, Potion.field_76424_c.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_MOVESPEED2, 1);
        effectsMap.put(EffectType.EFFECT_MOVESPEED3, Potion.field_76424_c.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_MOVESPEED3, 2);
        effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN, Potion.field_76419_f.func_76396_c());
        effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN2, Potion.field_76419_f.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN2, 1);
        effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN3, Potion.field_76419_f.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN3, 2);
        effectsMap.put(EffectType.EFFECT_DIGSLOWDOWN4, Potion.field_76419_f.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DIGSLOWDOWN4, 3);
        effectsMap.put(EffectType.EFFECT_DIGSPEED, Potion.field_76422_e.func_76396_c());
        effectsMap.put(EffectType.EFFECT_DIGSPEED2, Potion.field_76422_e.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DIGSPEED2, 1);
        effectsMap.put(EffectType.EFFECT_DIGSPEED3, Potion.field_76422_e.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DIGSPEED3, 2);
        effectsMap.put(EffectType.EFFECT_DAMAGEBOOST, Potion.field_76420_g.func_76396_c());
        effectsMap.put(EffectType.EFFECT_DAMAGEBOOST2, Potion.field_76420_g.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DAMAGEBOOST2, 1);
        effectsMap.put(EffectType.EFFECT_DAMAGEBOOST3, Potion.field_76420_g.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_DAMAGEBOOST3, 2);
        effectsMap.put(EffectType.EFFECT_INSTANTHEALTH, Potion.field_76432_h.func_76396_c());
        effectsMap.put(EffectType.EFFECT_HARM, Potion.field_76433_i.func_76396_c());
        effectsMap.put(EffectType.EFFECT_JUMP, Potion.field_76430_j.func_76396_c());
        effectsMap.put(EffectType.EFFECT_JUMP2, Potion.field_76430_j.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_JUMP2, 1);
        effectsMap.put(EffectType.EFFECT_JUMP3, Potion.field_76430_j.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_JUMP3, 2);
        effectsMap.put(EffectType.EFFECT_CONFUSION, Potion.field_76431_k.func_76396_c());
        effectsMap.put(EffectType.EFFECT_RESISTANCE, Potion.field_76429_m.func_76396_c());
        effectsMap.put(EffectType.EFFECT_RESISTANCE2, Potion.field_76429_m.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_RESISTANCE2, 1);
        effectsMap.put(EffectType.EFFECT_RESISTANCE3, Potion.field_76429_m.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_RESISTANCE3, 2);
        effectsMap.put(EffectType.EFFECT_FIRERESISTANCE, Potion.field_76426_n.func_76396_c());
        effectsMap.put(EffectType.EFFECT_WATERBREATHING, Potion.field_76427_o.func_76396_c());
        effectsMap.put(EffectType.EFFECT_INVISIBILITY, Potion.field_76441_p.func_76396_c());
        effectsMap.put(EffectType.EFFECT_BLINDNESS, Potion.field_76440_q.func_76396_c());
        effectsMap.put(EffectType.EFFECT_NIGHTVISION, Potion.field_76439_r.func_76396_c());
        effectsMap.put(EffectType.EFFECT_HUNGER, Potion.field_76438_s.func_76396_c());
        effectsMap.put(EffectType.EFFECT_HUNGER2, Potion.field_76438_s.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_HUNGER2, 1);
        effectsMap.put(EffectType.EFFECT_HUNGER3, Potion.field_76438_s.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_HUNGER3, 2);
        effectsMap.put(EffectType.EFFECT_WEAKNESS, Potion.field_76437_t.func_76396_c());
        effectsMap.put(EffectType.EFFECT_WEAKNESS2, Potion.field_76437_t.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_WEAKNESS2, 1);
        effectsMap.put(EffectType.EFFECT_WEAKNESS3, Potion.field_76437_t.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_WEAKNESS3, 2);
        effectsMap.put(EffectType.EFFECT_WITHER, Potion.field_82731_v.func_76396_c());
        effectsMap.put(EffectType.EFFECT_WITHER2, Potion.field_82731_v.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_WITHER2, 1);
        effectsMap.put(EffectType.EFFECT_WITHER3, Potion.field_82731_v.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_WITHER3, 2);
        effectsMap.put(EffectType.EFFECT_HEALTHBOOST, Potion.field_76434_w.func_76396_c());
        effectsMap.put(EffectType.EFFECT_HEALTHBOOST2, Potion.field_76434_w.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_HEALTHBOOST2, 1);
        effectsMap.put(EffectType.EFFECT_HEALTHBOOST3, Potion.field_76434_w.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_HEALTHBOOST3, 2);
        effectsMap.put(EffectType.EFFECT_ABSORPTION, Potion.field_76444_x.func_76396_c());
        effectsMap.put(EffectType.EFFECT_ABSORPTION2, Potion.field_76444_x.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_ABSORPTION2, 1);
        effectsMap.put(EffectType.EFFECT_ABSORPTION3, Potion.field_76444_x.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_ABSORPTION3, 2);
        effectsMap.put(EffectType.EFFECT_SATURATION, Potion.field_76443_y.func_76396_c());
        effectsMap.put(EffectType.EFFECT_SATURATION2, Potion.field_76443_y.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_SATURATION2, 1);
        effectsMap.put(EffectType.EFFECT_SATURATION3, Potion.field_76443_y.func_76396_c());
        effectAmplifierMap.put(EffectType.EFFECT_SATURATION3, 2);
    }
}

