/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdSetOwner
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<id> <owner>";
    }

    @Override
    public String getCommand() {
        return "setowner";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension and player parameters are missing!"));
            return;
        }
        if (args.length > 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        String playerName = this.fetchString(sender, args, 2, null);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)o;
            if (!playerName.equals(entityPlayerMP.getDisplayName())) continue;
            DimensionInformation information = dimensionManager.getDimensionInformation(dim);
            information.setOwner(playerName, entityPlayerMP.func_146103_bH().getId());
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Owner of dimension changed!"));
            dimensionManager.save(world);
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not find player!"));
    }
}

