/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.items.storage.StorageTypeItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ModularStorageContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_STORAGE_MODULE = 0;
    public static final int SLOT_TYPE_MODULE = 1;
    public static final int SLOT_FILTER_MODULE = 2;
    public static final int SLOT_STORAGE = 3;
    public static final int MAXSIZE_STORAGE = 300;
    private ModularStorageTileEntity modularStorageTileEntity;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModularStorageSetup.storageModuleItem)}), ModularStorageContainer.CONTAINER_INVENTORY, 0, 5, 157, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageTypeItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 1, 5, 175, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, StorageFilterItem.class), ModularStorageContainer.CONTAINER_INVENTORY, 2, 5, 193, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), ModularStorageContainer.CONTAINER_INVENTORY, 3, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
        }
    };

    public ModularStorageContainer(EntityPlayer player, ModularStorageTileEntity containerInventory) {
        super(factory);
        this.modularStorageTileEntity = containerInventory;
        this.addInventory(CONTAINER_INVENTORY, (IInventory)containerInventory);
        this.addInventory("player", (IInventory)player.field_71071_by);
        this.generateSlots();
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            Object slot;
            if (slotFactory.getSlotType() == SlotType.SLOT_SPECIFICITEM) {
                final SlotDefinition slotDefinition = slotFactory.getSlotDefinition();
                slot = new Slot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75214_a(ItemStack stack) {
                        return slotDefinition.itemStackMatches(stack);
                    }
                };
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV || slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75216_d() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.func_75216_d();
                    }

                    public ItemStack func_75211_c() {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return null;
                        }
                        return super.func_75211_c();
                    }

                    public boolean func_82869_a(EntityPlayer player) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        return super.func_82869_a(player);
                    }

                    public boolean func_75214_a(ItemStack stack) {
                        if (this.getSlotIndex() >= ModularStorageContainer.this.modularStorageTileEntity.getMaxSize() + 3) {
                            return false;
                        }
                        if (!ModularStorageContainer.this.modularStorageTileEntity.func_94041_b(this.getSlotIndex(), stack)) {
                            return false;
                        }
                        return super.func_75214_a(stack);
                    }
                };
            }
            this.func_75146_a((Slot)slot);
        }
    }

    public ItemStack func_75144_a(int index, int button, int mode, EntityPlayer player) {
        if (index == 0 && !player.field_70170_p.field_72995_K) {
            this.modularStorageTileEntity.copyToModule();
        }
        return super.func_75144_a(index, button, mode, player);
    }
}

