/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberControllerTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class SpaceChamberControllerBlock
extends GenericRFToolsBlock {
    public SpaceChamberControllerBlock() {
        super(Material.field_151573_f, SpaceChamberControllerTileEntity.class, true);
        this.func_149663_c("spaceChamberControllerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            list.add(EnumChatFormatting.GREEN + "Channel: " + channel);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block is one of the eight corners of an");
            list.add(EnumChatFormatting.WHITE + "area of space you want to copy/move elsewhere");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof SpaceChamberControllerTileEntity) {
            SpaceChamberControllerTileEntity spaceChamberControllerTileEntity = (SpaceChamberControllerTileEntity)te;
            int channel = spaceChamberControllerTileEntity.getChannel();
            currenttip.add(EnumChatFormatting.GREEN + "Channel: " + channel);
            if (channel != -1) {
                int size = spaceChamberControllerTileEntity.getChamberSize();
                if (size == -1) {
                    currenttip.add(EnumChatFormatting.YELLOW + "Chamber not formed!");
                } else {
                    currenttip.add(EnumChatFormatting.GREEN + "Area: " + size + " blocks");
                }
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return -1;
    }

    protected boolean wrenchUse(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
        } else {
            SpaceChamberControllerTileEntity chamberControllerTileEntity = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
            chamberControllerTileEntity.createChamber(player);
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (!world.field_72995_K) {
            SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(world);
            SpaceChamberControllerTileEntity te = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
            if (te.getChannel() == -1) {
                int id = chamberRepository.newChannel();
                te.setChannel(id);
                chamberRepository.save(world);
            }
            this.func_149695_a(world, x, y, z, (Block)this);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!world.field_72995_K) {
            SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(world);
            SpaceChamberControllerTileEntity te = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
            if (te.getChannel() != -1) {
                chamberRepository.deleteChannel(te.getChannel());
                chamberRepository.save(world);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineSpaceChamberController");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.iconSide;
    }
}

