/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiRelay
extends GenericGuiContainer<RelayTileEntity> {
    public static final int RELAY_WIDTH = 255;
    public static final int RELAY_HEIGHT = 130;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private Map<String, ImageChoiceLabel> inputOutputs = new HashMap<String, ImageChoiceLabel>();
    private Map<String, TextField> energyValues = new HashMap<String, TextField>();

    public GuiRelay(RelayTileEntity relayTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)relayTileEntity, container, RFTools.GUI_MANUAL_MAIN, "prelay");
        this.field_146999_f = 255;
        this.field_147000_g = 130;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout());
        toplevel.addChild((Widget)this.createRedstonePanel());
        for (int i = 0; i < 6; ++i) {
            toplevel.addChild((Widget)this.createSidePanel(i));
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 255, 130));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private Panel createRedstonePanel() {
        ImageLabel redstoneOff = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 16, 0);
        redstoneOff.setDesiredWidth(16).setDesiredHeight(16).setTooltips(new String[]{"Redstone signal off"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(70, 0, 16, 16));
        ImageLabel redstoneOn = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 32, 0);
        redstoneOn.setDesiredWidth(16).setDesiredHeight(16).setTooltips(new String[]{"Redstone signal on"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(190, 0, 16, 16));
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)redstoneOff)).addChild((Widget)redstoneOn);
        return panel;
    }

    private Panel createSidePanel(int side) {
        String labelText = String.valueOf("DUNSWE".charAt(side));
        Label label = new Label(this.field_146297_k, (Gui)this).setText(labelText);
        label.setDesiredWidth(14).setDesiredHeight(14);
        Panel panel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(1)).addChild((Widget)label)).addChild((Widget)this.createSubPanel(side, "Off").setDesiredWidth(115))).addChild((Widget)this.createSubPanel(side, "On").setDesiredWidth(115));
        return panel;
    }

    private Panel createSubPanel(int side, String redstoneState) {
        boolean input;
        int rf;
        String labelText = String.valueOf("DUNSWE".charAt(side));
        if ("Off".equals(redstoneState)) {
            rf = ((RelayTileEntity)this.tileEntity).getRfOff(side);
            input = ((RelayTileEntity)this.tileEntity).isInputModeOff(side);
        } else {
            rf = ((RelayTileEntity)this.tileEntity).getRfOn(side);
            input = ((RelayTileEntity)this.tileEntity).isInputModeOn(side);
        }
        ImageChoiceLabel inputOutput = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(14)).setDesiredHeight(14)).addChoice("Output", "Side set to output mode", iconGuiElements, 80, 16).addChoice("Input", "Side set to input mode", iconGuiElements, 96, 16).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiRelay.this.changeSettings();
            }
        });
        String key = labelText + redstoneState;
        if (input) {
            inputOutput.setCurrentChoice("Input");
        } else {
            inputOutput.setCurrentChoice("Output");
        }
        this.inputOutputs.put(key, inputOutput);
        TextField energyField = ((TextField)((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Amount of RF to input/output", "when redstone is " + redstoneState})).setDesiredWidth(42)).setDesiredHeight(14)).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiRelay.this.adjustEnergy((TextField)parent, 0);
            }
        });
        energyField.setText(String.valueOf(rf));
        Button sub100 = this.createEnergyOffsetButton(energyField, "-", -500);
        Button add100 = this.createEnergyOffsetButton(energyField, "+", 500);
        Panel panel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(1)).addChild((Widget)inputOutput)).addChild((Widget)sub100)).addChild((Widget)energyField)).addChild((Widget)add100);
        this.energyValues.put(key, energyField);
        return panel;
    }

    private Button createEnergyOffsetButton(final TextField energyField, String label, final int amount) {
        return ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText(label)).setDesiredHeight(14)).setDesiredWidth(16)).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiRelay.this.adjustEnergy(energyField, amount);
            }
        });
    }

    private void adjustEnergy(TextField energyField, int amount) {
        int energy;
        try {
            energy = Integer.parseInt(energyField.getText());
        }
        catch (NumberFormatException e) {
            energy = 0;
        }
        if ((energy += amount) < 0) {
            energy = 0;
        } else if (energy > 50000) {
            energy = 50000;
        }
        energyField.setText(Integer.toString(energy));
        this.changeSettings();
    }

    private void changeSettings() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        for (int i = 0; i < 6; ++i) {
            this.addArgument(arguments, i, "On");
            this.addArgument(arguments, i, "Off");
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "settings", arguments.toArray(new Argument[arguments.size()]));
    }

    private void addArgument(List<Argument> arguments, int i, String suffix) {
        char prefix = "DUNSWE".charAt(i);
        String key = prefix + suffix;
        int energy = Integer.parseInt(this.energyValues.get(key).getText());
        boolean input = "Input".equals(this.inputOutputs.get(key).getCurrentChoice());
        arguments.add(new Argument(key, energy));
        arguments.add(new Argument(prefix + "In" + suffix, input));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

