/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental.modules;

import java.util.ArrayList;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.playerprops.BuffProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class BuffEModule
implements EnvironmentModule {
    public static final int MAXTICKS = 180;
    private boolean active = false;
    private int ticks = 180;
    private final PlayerBuff buff;

    public BuffEModule(PlayerBuff buff) {
        this.buff = buff;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void tick(World world, int x, int y, int z, int radius, int miny, int maxy, EnvironmentalControllerTileEntity controllerTileEntity) {
        if (!this.active) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 180;
        double maxsqdist = radius * radius;
        ArrayList players = new ArrayList(world.field_73010_i);
        for (EntityPlayer player : players) {
            double pz;
            double px;
            double sqdist;
            double py = player.field_70163_u;
            if (!(py >= (double)miny) || !(py <= (double)maxy) || !((sqdist = ((px = player.field_70165_t) - (double)x) * (px - (double)x) + ((pz = player.field_70161_v) - (double)z) * (pz - (double)z)) < maxsqdist) || !controllerTileEntity.isPlayerAffected(player)) continue;
            BuffProperties.addBuff(player, this.buff, 180);
        }
    }

    @Override
    public void activate(boolean a) {
        if (this.active == a) {
            return;
        }
        this.active = a;
        this.ticks = 1;
    }
}

