/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import cofh.api.energy.IEnergyConnection;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.EndergenicConfiguration;
import mcjty.rftools.blocks.endergen.EndergenicPearl;
import mcjty.rftools.blocks.endergen.GuiEndergenic;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.varia.EnergyTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EndergenicTileEntity
extends GenericEnergyProviderTileEntity
implements MachineInformation {
    private static Random random = new Random();
    public static String CMD_SETDESTINATION = "setDest";
    public static String CMD_GETSTAT_RF = "getStatRF";
    public static String CLIENTCMD_GETSTAT_RF = "getStatRF";
    public static String CMD_GETSTAT_LOST = "getStatLost";
    public static String CLIENTCMD_GETSTAT_LOST = "getStatLost";
    public static String CMD_GETSTAT_LAUNCHED = "getStatLaunched";
    public static String CLIENTCMD_GETSTAT_LAUNCHED = "getStatLaunched";
    public static String CMD_GETSTAT_OPPORTUNITIES = "getStatOpp";
    public static String CLIENTCMD_GETSTAT_OPPORTUNITIES = "getStatOpp";
    private static final String[] TAGS = new String[]{"rftick", "lost", "launched", "opportunities"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"Average RF/tick for the last 5 seconds", "Amount of pearls that were lost during the last 5 seconds", "Amount of pearls that were launched during the last 5 seconds", "Number of opportunities for the last 5 seconds"};
    public static final int CHARGE_IDLE = 0;
    public static final int CHARGE_HOLDING = -1;
    private int chargingMode = 0;
    private int currentAge = 0;
    private Coordinate destination = null;
    private int distance = 0;
    private boolean prevIn = false;
    private int rfGained = 0;
    private int rfLost = 0;
    private int pearlsLaunched = 0;
    private int pearlsLost = 0;
    private int pearlsOpportunities = 0;
    private int ticks = 100;
    private int lastRfPerTick = 0;
    private int lastPearlsLost = 0;
    private int lastPearlsLaunched = 0;
    private int lastPearlOpportunities = 0;
    private List<EndergenicPearl> pearls = new ArrayList<EndergenicPearl>();
    private static int[] rfPerHit = new int[]{0, 100, 150, 200, 400, 800, 1600, 3200, 6400, 8000, 12800, 8000, 6400, 2500, 1000, 100};
    private int tickCounter = 0;
    public static final ForgeDirection[] HORIZ_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    public EndergenicTileEntity() {
        super(5000000, 20000);
    }

    protected void checkStateServer() {
        int meta;
        boolean newvalue;
        super.checkStateServer();
        ++this.tickCounter;
        --this.ticks;
        if (this.ticks < 0) {
            this.lastRfPerTick = (this.rfGained - this.rfLost) / 100;
            this.lastPearlsLost = this.pearlsLost;
            this.lastPearlsLaunched = this.pearlsLaunched;
            this.lastPearlOpportunities = this.pearlsOpportunities;
            this.ticks = 100;
            this.rfGained = 0;
            this.rfLost = 0;
            this.pearlsLaunched = 0;
            this.pearlsLost = 0;
            this.pearlsOpportunities = 0;
        }
        this.handlePearls();
        this.handleSendingEnergy();
        if (this.chargingMode == -1 && random.nextInt(1000) <= EndergenicConfiguration.chanceLost) {
            this.log("Server Tick: discard pearl randomly");
            this.discardPearl();
        }
        boolean pulse = (newvalue = BlockTools.getRedstoneSignalIn((int)(meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)))) && !this.prevIn;
        this.prevIn = newvalue;
        if (pulse) {
            if (this.chargingMode == 0) {
                this.log("Server Tick: pulse -> start charging");
                this.startCharging();
                return;
            }
            if (this.chargingMode == -1) {
                this.log("Server Tick: pulse -> fire pearl");
                this.firePearl();
                return;
            }
        }
        if (this.chargingMode == 0) {
            return;
        }
        if (this.chargingMode == -1) {
            int rf = EndergenicConfiguration.rfToHoldPearl;
            rf = (int)((float)rf * (4.0f - this.getInfusedFactor()) / 4.0f);
            int rfStored = this.getEnergyStored(ForgeDirection.DOWN);
            if (rfStored < rf) {
                this.log("Server Tick: insufficient energy to hold pearl (" + rfStored + " vs " + rf + ")");
                this.discardPearl();
            } else {
                int rfExtracted = this.extractEnergy(ForgeDirection.DOWN, rf, false);
                this.log("Server Tick: holding pearl, consume " + rfExtracted + " RF");
                this.rfLost += rfExtracted;
            }
            return;
        }
        this.func_70296_d();
        ++this.chargingMode;
        if (this.chargingMode >= 16) {
            this.log("Server Tick: charging mode ends -> idle");
            this.chargingMode = 0;
        }
    }

    public int getTagCount() {
        return 4;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return Integer.toString(this.lastRfPerTick);
            }
            case 1: {
                return Integer.toString(this.lastPearlsLost);
            }
            case 2: {
                return Integer.toString(this.lastPearlsLaunched);
            }
            case 3: {
                return Integer.toString(this.lastPearlOpportunities);
            }
        }
        return null;
    }

    private void log(String message) {
    }

    private void fireMonitors(EnderMonitorMode mode) {
        Coordinate pos = this.getCoordinate();
        for (ForgeDirection dir : HORIZ_DIRECTIONS) {
            int meta;
            ForgeDirection k;
            Coordinate c = pos.addDirection(dir);
            TileEntity te = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
            if (!(te instanceof EnderMonitorTileEntity) || (k = BlockTools.getOrientationHoriz((int)(meta = this.field_145850_b.func_72805_g(c.getX(), c.getY(), c.getZ())))) != dir.getOpposite()) continue;
            EnderMonitorTileEntity enderMonitorTileEntity = (EnderMonitorTileEntity)te;
            enderMonitorTileEntity.fireFromEndergenic(mode);
        }
    }

    private void handleSendingEnergy() {
        int energyStored = this.getEnergyStored(ForgeDirection.DOWN);
        if (energyStored <= EndergenicConfiguration.keepRfInBuffer) {
            return;
        }
        energyStored -= EndergenicConfiguration.keepRfInBuffer;
        for (int i = 0; i < 6; ++i) {
            int rfToGive;
            int received;
            ForgeDirection opposite;
            IEnergyConnection connection;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int x = this.field_145851_c + dir.offsetX;
            int y = this.field_145848_d + dir.offsetY;
            int z = this.field_145849_e + dir.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (EnergyTools.isEnergyTE(te) && (connection = (IEnergyConnection)te).canConnectEnergy(opposite = dir.getOpposite()) && (energyStored -= this.extractEnergy(ForgeDirection.DOWN, received = EnergyTools.receiveEnergy(te, opposite, rfToGive = EndergenicConfiguration.rfOutput <= energyStored ? EndergenicConfiguration.rfOutput : energyStored), false)) <= 0) break;
        }
    }

    private void handlePearls() {
        if (this.pearls.isEmpty()) {
            return;
        }
        ArrayList<EndergenicPearl> newlist = new ArrayList<EndergenicPearl>();
        for (EndergenicPearl pearl : this.pearls) {
            this.log("Pearls: age=" + pearl.getAge() + ", ticks left=" + pearl.getTicksLeft());
            if (pearl.handleTick(this.field_145850_b)) continue;
            newlist.add(pearl);
        }
        this.pearls = newlist;
    }

    private void discardPearl() {
        this.spawnParticles("smoke", EndergenicConfiguration.badParticleCount);
        this.func_70296_d();
        ++this.pearlsLost;
        this.chargingMode = 0;
        this.fireMonitors(EnderMonitorMode.MODE_LOSTPEARL);
    }

    private EndergenicTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.destination.getX(), this.destination.getY(), this.destination.getZ());
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        this.destination = null;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    public void firePearl() {
        this.func_70296_d();
        this.getDestinationTE();
        if (this.destination == null) {
            this.log("Fire Pearl: pearl lost due to lack of destination");
            this.discardPearl();
        } else {
            this.log("Fire Pearl: pearl is launched to " + this.destination.getX() + "," + this.destination.getY() + "," + this.destination.getZ());
            this.chargingMode = 0;
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, this.currentAge + 1));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void firePearlFromInjector() {
        this.func_70296_d();
        this.getDestinationTE();
        this.chargingMode = 0;
        if (this.destination == null) {
            this.log("Fire Pearl from injector: pearl lost due to lack of destination");
            this.discardPearl();
        } else {
            this.log("Fire Pearl from injector: pearl is launched to " + this.destination.getX() + "," + this.destination.getY() + "," + this.destination.getZ());
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, 0));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void receivePearl(int age) {
        this.fireMonitors(EnderMonitorMode.MODE_PEARLARRIVED);
        this.func_70296_d();
        if (this.chargingMode == -1) {
            this.log("Receive Pearl: pearl arrives but already holding -> both are lost");
            this.discardPearl();
        } else if (this.chargingMode == 0) {
            this.log("Receive Pearl: pearl arrives but generator is idle -> pearl is lost");
            this.discardPearl();
        } else {
            int rf = (int)((double)rfPerHit[this.chargingMode] * EndergenicConfiguration.powergenFactor);
            rf = (int)((float)rf * (this.getInfusedFactor() + 3.0f) / 3.0f);
            int a = age * 5;
            if (a > 100) {
                a = 100;
            }
            rf += rf * a / 100;
            this.rfGained += rf;
            this.log("Receive Pearl: pearl arrives at tick " + this.chargingMode + ", age=" + age + ", RF=" + rf);
            this.modifyEnergyStored(rf);
            this.spawnParticles("portal", EndergenicConfiguration.goodParticleCount);
            this.chargingMode = -1;
            this.currentAge = age;
        }
    }

    private void spawnParticles(String name, int amount) {
        if (amount <= 0) {
            return;
        }
        float vecX = (random.nextFloat() - 0.5f) * 0.2f;
        float vecY = random.nextFloat() * 0.1f;
        float vecZ = (random.nextFloat() - 0.5f) * 0.2f;
        ((WorldServer)this.field_145850_b).func_147487_a(name, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.1f), (double)((float)this.field_145849_e + 0.5f), amount, (double)vecX, (double)vecY, (double)vecZ, (double)0.3f);
    }

    public void startCharging() {
        this.func_70296_d();
        this.chargingMode = 1;
        ++this.pearlsOpportunities;
    }

    public void useWrench(EntityPlayer player) {
        Coordinate thisCoord = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Coordinate coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.field_145850_b.func_147438_o(coord.getX(), coord.getY(), coord.getZ());
        }
        if (!(tileEntity instanceof EndergenicTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(thisCoord);
            EndergenicTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
                Logging.message((EntityPlayer)player, (String)"Select another endergenic generator as destination");
            } else {
                RFTools.instance.clientInfo.setDestinationTE(new Coordinate(destinationTE.field_145851_c, destinationTE.field_145848_d, destinationTE.field_145849_e));
                int distance = this.getDistanceInTicks();
                Logging.message((EntityPlayer)player, (String)("Select another endergenic generator as destination (current distance " + distance + ")"));
            }
        } else if (coord.equals((Object)thisCoord)) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
        } else {
            EndergenicTileEntity otherTE = (EndergenicTileEntity)tileEntity;
            int distance = otherTE.calculateDistance(thisCoord);
            if (distance >= 5) {
                Logging.warn((EntityPlayer)player, (String)"Distance is too far (maximum 4)");
                return;
            }
            otherTE.setDestination(thisCoord);
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            Logging.message((EntityPlayer)player, (String)("Destination is set (distance " + otherTE.getDistanceInTicks() + " ticks)"));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getChargingMode() {
        return this.chargingMode;
    }

    public int calculateDistance(Coordinate destination) {
        double d = Vec3.func_72443_a((double)destination.getX(), (double)destination.getY(), (double)destination.getZ()).func_72438_d(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e));
        return (int)(d / 3.0) + 1;
    }

    public void setDestination(Coordinate destination) {
        this.func_70296_d();
        this.destination = destination;
        this.distance = this.calculateDistance(destination);
        if (this.field_145850_b.field_72995_K) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.field_145851_c, this.field_145848_d, this.field_145849_e, CMD_SETDESTINATION, new Argument[]{new Argument("dest", destination)}));
        }
    }

    public int getDistanceInTicks() {
        return this.distance;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargingMode = tagCompound.func_74762_e("charging");
        this.currentAge = tagCompound.func_74762_e("age");
        this.destination = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.distance = tagCompound.func_74762_e("distance");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.pearls.clear();
        NBTTagList list = tagCompound.func_150295_c("pearls", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            EndergenicPearl pearl = new EndergenicPearl(tc);
            this.pearls.add(pearl);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("charging", this.chargingMode);
        tagCompound.func_74768_a("age", this.currentAge);
        Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (Coordinate)this.destination);
        tagCompound.func_74768_a("distance", this.distance);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        NBTTagList pearlList = new NBTTagList();
        for (EndergenicPearl pearl : this.pearls) {
            pearlList.func_74742_a((NBTBase)pearl.getTagCompound());
        }
        tagCompound.func_74782_a("pearls", (NBTBase)pearlList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETDESTINATION.equals(command)) {
            this.setDestination(args.get("dest").getCoordinate());
            return true;
        }
        return false;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETSTAT_RF.equals(command)) {
            return this.lastRfPerTick;
        }
        if (CMD_GETSTAT_LOST.equals(command)) {
            return this.lastPearlsLost;
        }
        if (CMD_GETSTAT_LAUNCHED.equals(command)) {
            return this.lastPearlsLaunched;
        }
        if (CMD_GETSTAT_OPPORTUNITIES.equals(command)) {
            return this.lastPearlOpportunities;
        }
        return null;
    }

    public boolean execute(String command, Integer value) {
        boolean rc = super.execute(command, value);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_GETSTAT_RF.equals(command)) {
            GuiEndergenic.fromServer_lastRfPerTick = value;
            return true;
        }
        if (CLIENTCMD_GETSTAT_LOST.equals(command)) {
            GuiEndergenic.fromServer_lastPearlsLost = value;
            return true;
        }
        if (CLIENTCMD_GETSTAT_LAUNCHED.equals(command)) {
            GuiEndergenic.fromServer_lastPearlsLaunched = value;
            return true;
        }
        if (CLIENTCMD_GETSTAT_OPPORTUNITIES.equals(command)) {
            GuiEndergenic.fromServer_lastPearlOpportunities = value;
            return true;
        }
        return false;
    }
}

