/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cofh.api.energy.IEnergyConnection;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.varia.EnergyTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyExtractorTileEntity
extends GenericEnergyProviderTileEntity {
    public EnergyExtractorTileEntity() {
        super(DimletConfiguration.EXTRACTOR_MAXENERGY, DimletConfiguration.EXTRACTOR_SENDPERTICK);
    }

    protected void checkStateServer() {
        super.checkStateServer();
        int energyStored = this.getEnergyStored(ForgeDirection.DOWN);
        if (energyStored < DimletConfiguration.EXTRACTOR_MAXENERGY) {
            int needed = DimletConfiguration.EXTRACTOR_MAXENERGY - energyStored;
            DimensionStorage storage = DimensionStorage.getDimensionStorage(this.field_145850_b);
            int dimensionEnergy = storage.getEnergyLevel(this.field_145850_b.field_73011_w.field_76574_g);
            if (needed > dimensionEnergy) {
                needed = dimensionEnergy;
            }
            if (needed > 0) {
                energyStored += needed;
                this.modifyEnergyStored(needed);
                storage.setEnergyLevel(this.field_145850_b.field_73011_w.field_76574_g, dimensionEnergy -= needed);
                storage.save(this.field_145850_b);
            }
        }
        if (energyStored <= 0) {
            return;
        }
        int rf = DimletConfiguration.EXTRACTOR_SENDPERTICK;
        for (int i = 0; i < 6; ++i) {
            int rfToGive;
            int received;
            ForgeDirection opposite;
            IEnergyConnection connection;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!EnergyTools.isEnergyTE(te) || !(connection = (IEnergyConnection)te).canConnectEnergy(opposite = dir.getOpposite()) || (energyStored -= this.extractEnergy(ForgeDirection.DOWN, received = EnergyTools.receiveEnergy(te, opposite, rfToGive = rf <= energyStored ? rf : energyStored), false)) > 0) continue;
            return;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
    }
}

