/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.dimlets.DimensionBuilderContainer;
import mcjty.rftools.blocks.dimlets.DimensionBuilderTileEntity;
import mcjty.rftools.blocks.dimlets.GuiDimensionBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class DimensionBuilderBlock
extends GenericRFToolsBlock
implements Infusable,
IRedstoneConnectable {
    private IIcon iconFrontEmpty;
    private IIcon iconFrontBusy1;
    private IIcon iconFrontBusy2;

    public DimensionBuilderBlock(boolean creative, String blockName) {
        super(Material.field_151573_f, DimensionBuilderTileEntity.class, true);
        this.func_149663_c(blockName);
        this.setHorizRotation(true);
        this.func_149647_a(RFTools.tabRfTools);
        this.setCreative(creative);
    }

    public int getGuiID() {
        return RFTools.GUI_DIMENSION_BUILDER;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFrontEmpty = this.isCreative() ? iconRegister.func_94245_a("rftools:machineDimensionBuilderC_empty") : iconRegister.func_94245_a("rftools:machineDimensionBuilder_empty");
        this.iconFrontBusy1 = iconRegister.func_94245_a("rftools:machineDimensionBuilder_busy1");
        this.iconFrontBusy2 = iconRegister.func_94245_a("rftools:machineDimensionBuilder_busy2");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This builds a dimension and powers it when");
            list.add(EnumChatFormatting.WHITE + "the dimension is ready.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(EnumChatFormatting.YELLOW + "faster dimension creation speed.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        DimensionBuilderTileEntity dimensionBuilderTileEntity = (DimensionBuilderTileEntity)tileEntity;
        DimensionBuilderContainer dimensionBuilderContainer = new DimensionBuilderContainer(entityPlayer, dimensionBuilderTileEntity);
        return new GuiDimensionBuilder(dimensionBuilderTileEntity, dimensionBuilderContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new DimensionBuilderContainer(entityPlayer, (DimensionBuilderTileEntity)tileEntity);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstoneWithTE(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public String getIdentifyingIconName() {
        if (this.isCreative()) {
            return "machineDimensionBuilderC";
        }
        return "machineDimensionBuilder";
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int state = BlockTools.getState((int)meta);
        if (state == 0) {
            return 10;
        }
        return this.func_149750_m();
    }

    public IIcon getIconInd(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        int state = BlockTools.getState((int)meta);
        switch (state) {
            case 0: {
                return this.iconInd;
            }
            case 1: {
                return this.iconFrontEmpty;
            }
            case 2: {
                return this.iconFrontBusy1;
            }
            case 3: {
                return this.iconFrontBusy2;
            }
        }
        return this.iconInd;
    }
}

