/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;

public class PacketProgress
extends MessageTileEntity<TileEntity> {
    private float progress;

    public PacketProgress() {
    }

    public PacketProgress(IProgressTile tile) {
        super(tile.getTileEntity());
        this.progress = tile.getProgress();
        if (this.progress == 0.0f) {
            this.progress = -1.0f;
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
    }

    public static class Handler
    implements IMessageHandler<PacketProgress, IMessage> {
        public IMessage onMessage(PacketProgress message, MessageContext ctx) {
            Object tile = message.getTileEntity(EnderCore.proxy.getClientWorld());
            if (tile instanceof IProgressTile) {
                ((IProgressTile)tile).setProgress(message.progress);
            }
            return null;
        }
    }
}

