/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import openeye.notes.WrappedChatComponent;

public class ScreenNotificationHolder {
    private final ChatStyle REMOVE_FILE_STYLE = new ChatStyle().func_150227_a(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.RED);
    private final ChatStyle KNOWN_CRASH_STYLE = new ChatStyle().func_150238_a(EnumChatFormatting.GREEN);
    private final ChatStyle INTRO_STYLE = new ChatStyle().func_150238_a(EnumChatFormatting.GOLD);
    private Entry selectedLine;

    public void addLine(int level, IChatComponent msg) {
        if (this.selectedLine == null || level > this.selectedLine.level) {
            this.selectedLine = new Entry(level, msg);
        }
    }

    public void signalDangerousFile() {
        this.addLine(64, new ChatComponentTranslation("openeye.main_screen.remove_file", new Object[0]).func_150255_a(this.REMOVE_FILE_STYLE));
    }

    public void signalCrashReported() {
        this.addLine(8, (IChatComponent)new ChatComponentTranslation("openeye.main_screen.crash_reported", new Object[0]));
    }

    public void signalKnownCrash() {
        this.addLine(32, new ChatComponentTranslation("openeye.main_screen.known_crash", new Object[0]).func_150255_a(this.KNOWN_CRASH_STYLE));
    }

    public void signalIntroStuff() {
        this.addLine(256, new ChatComponentTranslation("openeye.main_screen.intro", new Object[0]).func_150255_a(this.INTRO_STYLE));
    }

    public WrappedChatComponent getSelectedLine() {
        return this.selectedLine != null ? this.selectedLine.msg : null;
    }

    private static class Entry {
        final int level;
        public final WrappedChatComponent msg;

        private Entry(int level, IChatComponent msg) {
            this.level = level;
            this.msg = new WrappedChatComponent(msg);
        }
    }
}

