/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.tank;

import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.tank.TileTank;
import cofh.thermalexpansion.block.tank.TileTankCreative;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockTank
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 1.0f, 3.0f, 4.0f, 4.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack tankCreative;
    public static ItemStack tankBasic;
    public static ItemStack tankHardened;
    public static ItemStack tankReinforced;
    public static ItemStack tankResonant;

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_149711_c(4.0f);
        this.func_149752_b(120.0f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149663_c("thermalexpansion.tank");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        if (n == Types.CREATIVE.ordinal()) {
            if (!enable[Types.CREATIVE.ordinal()]) {
                return null;
            }
            return new TileTankCreative(n);
        }
        return new TileTank(n);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (enable[0]) {
            list.add(new ItemStack(item, 1, 0));
        }
        for (int i = 1; i < Types.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        FluidStack fluidStack;
        if (world.func_72805_g(n, n2, n3) == 0 && !enable[0]) {
            world.func_147468_f(n, n2, n3);
            return;
        }
        if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("Fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"))) != null) {
            TileTank tileTank = (TileTank)world.func_147438_o(n, n2, n3);
            tileTank.tank.setFluid(fluidStack);
            tileTank.calcLastDisplay();
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    @Override
    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        if (super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3)) {
            return true;
        }
        TileTank tileTank = (TileTank)world.func_147438_o(n, n2, n3);
        if (FluidHelper.fillHandlerWithContainer((World)tileTank.func_145831_w(), (IFluidHandler)tileTank, (EntityPlayer)entityPlayer)) {
            return true;
        }
        if (FluidHelper.fillContainerFromHandler((World)tileTank.func_145831_w(), (IFluidHandler)tileTank, (EntityPlayer)entityPlayer, (FluidStack)tileTank.getTankFluid())) {
            return true;
        }
        if (ItemHelper.isPlayerHoldingFluidContainer((EntityPlayer)entityPlayer)) {
            return true;
        }
        return super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3);
    }

    public float func_149712_f(World world, int n, int n2, int n3) {
        return HARDNESS[world.func_72805_g(n, n2, n3)];
    }

    public float getExplosionResistance(Entity entity, World world, int n, int n2, int n3, double d, double d2, double d3) {
        return RESISTANCE[world.func_72805_g(n, n2, n3)];
    }

    public int func_149645_b() {
        return TEProps.renderIdTank;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return forgeDirection == ForgeDirection.UP || forgeDirection == ForgeDirection.DOWN;
    }

    public boolean func_149740_M() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        for (int i = 0; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("TankBottom" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Bottom_Blue"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("TankBottom" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Bottom_Orange"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("TankTop" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Top_Blue"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("TankTop" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Top_Orange"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("TankSide" + 2 * i), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Side_Blue"), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("TankSide" + (2 * i + 1)), (String)("thermalexpansion:tank/Tank_" + StringHelper.titleCase((String)NAMES[i]) + "_Side_Orange"), (IIconRegister)iIconRegister);
        }
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        FluidStack fluidStack;
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileTank tileTank = (TileTank)world.func_147438_o(n, n2, n3);
        if (tileTank != null && (fluidStack = tileTank.getTankFluid()) != null) {
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("Fluid", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return nBTTagCompound;
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (world.func_72805_g(n, n2, n3) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)entityPlayer)) {
            return false;
        }
        return super.canDismantle(entityPlayer, world, n, n2, n3);
    }

    public boolean initialize() {
        TileTank.initialize();
        TileTankCreative.initialize();
        tankCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        tankBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        tankHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        tankReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        tankResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"tankCreative", (ItemStack)tankCreative);
        GameRegistry.registerCustomItemStack((String)"tankBasic", (ItemStack)tankBasic);
        GameRegistry.registerCustomItemStack((String)"tankHardened", (ItemStack)tankHardened);
        GameRegistry.registerCustomItemStack((String)"tankReinforced", (ItemStack)tankReinforced);
        GameRegistry.registerCustomItemStack((String)"tankResonant", (ItemStack)tankResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)tankBasic, (Object[])new Object[]{" G ", "GXG", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('X'), "ingotCopper"}));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(tankHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), tankBasic}));
            GameRegistry.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)tankHardened, (Object[])new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), "ingotCopper", Character.valueOf('G'), "blockGlass"}));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(tankReinforced, new Object[]{" G ", "GXG", " G ", Character.valueOf('G'), "blockGlassHardened", Character.valueOf('X'), tankHardened}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(tankResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), tankReinforced}));
        }
        return true;
    }

    static {
        String string = "Tank.";
        BlockTank.enable[0] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[0]), "Enable", true);
        for (int i = 1; i < Types.values().length; ++i) {
            BlockTank.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

